/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.client.requirement.RequirementClientRegistry;
import net.blay09.mods.waystones.client.requirement.RequirementRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class WaystoneButton
extends class_4185 {
    private final WarpRequirement warpRequirement;
    private final Waystone waystone;

    public WaystoneButton(int x, int y, Waystone waystone, WarpRequirement warpRequirement, class_4185.class_4241 pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable, class_4185.field_40754);
        class_746 player = class_310.method_1551().field_1724;
        this.warpRequirement = warpRequirement;
        this.waystone = waystone;
        if (player == null) {
            this.field_22763 = false;
        } else if (!warpRequirement.canAfford((class_1657)player) && !player.method_31549().field_7477) {
            this.field_22763 = false;
        }
    }

    private static class_2561 getWaystoneNameComponent(Waystone waystone) {
        class_5250 effectiveName = waystone.getName().method_27661();
        if (effectiveName.getString().isEmpty()) {
            effectiveName = class_2561.method_43471((String)"gui.waystones.waystone_selection.unnamed_waystone");
        }
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            effectiveName.method_27692(class_124.field_1054);
        }
        return effectiveName;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        class_327 font = class_310.method_1551().field_1772;
        class_746 player = class_310.method_1551().field_1724;
        if (this.waystone.getDimension() == player.method_37908().method_27983() && this.method_37303()) {
            int distance = (int)player.method_19538().method_1022(this.waystone.getPos().method_46558());
            String distanceStr = distance < 10000 && (font.method_27525((class_5348)this.method_25369()) < 120 || distance < 1000) ? distance + "m" : String.format("%.1f", Float.valueOf((float)distance / 1000.0f)).replace(",0", "").replace(".0", "") + "km";
            int xOffset = this.method_25368() - font.method_1727(distanceStr);
            guiGraphics.method_25303(font, distanceStr, this.method_46426() + xOffset - 4, this.method_46427() + 6, -1);
        }
        this.renderRequirements(this.warpRequirement, guiGraphics, mouseX, mouseY, partialTicks);
    }

    private <T extends WarpRequirement> void renderRequirements(T requirement, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_327 font = class_310.method_1551().field_1772;
        class_746 player = class_310.method_1551().field_1724;
        RequirementRenderer<Class<?>> renderer = RequirementClientRegistry.getRenderer(requirement.getClass());
        if (renderer != null) {
            renderer.renderWidget((class_1657)player, (Class<?>)((Object)requirement), guiGraphics, mouseX, mouseY, partialTicks, this.method_46426() + 2, this.method_46427() + 2);
            if (this.field_22762 && mouseX < this.method_46426() + 2 + renderer.getWidth((class_1657)player, (Class<?>)((Object)requirement))) {
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
                this.warpRequirement.appendHoverText((class_1657)player, tooltip);
                Optional optional = Optional.empty();
                Objects.requireNonNull(font);
                guiGraphics.method_64038(font, tooltip, optional, mouseX, mouseY + 9);
            }
        }
    }
}

