/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.network.packet.c2s.CrawlPayloadC2S;

public class CrawlTracker
implements Tracker {
    private boolean wasCrawling;
    public boolean crawling;
    public boolean crawlsteresis;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public CrawlTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrSettings.allowCrawling) {
            return false;
        }
        if (!ClientNetworking.SERVER_ALLOWS_CRAWLING) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        if (player.method_6113()) {
            return false;
        }
        return !player.method_5765();
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.crawling = false;
        this.crawlsteresis = false;
        this.updateState(player);
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        float scaledWorldScale = this.dh.vrPlayer.worldScale / ScaleHelper.getEntityEyeHeightScale((class_1309)player, ClientUtils.getCurrentPartialTick());
        this.crawling = this.dh.vr.hmdPivotHistory.averagePosition((double)((double)0.2f)).y * scaledWorldScale + 0.1f < this.dh.vrSettings.crawlThreshold;
        this.updateState(player);
    }

    private void updateState(class_746 player) {
        if (this.crawling != this.wasCrawling) {
            if (this.crawling) {
                player.method_18380(class_4050.field_18079);
                this.crawlsteresis = true;
            }
            if (ClientNetworking.SERVER_ALLOWS_CRAWLING) {
                ClientNetworking.sendServerPacket(new CrawlPayloadC2S(this.crawling));
            }
            this.wasCrawling = this.crawling;
        }
        if (!this.crawling && player.method_18376() != class_4050.field_18079) {
            this.crawlsteresis = false;
        }
    }
}

