/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2588;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.JumpTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.common.network.packet.c2s.ClimbingPayloadC2S;
import org.vivecraft.data.ViveBlockTags;
import org.vivecraft.server.config.enums.ClimbeyBlockmode;

public class ClimbTracker
implements Tracker {
    public static final class_2960 CLAWS_MODEL = class_2960.method_60655((String)"vivecraft", (String)"climb_claws");
    public Set<class_2248> blocklist = new HashSet<class_2248>();
    public ClimbeyBlockmode serverBlockmode = ClimbeyBlockmode.DISABLED;
    public boolean forceActivate = false;
    public int latchStartController = -1;
    public class_243[] latchStart = new class_243[]{class_243.field_1353, class_243.field_1353};
    public Vector3f[] latchStart_room = new Vector3f[]{new Vector3f(), new Vector3f()};
    public class_243[] latchStartBody = new class_243[]{class_243.field_1353, class_243.field_1353};
    private boolean gravityOverride = false;
    private boolean wantJump = false;
    private final boolean[] latched = new boolean[2];
    private final boolean[] wasInBlock = new boolean[2];
    private final boolean[] wasButton = new boolean[2];
    private final boolean[] wasLatched = new boolean[2];
    private final class_238[] box = new class_238[2];
    private final class_238[] latchBox = new class_238[2];
    private final boolean[] inBlock = new boolean[2];
    private final class_2350[] grabDirection = new class_2350[2];
    private final class_238 northBB = new class_238(0.1, 0.0, 0.9, 0.9, 1.0, 1.1);
    private final class_238 southBB = new class_238(0.1, 0.0, -0.1, 0.9, 1.0, 0.1);
    private final class_238 westBB = new class_238(0.9, 0.0, 0.1, 1.1, 1.0, 0.9);
    private final class_238 eastBB = new class_238(-0.1, 0.0, 0.1, 0.1, 1.0, 0.9);
    private final class_238 upBB = new class_238(0.0, 0.9, 0.0, 1.0, 1.1, 1.0);
    private final class_238 fullBB = new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final Random rand = new Random();
    private boolean unsetFlag;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public ClimbTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    public boolean isGrabbingLadder() {
        return this.latched[0] || this.latched[1];
    }

    public boolean wasGrabbingLadder() {
        return this.wasLatched[0] || this.latched[1];
    }

    public boolean isGrabbingLadder(int controller) {
        return this.latched[controller];
    }

    public boolean wasGrabbingLadder(int controller) {
        return this.wasLatched[controller];
    }

    public boolean isClimbeyClimb() {
        return this.isActive(this.mc.field_1724) && ClimbTracker.hasClimbeyClimbEquipped((class_1657)this.mc.field_1724);
    }

    public static boolean hasClimbeyClimbEquipped(class_1657 player) {
        return ClientNetworking.SERVER_ALLOWS_CLIMBEY && (ClimbTracker.isClaws(player.method_6047()) || ClimbTracker.isClaws(player.method_6079()));
    }

    public static boolean isClaws(class_1799 itemStack) {
        class_2588 translatableContent;
        class_7417 class_74172;
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        if (!itemStack.method_57826(class_9334.field_49631)) {
            return false;
        }
        if (itemStack.method_7909() != class_1802.field_8868) {
            return false;
        }
        if (!itemStack.method_57826(class_9334.field_49630)) {
            return false;
        }
        return itemStack.method_7964().getString().equals("Climb Claws") || (class_74172 = itemStack.method_7964().method_10851()) instanceof class_2588 && (translatableContent = (class_2588)class_74172).method_11022().equals("vivecraft.item.climbclaws");
    }

    private static boolean canStand(class_2338 blockPos, class_746 player) {
        class_265 blockShape = player.method_37908().method_8320(blockPos).method_26220((class_1922)player.method_37908(), blockPos);
        if (blockShape.method_1110() || blockShape.method_1107().field_1325 != 0.0) {
            class_2338 above = blockPos.method_10084();
            class_265 aboveBlockShape = player.method_37908().method_8320(above).method_26220((class_1922)player.method_37908(), above);
            if (aboveBlockShape.method_1110() || aboveBlockShape.method_1107().field_1325 > 0.0) {
                return false;
            }
            class_2338 above2 = above.method_10084();
            class_265 above2BlockShape = player.method_37908().method_8320(above2).method_26220((class_1922)player.method_37908(), above2);
            return above2BlockShape.method_1110() || above2BlockShape.method_1107().field_1325 <= 0.0;
        }
        return false;
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrPlayer.getFreeMove() && !this.dh.vrSettings.simulateFalling) {
            return false;
        }
        if (!this.dh.vrSettings.realisticClimbEnabled) {
            return false;
        }
        if (player == null && !player.method_5805()) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (player.method_5765()) {
            return false;
        }
        return ClimbTracker.hasClimbeyClimbEquipped((class_1657)player) || player.field_6250 == 0.0f && player.field_6212 == 0.0f;
    }

    @Override
    public void idleProcess(class_746 player) {
        if (!this.isActive(player)) {
            this.wasLatched[0] = false;
            this.wasLatched[1] = false;
        }
        if (this.wasGrabbingLadder() && !this.isGrabbingLadder()) {
            this.forceActivate = true;
        } else if (player.method_24828() || player.method_31549().field_7479) {
            this.forceActivate = false;
        }
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.RIGHT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inBlock[0] || this.forceActivate));
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.LEFT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inBlock[1] || this.forceActivate));
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.latchStartController = -1;
        this.latched[0] = false;
        this.latched[1] = false;
        player.method_5875(false);
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        int c;
        boolean[] button = new boolean[2];
        boolean[] allowed = new boolean[2];
        class_243[] controllerPos = new class_243[2];
        boolean nope = false;
        boolean grabbed = false;
        boolean jump = false;
        boolean ladder = false;
        for (c = 0; c < 2; ++c) {
            controllerPos[c] = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition();
            Vector3f controllerDir = this.dh.vrPlayer.vrdata_world_pre.getController(c).getDirection();
            this.inBlock[c] = false;
            class_2338 blockPos = class_2338.method_49638((class_2374)controllerPos[c]);
            class_2680 blockState = this.mc.field_1687.method_8320(blockPos);
            class_2248 block = blockState.method_26204();
            class_265 voxelShape = blockState.method_26220((class_1922)this.mc.field_1687, blockPos);
            this.box[c] = voxelShape.method_1110() ? null : voxelShape.method_1107();
            if (!this.dh.climbTracker.isClimbeyClimb()) {
                class_2338 blockPos2;
                Object blockState2;
                class_2248 block2;
                boolean ok;
                class_243 controllerPosNear = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition().method_1023((double)(controllerDir.x * 0.2f), (double)(controllerDir.y * 0.2f), (double)(controllerDir.z * 0.2f));
                class_238 controllerBB = new class_238(controllerPos[c], controllerPosNear);
                ladder = true;
                boolean bl = ok = block instanceof class_2399 || this.isClimbableTrapdoor((class_1937)this.mc.field_1687, blockPos, blockState) || block instanceof class_2541 || blockState.method_26164(ViveBlockTags.VIVECRAFT_CLIMBABLE);
                if (!ok && ((block2 = (blockState2 = this.mc.field_1687.method_8320(blockPos2 = class_2338.method_49638((class_2374)controllerPosNear))).method_26204()) instanceof class_2399 || this.isClimbableTrapdoor((class_1937)this.mc.field_1687, blockPos2, (class_2680)blockState2) || block2 instanceof class_2541 || blockState2.method_26164(ViveBlockTags.VIVECRAFT_CLIMBABLE))) {
                    blockPos = blockPos2;
                    blockState = blockState2;
                    block = block2;
                    controllerPos[c] = controllerPosNear;
                    class_265 voxelShape2 = blockState2.method_26220((class_1922)this.mc.field_1687, blockPos2);
                    if (voxelShape2.method_1110()) {
                        this.box[c] = null;
                    } else {
                        ok = true;
                        this.box[c] = voxelShape2.method_1107();
                    }
                }
                if (ok) {
                    ArrayList<class_238> BBs = new ArrayList<class_238>();
                    if (block instanceof class_2399 || block instanceof class_2383) {
                        switch ((class_2350)blockState.method_11654((class_2769)class_2383.field_11177)) {
                            case field_11034: {
                                BBs.add(this.eastBB);
                                break;
                            }
                            case field_11043: {
                                BBs.add(this.northBB);
                                break;
                            }
                            case field_11035: {
                                BBs.add(this.southBB);
                                break;
                            }
                            case field_11039: {
                                BBs.add(this.westBB);
                                break;
                            }
                            default: {
                                ok = false;
                            }
                        }
                    }
                    if (block instanceof class_2541) {
                        this.box[c] = new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                        if (((Boolean)blockState.method_11654((class_2769)class_2541.field_11706)).booleanValue() && this.mc.field_1687.method_8320(blockPos.method_10095()).method_26225()) {
                            BBs.add(this.southBB);
                        }
                        if (((Boolean)blockState.method_11654((class_2769)class_2541.field_11702)).booleanValue() && this.mc.field_1687.method_8320(blockPos.method_10078()).method_26225()) {
                            BBs.add(this.westBB);
                        }
                        if (((Boolean)blockState.method_11654((class_2769)class_2541.field_11699)).booleanValue() && this.mc.field_1687.method_8320(blockPos.method_10072()).method_26225()) {
                            BBs.add(this.northBB);
                        }
                        if (((Boolean)blockState.method_11654((class_2769)class_2541.field_11696)).booleanValue() && this.mc.field_1687.method_8320(blockPos.method_10067()).method_26225()) {
                            BBs.add(this.eastBB);
                        }
                    }
                    this.inBlock[c] = false;
                    if (ok) {
                        blockState2 = BBs.iterator();
                        while (blockState2.hasNext()) {
                            class_238 aabb2 = (class_238)blockState2.next();
                            if (!controllerBB.method_994(aabb2.method_996(blockPos))) continue;
                            this.inBlock[c] = true;
                            if (aabb2 == this.northBB) {
                                this.grabDirection[c] = class_2350.field_11043;
                            } else if (aabb2 == this.southBB) {
                                this.grabDirection[c] = class_2350.field_11035;
                            } else if (aabb2 == this.eastBB) {
                                this.grabDirection[c] = class_2350.field_11034;
                            } else if (aabb2 == this.westBB) {
                                this.grabDirection[c] = class_2350.field_11039;
                            }
                            break;
                        }
                    }
                } else {
                    class_243 handToLatch = this.latchStart[c].method_1020(controllerPos[c]);
                    if (handToLatch.method_1033() > 0.5) {
                        this.inBlock[c] = false;
                    } else {
                        class_2338 latchBlockPos = class_2338.method_49638((class_2374)this.latchStart[c]);
                        class_2680 latchBlockState = this.mc.field_1687.method_8320(latchBlockPos);
                        this.inBlock[c] = this.wasInBlock[c] && latchBlockState.method_26204() instanceof class_2399 || latchBlockState.method_26204() instanceof class_2541 || latchBlockState.method_26164(ViveBlockTags.VIVECRAFT_CLIMBABLE);
                    }
                }
                button[c] = this.inBlock[c];
                allowed[c] = this.inBlock[c];
            } else {
                class_243 handToLatch;
                if (this.mc.field_1724.method_24828()) {
                    this.mc.field_1724.method_24830(!this.latched[0] && !this.latched[1]);
                }
                button[c] = c == 0 ? VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) : VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT);
                boolean bl = this.inBlock[c] = this.box[c] != null && this.box[c].method_996(blockPos).method_1006(controllerPos[c]);
                if (!this.inBlock[c] && (handToLatch = this.latchStart[c].method_1020(controllerPos[c])).method_1033() > 0.5) {
                    button[c] = false;
                }
                allowed[c] = this.allowed(blockState);
            }
            this.wasLatched[c] = this.latched[c];
            if (!button[c] && this.latched[c]) {
                this.latched[c] = false;
                if (c == 0) {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                } else {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
                }
                jump = true;
            }
            if (!this.latched[c] && !nope && allowed[c]) {
                if (!this.wasInBlock[c] && this.inBlock[c]) {
                    this.dh.vr.triggerHapticPulse(c, 750);
                }
                if (!this.wasInBlock[c] && this.inBlock[c] && button[c] || !this.wasButton[c] && button[c] && this.inBlock[c]) {
                    grabbed = true;
                    this.wantJump = false;
                    this.latchStart[c] = controllerPos[c];
                    this.latchStart_room[c] = this.dh.vrPlayer.vrdata_room_pre.getController(c).getPositionF();
                    this.latchStartBody[c] = player.method_19538();
                    this.latchStartController = c;
                    this.latchBox[c] = this.box[c];
                    this.latched[c] = true;
                    if (c == 0) {
                        this.latched[1] = false;
                        nope = true;
                    } else {
                        this.latched[0] = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 2000);
                    ((PlayerExtension)this.mc.field_1724).vivecraft$stepSound(blockPos, this.latchStart[c]);
                    if (!ladder) {
                        this.dh.vrPlayer.blockDust(this.latchStart[c].field_1352, this.latchStart[c].field_1351, this.latchStart[c].field_1350, 5, blockPos, blockState, 0.1f, 0.2f);
                    }
                }
            }
            this.wasButton[c] = button[c];
            this.wasInBlock[c] = this.inBlock[c];
        }
        if (!this.latched[0] && !this.latched[1]) {
            for (c = 0; c < 2; ++c) {
                if (!this.inBlock[c] || !button[c] || !allowed[c]) continue;
                grabbed = true;
                this.latchStart[c] = controllerPos[c];
                this.latchStart_room[c] = this.dh.vrPlayer.vrdata_room_pre.getController(c).getPositionF();
                this.latchStartBody[c] = player.method_19538();
                this.latchStartController = c;
                this.latched[c] = true;
                this.latchBox[c] = this.box[c];
                this.wantJump = false;
                this.dh.vr.triggerHapticPulse(c, 2000);
                if (ladder) continue;
                class_2338 blockPos = class_2338.method_49638((class_2374)this.latchStart[c]);
                class_2680 blockState = this.mc.field_1687.method_8320(blockPos);
                this.dh.vrPlayer.blockDust(this.latchStart[c].field_1352, this.latchStart[c].field_1351, this.latchStart[c].field_1350, 5, blockPos, blockState, 0.1f, 0.2f);
            }
        }
        if (!this.wantJump && !ladder) {
            this.wantJump = VivecraftVRMod.INSTANCE.keyClimbeyJump.method_1434() && JumpTracker.hasClimbeyJumpEquipped((class_1657)player);
        }
        jump &= this.wantJump;
        if ((this.latched[0] || this.latched[1]) && !this.gravityOverride) {
            this.unsetFlag = true;
            player.method_5875(true);
            this.gravityOverride = true;
        }
        if (!this.latched[0] && !this.latched[1] && this.gravityOverride) {
            player.method_5875(false);
            this.gravityOverride = false;
        }
        if (!(this.latched[0] || this.latched[1] || jump)) {
            if (player.method_24828() && this.unsetFlag) {
                this.unsetFlag = false;
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
            }
            this.latchStartController = -1;
            return;
        }
        if ((this.latched[0] || this.latched[1]) && this.rand.nextInt(20) == 10) {
            this.mc.field_1724.method_7322(0.1f);
            if (!ladder) {
                class_2338 blockPos = class_2338.method_49638((class_2374)this.latchStart[this.latchStartController]);
                class_2680 blockState = this.mc.field_1687.method_8320(blockPos);
                this.dh.vrPlayer.blockDust(this.latchStart[this.latchStartController].field_1352, this.latchStart[this.latchStartController].field_1351, this.latchStart[this.latchStartController].field_1350, 1, blockPos, blockState, 0.1f, 0.2f);
            }
        }
        class_243 now = this.dh.vrPlayer.vrdata_world_pre.getController(this.latchStartController).getPosition();
        class_243 start = VRPlayer.roomToWorldPos((Vector3fc)this.latchStart_room[this.latchStartController], this.dh.vrPlayer.vrdata_world_pre);
        class_243 delta = now.method_1020(start);
        this.latchStart_room[this.latchStartController] = this.dh.vrPlayer.vrdata_room_pre.getController(this.latchStartController).getPositionF();
        if (this.wantJump) {
            this.dh.vr.triggerHapticPulse(this.latchStartController, 200);
        }
        if (!jump) {
            if (grabbed) {
                player.method_18800(0.0, 0.0, 0.0);
            } else {
                player.method_18800(player.method_18798().field_1352, 0.0, player.method_18798().field_1350);
            }
            player.field_6017 = 0.0;
            double x = player.method_23317();
            double y = player.method_23318();
            double z = player.method_23321();
            double newX = x;
            double newY = y - delta.field_1351;
            double newZ = z;
            class_2338 blockPos = class_2338.method_49638((class_2374)this.latchStart[this.latchStartController]);
            if (!ladder) {
                newX = x - delta.field_1352;
                newZ = z - delta.field_1350;
            } else {
                class_2350 dir = this.grabDirection[this.latchStartController];
                if (dir == class_2350.field_11043 || dir == class_2350.field_11035) {
                    newX = x - delta.field_1352;
                    newZ = (float)blockPos.method_10260() + 0.5f;
                    newZ += (1.0 - Math.min((double)this.dh.vrPlayer.worldScale, 1.0)) * (dir == class_2350.field_11043 ? 0.5 : -0.5);
                } else if (dir == class_2350.field_11034 || dir == class_2350.field_11039) {
                    newZ = z - delta.field_1350;
                    newX = (float)blockPos.method_10263() + 0.5f;
                    newX += (1.0 - Math.min((double)this.dh.vrPlayer.worldScale, 1.0)) * (dir == class_2350.field_11039 ? 0.5 : -0.5);
                }
            }
            double hmd = this.dh.vrPlayer.vrdata_room_pre.getHeadPivot().field_1351;
            double controller = this.dh.vrPlayer.vrdata_room_pre.getController((int)this.latchStartController).getPosition().field_1351;
            if (!this.wantJump && this.latchBox[this.latchStartController] != null && controller <= hmd / 2.0 && this.latchStart[this.latchStartController].field_1351 > this.latchBox[this.latchStartController].field_1325 * 0.8 + (double)blockPos.method_10264()) {
                Vector3f horizontalDir = this.dh.vrPlayer.vrdata_world_pre.hmd.getDirection();
                horizontalDir.y = 0.0f;
                horizontalDir.normalize().mul(0.1f);
                boolean ok = this.mc.field_1687.method_8587((class_1297)player, player.method_5829().method_989((double)horizontalDir.x, this.latchBox[this.latchStartController].field_1325 + (double)blockPos.method_10264() - player.method_23318(), (double)horizontalDir.z));
                if (ok) {
                    newX = player.method_23317() + (double)horizontalDir.x;
                    newY = this.latchBox[this.latchStartController].field_1325 + (double)blockPos.method_10264();
                    newZ = player.method_23321() + (double)horizontalDir.z;
                    this.latchStartController = -1;
                    this.latched[0] = false;
                    this.latched[1] = false;
                    this.wasInBlock[0] = false;
                    this.wasInBlock[1] = false;
                    player.method_5875(false);
                }
            }
            boolean free = false;
            for (int i = 0; i < 8; ++i) {
                double ax = newX;
                double ay = newY;
                double az = newZ;
                switch (i) {
                    case 2: {
                        ay = y;
                        break;
                    }
                    case 3: {
                        az = z;
                        break;
                    }
                    case 4: {
                        ax = x;
                        break;
                    }
                    case 5: {
                        ax = x;
                        az = z;
                        break;
                    }
                    case 6: {
                        ax = x;
                        ay = y;
                        break;
                    }
                    case 7: {
                        ay = y;
                        az = z;
                        break;
                    }
                }
                player.method_5814(ax, ay, az);
                class_238 bb = player.method_5829();
                free = this.mc.field_1687.method_8587((class_1297)player, bb);
                if (!free) continue;
                if (i <= 1) break;
                this.dh.vr.triggerHapticPulse(0, 100);
                this.dh.vr.triggerHapticPulse(1, 100);
                break;
            }
            if (!free) {
                player.method_5814(x, y, z);
                this.dh.vr.triggerHapticPulse(0, 100);
                this.dh.vr.triggerHapticPulse(1, 100);
            }
            ClientNetworking.sendServerPacket(new ClimbingPayloadC2S());
        } else {
            this.wantJump = false;
            class_243 p1 = player.method_19538().method_1020(delta);
            Vector3f movement = this.dh.vr.controllerHistory[this.latchStartController].netMovement(0.3);
            float speed = this.dh.vr.controllerHistory[this.latchStartController].averageSpeed(0.3f);
            movement.mul(0.66f * speed);
            float limit = 0.66f;
            if (movement.length() > 0.66f) {
                movement.mul(0.66f / movement.length());
            }
            if (player.method_6059(class_1294.field_5913)) {
                movement.mul((float)player.method_6112(class_1294.field_5913).method_5578() + 1.5f);
            }
            movement.rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
            player.method_18800((double)(-movement.x), (double)(-movement.y), (double)(-movement.z));
            player.field_6038 = p1.field_1352;
            player.field_5971 = p1.field_1351;
            player.field_5989 = p1.field_1350;
            p1 = p1.method_1031(player.method_18798().field_1352, player.method_18798().field_1351, player.method_18798().field_1350);
            player.method_5814(p1.field_1352, p1.field_1351, p1.field_1350);
            this.dh.vrPlayer.snapRoomOriginToPlayerEntity((class_1297)player, false, false);
            this.mc.field_1724.method_7322(0.3f);
        }
    }

    private boolean isClimbableTrapdoor(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (blockState.method_26204() instanceof class_2533 && ((Boolean)blockState.method_11654((class_2769)class_2533.field_11631)).booleanValue()) {
            class_2680 blockStateBelow = level.method_8320(blockPos.method_10074());
            return blockStateBelow.method_27852(class_2246.field_9983) && blockStateBelow.method_11654((class_2769)class_2399.field_11253) == blockState.method_11654((class_2769)class_2533.field_11177);
        }
        return false;
    }

    private boolean allowed(class_2680 bs) {
        return switch (this.serverBlockmode) {
            default -> throw new MatchException(null, null);
            case ClimbeyBlockmode.DISABLED -> true;
            case ClimbeyBlockmode.WHITELIST -> this.blocklist.contains(bs.method_26204());
            case ClimbeyBlockmode.BLACKLIST -> !this.blocklist.contains(bs.method_26204());
        };
    }
}

