/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import net.minecraft.class_10034;
import net.minecraft.class_10055;
import net.minecraft.class_1306;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5605;
import net.minecraft.class_5609;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerModel_WithArmsLegs;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.mca.MCAHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VRPlayerModel
extends class_591 {
    protected ClientVRPlayers.RotInfo rotInfo;
    protected float bodyYaw;
    protected boolean laying;
    protected float xRot;
    protected float layAmount;
    protected class_1306 attackArm = null;
    protected class_1306 mainArm = class_1306.field_6183;
    protected boolean isMainPlayer;
    protected float attackTime;
    protected float bodyScale;
    protected float armScale;
    protected float legScale;
    protected final Vector3f tempV = new Vector3f();
    protected final Vector3f tempV2 = new Vector3f();
    protected final Matrix3f tempM = new Matrix3f();

    public VRPlayerModel(class_630 root, boolean isSlim) {
        super(root, isSlim);
    }

    public static class_5609 createMesh(class_5605 cubeDeformation, boolean slim) {
        class_5609 meshDefinition = class_591.method_32028((class_5605)cubeDeformation, (boolean)slim);
        return meshDefinition;
    }

    public void method_62110(class_10055 renderState) {
        renderState.field_53410 = renderState.field_53410 & !renderState.field_53412;
        super.method_62110(renderState);
    }

    public static void animateVRModel(class_591 model, class_10055 renderState, Vector3f tempV, Vector3f tempV2, Matrix3f tempM) {
        ClientVRPlayers.RotInfo rotInfo;
        if (model instanceof VRPlayerModel_WithArms) {
            VRPlayerModel_WithArms armsModel = (VRPlayerModel_WithArms)model;
            armsModel.leftHand.field_3665 = model.field_27433.field_3665;
            armsModel.rightHand.field_3665 = model.field_3401.field_3665;
        }
        if ((rotInfo = ((EntityRenderStateExtension)renderState).vivecraft$getRotInfo()) == null) {
            if (model instanceof VRPlayerModel) {
                VRPlayerModel vrModel = (VRPlayerModel)model;
                vrModel.rotInfo = null;
            }
            return;
        }
        boolean isMainPlayer = ((EntityRenderStateExtension)renderState).vivecraft$isFirstPersonPlayer();
        if (isMainPlayer) {
            if (ClientDataHolderVR.getInstance().currentPass == RenderPass.CAMERA && ClientDataHolderVR.getInstance().cameraTracker.isQuickMode() && ClientDataHolderVR.getInstance().grabScreenShot) {
                VRPlayerModel.hideHand(model, class_1306.field_6182, true);
                VRPlayerModel.hideHand(model, class_1306.field_6183, true);
            }
            if (VREffectsHelper.isFirstPersonEntityPass()) {
                model.field_3398.field_3665 = false;
                model.field_3394.field_3665 = false;
                if (ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.COMPLETE) {
                    VRPlayerModel.hideHand(model, class_1306.field_6182, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                    VRPlayerModel.hideHand(model, class_1306.field_6183, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                } else {
                    boolean leftHanded = ClientDataHolderVR.getInstance().vrSettings.reverseHands;
                    if (ClientDataHolderVR.getInstance().menuHandOff) {
                        VRPlayerModel.hideHand(model, leftHanded ? class_1306.field_6183 : class_1306.field_6182, false);
                    }
                    if (ClientDataHolderVR.getInstance().menuHandMain) {
                        VRPlayerModel.hideHand(model, leftHanded ? class_1306.field_6182 : class_1306.field_6183, false);
                    }
                }
            }
        }
        class_1306 mainArm = rotInfo.leftHanded ? class_1306.field_6182 : class_1306.field_6183;
        class_1306 attackArm = null;
        if (renderState.field_53404 > 0.0f) {
            attackArm = renderState.field_53408;
            if (rotInfo.leftHanded) {
                attackArm = attackArm.method_5928();
            }
        }
        float bodyYaw = isMainPlayer ? ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYawRad() : rotInfo.getBodyYawRad();
        boolean laying = renderState.field_53403 > 0.0f || renderState.field_53411;
        float layAmount = renderState.field_53411 ? 1.0f : renderState.field_53403;
        boolean swimming = laying && renderState.field_53458 || renderState.field_53411;
        boolean noLowerBodyAnimation = swimming || rotInfo.fbtMode == FBTMode.ARMS_ONLY;
        float bodyScale = 1.0f;
        float armScale = 1.0f;
        float legScale = 1.0f;
        if (isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && (!ImmersivePortalsHelper.isLoaded() || !ImmersivePortalsHelper.isRenderingPortal()) && !ShadersHelper.isRenderingShadows() && RenderPass.isFirstPerson(ClientDataHolderVR.getInstance().currentPass) || ShadersHelper.isRenderingShadows() && ClientDataHolderVR.getInstance().vrSettings.shaderFullSizeShadowLimbs) {
            bodyScale = ClientDataHolderVR.getInstance().vrSettings.playerModelBodyScale;
            armScale = ClientDataHolderVR.getInstance().vrSettings.playerModelArmsScale;
            legScale = ClientDataHolderVR.getInstance().vrSettings.playerModelLegScale;
        }
        float sideOffset = 4.0f * bodyScale + armScale;
        float xRot = swimming ? layAmount * (-1.5707964f - (float)Math.PI / 180 * renderState.field_53448) : layAmount * -1.5707964f;
        if (!swimming) {
            rotInfo.headQuat.transform(0.0f, -0.2f, 0.1f, tempV2);
            tempV2.mul(rotInfo.heightScale * rotInfo.worldScale);
        } else {
            tempV2.zero();
        }
        tempV2.add(rotInfo.headPos);
        float progress = ModelUtils.getBendProgress(renderState.field_53459, renderState.field_53410, renderState.field_53413, rotInfo, (Vector3fc)tempV2);
        float heightOffset = 22.0f * progress;
        tempM.set(rotInfo.headQuat).rotateLocalY(bodyYaw + (float)Math.PI).rotateLocalX(-xRot);
        ModelUtils.setRotation(model.field_3398, (Matrix3fc)tempM, tempV);
        ModelUtils.worldToModel((class_10034)renderState, (Vector3fc)tempV2, rotInfo, bodyYaw, true, tempV);
        if (swimming) {
            tempV.z += 3.0f;
        }
        model.field_3398.method_2851(tempV.x, tempV.y, tempV.z);
        model.field_3391.method_2851(model.field_3398.field_3657, model.field_3398.field_3656, model.field_3398.field_3655);
        if (renderState.field_53413) {
            ModelUtils.pointModelAtModelForward(model.field_3391, 0.0f, 14.0f, 2.0f + heightOffset, tempV, tempV2, tempM);
            tempM.rotateLocalX(-xRot);
            ModelUtils.setRotation(model.field_3391, (Matrix3fc)tempM, tempV);
        } else if (noLowerBodyAnimation) {
            model.field_3391.method_33425((float)Math.PI * Math.max(0.0f, model.field_3391.field_3656 / 22.0f) * (model instanceof VRPlayerModel_WithArmsLegs ? 0.5f : 1.0f), 0.0f, 0.0f);
            if (laying) {
                float bodyXRot;
                if (swimming) {
                    bodyXRot = -xRot;
                } else {
                    float aboveGround = (heightOffset - 11.0f) / 11.0f;
                    bodyXRot = progress * ((float)Math.PI - 1.5707964f * (1.0f + 0.3f * (1.0f - aboveGround)));
                }
                model.field_3391.field_3654 = class_3532.method_16439((float)layAmount, (float)model.field_3391.field_3654, (float)bodyXRot);
                model.field_3398.field_3656 -= 2.0f * layAmount;
                model.field_3391.field_3656 -= 2.0f * layAmount;
            }
        } else {
            ModelUtils.pointModelAtLocal((class_10034)renderState, model.field_3391, rotInfo.waistPos, rotInfo.waistQuat, rotInfo, bodyYaw, true, tempV, tempV2, tempM);
            tempM.transform(sideOffset, 2.0f, 0.0f, tempV2);
            model.field_27433.field_3657 = model.field_3391.field_3657 + tempV2.x;
            model.field_27433.field_3656 = model.field_3391.field_3656 + tempV2.y;
            model.field_27433.field_3655 = model.field_3391.field_3655 - tempV2.z;
            tempM.transform(-sideOffset, 2.0f, 0.0f, tempV2);
            model.field_3401.field_3657 = model.field_3391.field_3657 + tempV2.x;
            model.field_3401.field_3656 = model.field_3391.field_3656 + tempV2.y;
            model.field_3401.field_3655 = model.field_3391.field_3655 - tempV2.z;
            tempM.rotateLocalX(-xRot);
            ModelUtils.setRotation(model.field_3391, (Matrix3fc)tempM, tempV);
        }
        float cosBodyRot = class_3532.method_15362((float)model.field_3391.field_3654);
        if (renderState.field_53413 || noLowerBodyAnimation) {
            model.field_27433.field_3657 = model.field_3391.field_3657 + sideOffset;
            model.field_3401.field_3657 = model.field_3391.field_3657 - sideOffset;
            model.field_27433.field_3656 = 2.0f * cosBodyRot + model.field_3391.field_3656;
            model.field_27433.field_3655 = model.field_3391.field_3655;
            model.field_3401.field_3656 = model.field_27433.field_3656;
            model.field_3401.field_3655 = model.field_27433.field_3655;
        }
        model.field_3397.field_3657 = 1.9f;
        model.field_3392.field_3657 = -1.9f;
        if (renderState.field_53413) {
            model.field_3392.field_3655 = model.field_3397.field_3655 = heightOffset;
        } else if (laying && noLowerBodyAnimation) {
            if (swimming) {
                tempV.set(0.0f, 12.0f, 0.0f);
                tempV.rotateX(-xRot);
                model.field_3397.field_3656 = model.field_3391.field_3656 + tempV.y;
                model.field_3397.field_3655 = model.field_3391.field_3655 + tempV.z;
            } else {
                float cosBodyRot2 = cosBodyRot * cosBodyRot;
                model.field_3397.field_3656 += 10.25f - 2.0f * cosBodyRot2;
                model.field_3397.field_3655 = model.field_3391.field_3655 + 13.0f - cosBodyRot2 * 8.0f;
            }
            model.field_3397.field_3657 += model.field_3391.field_3657;
            model.field_3392.field_3657 += model.field_3391.field_3657;
            model.field_3392.field_3656 = model.field_3397.field_3656;
            model.field_3392.field_3655 = model.field_3397.field_3655;
        } else if (rotInfo.fbtMode != FBTMode.ARMS_ONLY) {
            ModelUtils.worldToModel((class_10034)renderState, rotInfo.waistPos, rotInfo, bodyYaw, true, tempV);
            tempV2.set(-1.9f, -2.0f, 0.0f);
            rotInfo.waistQuat.transform(tempV2);
            ModelUtils.worldToModelDirection((Vector3fc)tempV2, bodyYaw, tempV2);
            model.field_3397.method_2851(tempV.x + tempV2.x, tempV.y + tempV2.y, tempV.z + tempV2.z);
            tempV2.set(1.9f, -2.0f, 0.0f);
            rotInfo.waistQuat.transform(tempV2);
            ModelUtils.worldToModelDirection((Vector3fc)tempV2, bodyYaw, tempV2);
            model.field_3392.method_2851(tempV.x + tempV2.x, tempV.y + tempV2.y, tempV.z + tempV2.z);
        } else {
            model.field_3397.field_3657 += model.field_3391.field_3657;
            model.field_3392.field_3657 += model.field_3391.field_3657;
        }
        if (!renderState.field_53413 && layAmount < 1.0f && rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
            float newLegY = 12.0f + Math.min(model.field_3391.field_3656, 0.0f);
            float newLegZ = model.field_3391.field_3655 + 10.0f * class_3532.method_15374((float)model.field_3391.field_3654);
            if (model instanceof VRPlayerModel_WithArmsLegs) {
                newLegY += 10.0f * class_3532.method_15374((float)model.field_3391.field_3654);
            }
            model.field_3397.field_3656 = class_3532.method_16439((float)layAmount, (float)newLegY, (float)model.field_3397.field_3656);
            model.field_3397.field_3655 = class_3532.method_16439((float)layAmount, (float)newLegZ, (float)model.field_3397.field_3655);
            model.field_3392.field_3656 = model.field_3397.field_3656;
            model.field_3392.field_3655 = model.field_3397.field_3655;
        }
        if (!rotInfo.seated || isMainPlayer) {
            if (!(model instanceof VRPlayerModel_WithArms) && rotInfo.offHandPos.distanceSquared(rotInfo.mainHandPos) > 0.0f) {
                class_630 offHand = rotInfo.leftHanded ? model.field_3401 : model.field_27433;
                class_630 mainHand = rotInfo.leftHanded ? model.field_27433 : model.field_3401;
                float offset = (rotInfo.leftHanded ? -1.0f : 1.0f) * (model.field_3480 ? 0.016f : 0.032f) * (float)Math.PI * armScale;
                ModelUtils.worldToModel((class_10034)renderState, rotInfo.mainHandPos, rotInfo, bodyYaw, isMainPlayer || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale, tempV);
                tempV.sub(mainHand.field_3657, mainHand.field_3656, mainHand.field_3655);
                mainHand.field_3656 -= 2.0f * Math.max(0.0f, -tempV.y / tempV.length());
                ModelUtils.pointAtModelWithLocal(rotInfo.mainHandQuat, bodyYaw, (Vector3fc)tempV, tempV2, tempM);
                float controllerDist = tempV.length();
                if (!ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && controllerDist > 10.0f) {
                    tempV.normalize().mul(controllerDist - 10.0f);
                    mainHand.field_3657 += tempV.x;
                    mainHand.field_3656 += tempV.y;
                    mainHand.field_3655 += tempV.z;
                    tempM.rotateZ(-offset);
                } else {
                    tempM.rotateZ(-offset * Math.min(10.0f / controllerDist, 1.0f));
                }
                if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && attackArm == mainArm) {
                    ModelUtils.swingAnimation(attackArm, renderState.field_53404, isMainPlayer, tempM, tempV);
                    mainHand.field_3657 -= tempV.x;
                    mainHand.field_3656 -= tempV.y;
                    mainHand.field_3655 += tempV.z;
                }
                tempM.rotateLocalX(-xRot);
                ModelUtils.setRotation(mainHand, (Matrix3fc)tempM, tempV);
                ModelUtils.worldToModel((class_10034)renderState, rotInfo.offHandPos, rotInfo, bodyYaw, isMainPlayer || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale, tempV);
                tempV.sub(offHand.field_3657, offHand.field_3656, offHand.field_3655);
                offHand.field_3656 -= 2.0f * Math.max(0.0f, -tempV.y / tempV.length());
                ModelUtils.pointAtModelWithLocal(rotInfo.offHandQuat, bodyYaw, (Vector3fc)tempV, tempV2, tempM);
                controllerDist = tempV.length();
                if (!ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && controllerDist > 10.0f) {
                    tempV.normalize().mul(controllerDist - 10.0f);
                    offHand.field_3657 += tempV.x;
                    offHand.field_3656 += tempV.y;
                    offHand.field_3655 += tempV.z;
                    tempM.rotateZ(offset);
                } else {
                    tempM.rotateZ(offset * Math.min(10.0f / controllerDist, 1.0f));
                }
                if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && attackArm != mainArm) {
                    ModelUtils.swingAnimation(attackArm, renderState.field_53404, isMainPlayer, tempM, tempV);
                    offHand.field_3657 -= tempV.x;
                    offHand.field_3656 -= tempV.y;
                    offHand.field_3655 += tempV.z;
                }
                if (isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.set3x3((Matrix3fc)tempM);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateX(-1.5707964f);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateLocalY(-bodyYaw - (float)Math.PI);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.transformDirection(MathUtils.BACK, tempV).mul(0.584f * rotInfo.worldScale);
                    ModelUtils.modelToWorld((class_10034)renderState, offHand.field_3657, offHand.field_3656, offHand.field_3655, rotInfo, bodyYaw, true, true, tempV2);
                    if (MCAHelper.isLoaded()) {
                        // empty if block
                    }
                    tempV2.add((Vector3fc)tempV);
                    GuiHandler.GUI_POS_PLAYER_MODEL = class_310.method_1551().field_1724.method_30950(ClientUtils.getCurrentPartialTick()).method_1031((double)tempV2.x, (double)tempV2.y, (double)tempV2.z);
                }
                tempM.rotateLocalX(-xRot);
                ModelUtils.setRotation(offHand, (Matrix3fc)tempM, tempV);
            }
            if (!(renderState.field_53413 || noLowerBodyAnimation || model instanceof VRPlayerModel_WithArmsLegs)) {
                float limbRotation = 0.0f;
                if (ClientDataHolderVR.getInstance().vrSettings.playerWalkAnim) {
                    limbRotation = class_3532.method_15362((float)(renderState.field_53450 * 0.6662f)) * 1.4f * renderState.field_53451;
                }
                ModelUtils.pointModelAtLocal((class_10034)renderState, model.field_3392, rotInfo.rightFootPos, rotInfo.rightFootQuat, rotInfo, bodyYaw, true, tempV, tempV2, tempM);
                tempM.rotateLocalX(limbRotation - xRot);
                ModelUtils.setRotation(model.field_3392, (Matrix3fc)tempM, tempV);
                ModelUtils.pointModelAtLocal((class_10034)renderState, model.field_3397, rotInfo.leftFootPos, rotInfo.leftFootQuat, rotInfo, bodyYaw, true, tempV, tempV2, tempM);
                tempM.rotateLocalX(-limbRotation - xRot);
                ModelUtils.setRotation(model.field_3397, (Matrix3fc)tempM, tempV);
            }
        }
        if (layAmount > 0.0f) {
            if (noLowerBodyAnimation) {
                model.field_3391.field_3654 += xRot;
            }
            if (model instanceof VRPlayerModel_WithArmsLegs) {
                ModelUtils.applySwimRotationOffset((class_10034)renderState, xRot, tempV, tempV2, model.field_3398, model.field_3391);
            } else if (model instanceof VRPlayerModel_WithArms) {
                ModelUtils.applySwimRotationOffset((class_10034)renderState, xRot, tempV, tempV2, model.field_3398, model.field_3391, model.field_3397, model.field_3392);
            } else {
                ModelUtils.applySwimRotationOffset((class_10034)renderState, xRot, tempV, tempV2, model.field_3398, model.field_3391, model.field_27433, model.field_3401, model.field_3397, model.field_3392);
            }
        }
        model.field_3401.field_37938 = model.field_3401.field_37940 = armScale;
        model.field_27433.field_37940 = model.field_3401.field_37940;
        model.field_27433.field_37938 = model.field_3401.field_37940;
        model.field_3391.field_37938 = model.field_3391.field_37940 = bodyScale;
        model.field_3392.field_37938 = model.field_3392.field_37940 = legScale;
        model.field_3397.field_37940 = model.field_3392.field_37940;
        model.field_3397.field_37938 = model.field_3392.field_37940;
        if (renderState.field_53459) {
            VRPlayerModel.spinOffset(model.field_3398, model.field_3391);
            if (!(model instanceof VRPlayerModel_WithArms)) {
                VRPlayerModel.spinOffset(model.field_27433, model.field_3401);
            }
            if (!(model instanceof VRPlayerModel_WithArmsLegs)) {
                VRPlayerModel.spinOffset(model.field_3397, model.field_3392);
            }
        }
        if (model instanceof VRPlayerModel) {
            VRPlayerModel vrModel = (VRPlayerModel)model;
            vrModel.isMainPlayer = isMainPlayer;
            vrModel.rotInfo = rotInfo;
            vrModel.mainArm = mainArm;
            vrModel.attackArm = attackArm;
            vrModel.attackTime = renderState.field_53404;
            vrModel.bodyYaw = bodyYaw;
            vrModel.laying = laying;
            vrModel.layAmount = layAmount;
            vrModel.bodyScale = bodyScale;
            vrModel.armScale = armScale;
            vrModel.legScale = legScale;
            vrModel.xRot = xRot;
        }
    }

    private static void hideHand(class_591 model, class_1306 arm, boolean completeArm) {
        if (model instanceof VRPlayerModel) {
            VRPlayerModel vrModel = (VRPlayerModel)model;
            if (arm == class_1306.field_6182) {
                vrModel.hideLeftArm(completeArm);
            } else {
                vrModel.hideRightArm(completeArm);
            }
        } else if (arm == class_1306.field_6182) {
            model.field_27433.field_3665 = false;
        } else {
            model.field_3401.field_3665 = false;
        }
    }

    public void hideLeftArm(boolean completeArm) {
        this.field_27433.field_3665 = false;
    }

    public void hideRightArm(boolean onlyHand) {
        this.field_3401.field_3665 = false;
    }

    protected static void spinOffset(class_630 ... parts) {
        for (class_630 part : parts) {
            part.field_3656 += 24.0f;
        }
    }

    public void method_2803(class_1306 side, class_4587 poseStack) {
        this.method_2808(side).method_22703(poseStack);
        if (this.field_3480) {
            poseStack.method_46416(side == class_1306.field_6183 ? 0.03125f : -0.03125f, 0.0f, 0.0f);
        }
        this.doAttackAnim(side, poseStack);
    }

    protected void doAttackAnim(class_1306 side, class_4587 poseStack) {
        if (side == this.attackArm) {
            poseStack.method_46416(0.0f, 0.5f, 0.0f);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(class_3532.method_15374((float)(this.attackTime * (float)Math.PI))));
            poseStack.method_46416(0.0f, -0.5f, 0.0f);
        }
    }
}

