/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.FluidUtil;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class InventoryActions {
    public static boolean transferContainerTank(TanksUpgrade upgrade, FluidTank tank, int slotIn) {
        block55: {
            boolean hasFluidStorage;
            ItemStackHandler itemStackHandler = upgrade.getFluidSlotsHandler();
            ItemStackHandler itemStackHandlerCopy = new ItemStackHandler(itemStackHandler.getSlots());
            itemStackHandlerCopy.setStackInSlot(slotIn, itemStackHandler.getStackInSlot(slotIn).method_46651(1));
            SingleSlotStorage slotStorage = InventoryStorage.of((class_1263)itemStackHandlerCopy, null).getSlot(slotIn);
            class_1799 stackIn = itemStackHandler.getStackInSlot(slotIn);
            int slotOut = slotIn + 1;
            if (tank == null || stackIn.method_7960() || stackIn.method_7909() == class_1802.field_8162) {
                return false;
            }
            if (stackIn.method_7909() instanceof class_1812 && stackIn.method_7909() != class_1802.field_8469 && !(hasFluidStorage = FluidUtil.hasFluidStorageConstant(stackIn))) {
                long amount = 27000L;
                int potionType = 0;
                if (stackIn.method_7909() == class_1802.field_8436) {
                    potionType = 1;
                }
                if (stackIn.method_7909() == class_1802.field_8150) {
                    potionType = 2;
                }
                FluidVariant variant = FluidStackHelper.setPotionFluidVariant(stackIn, potionType);
                FluidVariantWrapper wrapper = new FluidVariantWrapper(variant, amount);
                if ((tank.isEmpty() || FluidUtil.isSameVariant(variant, tank.getFluid().fluidVariant())) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                    class_1799 bottle = potionType != 0 ? class_1799.field_8037.method_7972() : new class_1799((class_1935)class_1802.field_8469);
                    class_1799 currentStackOut = itemStackHandler.getStackInSlot(slotOut);
                    if (currentStackOut.method_7960() || currentStackOut.method_7909() == bottle.method_7909() || bottle.method_7960()) {
                        if (currentStackOut.method_7909() == bottle.method_7909() && !bottle.method_7960()) {
                            if (currentStackOut.method_7947() + 1 > currentStackOut.method_7914()) {
                                return false;
                            }
                            bottle.method_7939(itemStackHandler.getStackInSlot(slotOut).method_7947() + 1);
                        }
                        tank.fill(wrapper, false);
                        InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                        if (!bottle.method_7960()) {
                            itemStackHandler.setStackInSlot(slotOut, bottle);
                        }
                        InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), class_3417.field_14978, true);
                        return true;
                    }
                }
            }
            if (stackIn.method_7909() == class_1802.field_8469 && tank.getFluid().fluidVariant().getFluid() == ModFluids.POTION_STILL && tank.getFluidAmount() >= 27000L) {
                class_1799 stackOut = FluidStackHelper.getItemStackFromFluidStack(tank.getFluid().fluidVariant());
                class_1799 currentStackOut = itemStackHandler.getStackInSlot(slotOut);
                if (currentStackOut.method_7960()) {
                    tank.drain(27000L, false);
                    InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);
                    InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), class_3417.field_14978, false);
                    return true;
                }
            }
            Optional<Storage<FluidVariant>> fluidStorage = FluidUtil.getFluidStorageAtSlot((SingleSlotStorage<ItemVariant>)slotStorage);
            if (!Transaction.isOpen()) {
                try (Transaction transaction = Transaction.openOuter();){
                    class_1799 slotOutStack;
                    class_3414 fluidSound;
                    if (fluidStorage.isPresent()) {
                        ResourceAmount fluidVariantWrapper;
                        try (Transaction transaction1 = transaction.openNested();){
                            fluidVariantWrapper = StorageUtil.findExtractableContent(fluidStorage.get(), (TransactionContext)transaction1);
                            transaction1.commit();
                        }
                        if (fluidVariantWrapper != null && ((FluidVariant)fluidVariantWrapper.resource()).getFluid() != null && fluidVariantWrapper.amount() > 0L) {
                            if (tank.getAmount() > 0L && !FluidUtil.isSameVariant((FluidVariant)fluidVariantWrapper.resource(), tank.getResource())) {
                                transaction.close();
                                boolean transaction1 = false;
                                return transaction1;
                            }
                            class_1799 slotOutStack2 = itemStackHandler.getStackInSlot(slotOut);
                            fluidSound = FluidVariantAttributes.getEmptySound((FluidVariant)((FluidVariant)fluidVariantWrapper.resource()));
                            if (StorageUtil.move(fluidStorage.get(), (Storage)tank, f -> true, (long)fluidVariantWrapper.amount(), (TransactionContext)transaction) > 0L) {
                                class_1799 transferResultStack = ((ItemVariant)slotStorage.getResource()).toStack();
                                if (!transferResultStack.method_7960() && (slotOutStack2.method_7960() || slotOutStack2.method_7909() == transferResultStack.method_7909())) {
                                    if (slotOutStack2.method_7909() == transferResultStack.method_7909()) {
                                        transferResultStack.method_7939(slotOutStack2.method_7947() + 1);
                                        if (transferResultStack.method_7947() > slotOutStack2.method_7914()) {
                                            transaction.abort();
                                            boolean bl = false;
                                            return bl;
                                        }
                                    }
                                    itemStackHandler.setStackInSlot(slotOut, transferResultStack);
                                }
                                InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                                InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, false);
                                transaction.commit();
                                boolean bl = true;
                                return bl;
                            }
                        }
                    }
                    if (tank.isEmpty() || tank.getFluidAmount() <= 0L) {
                        boolean fluidVariantWrapper = false;
                        return fluidVariantWrapper;
                    }
                    if (!InventoryActions.isFluidEqual(stackIn, tank, transaction)) break block55;
                    long amount = 0L;
                    try (Transaction transaction1 = transaction.openNested();){
                        amount = StorageUtil.simulateInsert(fluidStorage.get(), (Object)tank.getFluid().fluidVariant(), (long)tank.getFluidAmount(), (TransactionContext)transaction1);
                        transaction1.commit();
                    }
                    fluidSound = FluidTypeHelper.getSound(tank.getFluid().fluidVariant(), true);
                    long transferAmount = 0L;
                    try (Transaction transaction1 = transaction.openNested();){
                        transferAmount = FluidUtil.tryFillContainerAtSlot(tank, amount, fluidStorage.get(), true, transaction1);
                    }
                    class_1799 stackOut = ((ItemVariant)slotStorage.getResource()).toStack();
                    if (stackOut.method_7960()) {
                        transaction.abort();
                        boolean bl = false;
                        return bl;
                    }
                    if (transferAmount > 0L && ((slotOutStack = itemStackHandler.getStackInSlot(slotOut)).method_7960() || slotOutStack.method_7909() == stackOut.method_7909())) {
                        if (slotOutStack.method_7909() == stackOut.method_7909()) {
                            stackOut.method_7939(slotOutStack.method_7947() + 1);
                            if (stackOut.method_7947() > slotOutStack.method_7914()) {
                                transaction.abort();
                                boolean bl = false;
                                return bl;
                            }
                        }
                        InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, true);
                        itemStackHandler.setStackInSlot(slotOut, stackOut);
                        InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isFluidEqual(class_1799 stackIn, FluidTank tank, Transaction main) {
        if (FluidUtil.hasFluidStorageConstant(stackIn)) {
            ResourceAmount fluidVariantWrapper = null;
            try (Transaction transaction = main.openNested();){
                fluidVariantWrapper = StorageUtil.findExtractableContent(FluidUtil.getFluidStorageConstant(stackIn).get(), (TransactionContext)transaction);
                transaction.commit();
            }
            if (fluidVariantWrapper == null) {
                return true;
            }
            if (!((FluidVariant)fluidVariantWrapper.resource()).isBlank() && fluidVariantWrapper.amount() > 0L) {
                return FluidUtil.isSameVariant((FluidVariant)fluidVariantWrapper.resource(), tank.getFluid().fluidVariant());
            }
        }
        return false;
    }

    public static void playFluidSound(@Nullable class_1657 player, List<class_1657> usingPlayers, class_3414 soundEvent, boolean fill) {
        if (soundEvent == null) {
            soundEvent = fill ? class_3417.field_15126 : class_3417.field_14834;
        }
        if (player != null) {
            player.method_37908().method_43128(null, player.method_19538().method_10216(), player.method_19538().method_10214() + 0.5, player.method_19538().method_10215(), soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        } else if (!usingPlayers.isEmpty()) {
            BackpackBaseMenu menu;
            class_1657 user = usingPlayers.get(0);
            class_1703 class_17032 = user.field_7512;
            if (class_17032 instanceof BackpackBlockEntityMenu) {
                menu = (BackpackBlockEntityMenu)class_17032;
                class_243 backpackPos = menu.getWrapper().getBackpackPos().method_46558();
                ((BackpackBlockEntityMenu)menu).player.method_37908().method_43128(null, backpackPos.method_10216(), backpackPos.method_10214() + 0.5, backpackPos.method_10215(), soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            }
            if ((class_17032 = user.field_7512) instanceof BackpackItemMenu && (menu = (BackpackItemMenu)class_17032).getWrapper().getScreenID() == 1 && !((BackpackItemMenu)menu).player.method_37908().field_9236) {
                ((BackpackItemMenu)menu).player.method_17356(soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }
}

