/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawningshulkers.forge.events;

import com.natamus.respawningshulkers_common_forge.events.ShulkerEvent;
import java.lang.invoke.MethodHandles;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeShulkerEvent {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeShulkerEvent.class);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent.Post e) {
        Level level = e.level;
        if (level.isClientSide) {
            return;
        }
        ShulkerEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent(priority=-127)
    public static void onShulkerDeath(LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        ShulkerEvent.onShulkerDeath(entity.level(), (Entity)entity, e.getSource());
    }

    @SubscribeEvent
    public static void onServerShutdown(ServerStoppingEvent e) {
        ShulkerEvent.onServerShutdown(e.getServer());
    }
}

