/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.events.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ReturnableEventHandler<T, R> {
    private final List<ReturnableFunction<T, R>> listeners = new ArrayList<ReturnableFunction<T, R>>();

    public void addListener(ReturnableFunction<T, R> listener) {
        this.listeners.add(listener);
    }

    public void addListener(Function<T, R> listener) {
        this.listeners.add((value, event) -> listener.apply(event));
    }

    public void addListener(BiConsumer<R, T> listener) {
        this.addListener((R value, T event) -> {
            listener.accept(value, event);
            return null;
        });
    }

    public void removeListener(ReturnableFunction<T, R> listener) {
        this.listeners.remove(listener);
    }

    public R invoke(T event, R defaultValue) {
        R value = defaultValue;
        for (ReturnableFunction<T, R> listener : this.listeners) {
            R result = listener.apply(value, event);
            if (result == null) continue;
            value = result;
        }
        return value;
    }

    public R invoke(T event) {
        return this.invoke(event, null);
    }

    @FunctionalInterface
    public static interface ReturnableFunction<T, R> {
        @Nullable
        public R apply(R var1, T var2);
    }
}

