/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties.config;

import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.ConfigField;
import org.apache.logging.log4j.util.Strings;

public class CustomField
extends ConfigField<Object> {
    private static final String ATTR_NEG = "ATTR_NEG";
    private static final String ATTR_NUM = "ATTR_NUM";
    public static final String ATTR_VALUE_PATTERN = "pattern";

    protected CustomField() {
    }

    public CustomField(Category category, String key) {
        this(category, key, null);
    }

    public CustomField(Category category, String key, String defaultValue, int sortOrder) {
        this(category, key, defaultValue);
        this.sortOrder(sortOrder);
    }

    public CustomField(Category category, String key, String defaultValue) {
        super(category, key);
        if (!Strings.isEmpty((CharSequence)defaultValue)) {
            this.defaultValue(defaultValue);
            this.setToDefault();
        }
        this.setIsNum(false);
    }

    public CustomField(Category category, String key, Integer minValue, Integer maxValue, Integer defaultValue, Boolean allowNeg) {
        this(category, key, minValue, maxValue, defaultValue, 100, allowNeg);
    }

    public CustomField(Category category, String key, Integer minValue, Integer maxValue, Integer defaultValue, Integer sortOrder, Boolean allowNeg) {
        super(category, key);
        this.range(minValue, maxValue);
        this.defaultValue(defaultValue);
        this.setToDefault();
        this.sortOrder(sortOrder);
        this.setAllowNeg(allowNeg);
        this.setIsNum(true);
    }

    private void setAllowNeg(Boolean allowNeg) {
        this.put(ATTR_NEG, allowNeg);
    }

    private void setIsNum(Boolean number) {
        this.put(ATTR_NUM, number);
    }

    @Override
    public boolean validate(boolean fix) {
        String string;
        Object value = this.get();
        if (value instanceof Integer) {
            return this.validateInt(fix);
        }
        if (value instanceof String && Strings.isNotEmpty((CharSequence)(string = (String)value))) {
            String pattern = this.getPattern();
            if (Strings.isNotEmpty((CharSequence)pattern)) {
                boolean patternValid = string.matches(pattern);
                if (!patternValid) {
                    Journeymap.getLogger().warn(String.format("Value '%s' doesn't match pattern '%s' for %s", string, pattern, this));
                    if (fix && Strings.isNotEmpty((CharSequence)((CharSequence)this.getDefaultValue()))) {
                        this.setToDefault();
                        Journeymap.getLogger().warn(String.format("Value set to default '%s' for %s", this.getDefaultValue(), this));
                    } else {
                        return false;
                    }
                }
                return true;
            }
            return super.validate(fix);
        }
        return false;
    }

    private boolean validateInt(boolean fix) {
        boolean valid = super.validate(fix);
        valid = this.require("min", "max") && valid;
        Integer value = this.getAsInteger();
        if (value == null || value < this.getMinValue() || value > this.getMaxValue()) {
            if (fix) {
                this.setToDefault();
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public CustomField range(int min, int max) {
        this.put("min", min);
        this.put("max", max);
        return this;
    }

    public int getMinValue() {
        return this.getIntegerAttr("min");
    }

    public int getMaxValue() {
        return this.getIntegerAttr("max");
    }

    @Override
    public Object getDefaultValue() {
        return this.get("default");
    }

    public String getAsString() {
        return this.getStringAttr("value");
    }

    public Integer getAsInteger() {
        try {
            Integer val = Integer.valueOf(this.get().toString());
            if (val < this.getMinValue() || val > this.getMaxValue()) {
                this.setToDefault();
            }
        }
        catch (NumberFormatException nfe) {
            this.setToDefault();
        }
        return this.getIntegerAttr("value");
    }

    @Override
    public Object get() {
        return this.get("value");
    }

    @Override
    public CustomField set(Object value) {
        try {
            Integer val = Integer.valueOf(value.toString());
            if (val < this.getMinValue() || val > this.getMaxValue()) {
                this.setToDefault();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        super.set(value);
        return this;
    }

    public boolean allowNeg() {
        return this.getBooleanAttr(ATTR_NEG);
    }

    public boolean isNumber() {
        return this.getBooleanAttr(ATTR_NUM);
    }

    public CustomField pattern(String regexPattern) {
        this.put(ATTR_VALUE_PATTERN, regexPattern);
        return this;
    }

    public String getPattern() {
        return this.getStringAttr(ATTR_VALUE_PATTERN);
    }
}

