/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.io.FileHandler;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_2338;
import net.minecraft.class_310;

public class ExternalWaypointFinder {
    private final List<ClientWaypointImpl> xaeroWaypoints = new ArrayList<ClientWaypointImpl>();
    private boolean didSearch = false;

    public boolean hasExternalWaypoints() {
        if (!this.didSearch) {
            try {
                this.findXaeroWaypointsForWorld();
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error finding external waypoints.", (Throwable)e);
            }
        }
        return !this.getXaeroWaypoints().isEmpty();
    }

    public List<ClientWaypointImpl> getXaeroWaypoints() {
        return this.xaeroWaypoints.stream().filter(waypoint -> !this.waypointExist((Waypoint)waypoint)).toList();
    }

    private boolean waypointExist(Waypoint waypoint) {
        if (waypoint == null) {
            return true;
        }
        for (ClientWaypointImpl wp : WaypointStore.getInstance().getAll()) {
            if (wp.getX() != waypoint.getX() || wp.getZ() != waypoint.getZ() || wp.getY() != waypoint.getY() || !wp.getGroupId().equalsIgnoreCase(waypoint.getGroupId()) || !wp.getPrimaryDimension().equalsIgnoreCase(waypoint.getPrimaryDimension())) continue;
            return true;
        }
        return false;
    }

    private void findXaeroWaypointsForWorld() {
        File xaeroMiniMapDir;
        Object worldDirectory;
        this.didSearch = true;
        class_310 mc = class_310.method_1551();
        if (mc.method_47392() || class_310.method_1551().method_1558() == null || class_310.method_1551().method_1558().method_2994()) {
            worldDirectory = mc.method_1576().field_23784.method_27005();
            xaeroMiniMapDir = new File(FileHandler.getMinecraftDirectory(), "xaero/minimap/" + (String)worldDirectory);
        } else {
            worldDirectory = "Multiplayer_" + class_310.method_1551().method_1558().field_3761;
            xaeroMiniMapDir = new File(FileHandler.getMinecraftDirectory(), "xaero/minimap/" + (String)worldDirectory);
            Journeymap.getLogger().info("Multiplayer world detected: {} exists: {}", worldDirectory, (Object)xaeroMiniMapDir.exists());
        }
        if (xaeroMiniMapDir.exists()) {
            File[] directories = xaeroMiniMapDir.listFiles(File::isDirectory);
            if (directories != null) {
                Journeymap.getLogger().info("Listing directories in xaero/minimap/ for world: {} ", worldDirectory);
                Arrays.stream(directories).forEach(dir -> Journeymap.getLogger().info(dir));
            }
            if (directories != null) {
                for (File wpDir : directories) {
                    if (!wpDir.isDirectory()) continue;
                    File[] files = wpDir.listFiles(file -> file.getName().endsWith(".txt"));
                    if (files != null) {
                        Journeymap.getLogger().info("Listing files in xaero/minimap/ for world: {} ", worldDirectory);
                        Arrays.stream(files).forEach(dir -> Journeymap.getLogger().info(dir));
                    }
                    String dim = this.getDimensionFromDirectoryName(wpDir.getName());
                    if (files == null) continue;
                    for (File waypointFile : files) {
                        List<ClientWaypointImpl> waypoints = this.buildWaypoints(dim, waypointFile);
                        if (waypoints == null) continue;
                        this.xaeroWaypoints.addAll(waypoints);
                    }
                }
            }
        }
    }

    private List<ClientWaypointImpl> buildWaypoints(String dimension, File waypoints) {
        ArrayList<ClientWaypointImpl> xaeroWaypoints = new ArrayList<ClientWaypointImpl>();
        try {
            return Files.readAllLines(waypoints.toPath()).stream().skip(3L).map(wp -> this.parsed((String)wp, dimension)).filter(waypoint -> waypoint != null && !this.waypointExist((Waypoint)waypoint)).toList();
        }
        catch (IOException e) {
            Journeymap.getLogger().error("Error building importable waypoints.", (Throwable)e);
            return xaeroWaypoints;
        }
    }

    private ClientWaypointImpl parsed(String wp, String dimension) {
        try {
            String[] parsed = wp.split(":");
            if ("waypoint".equals(parsed[0])) {
                String name = parsed[1].replace("gui.xaero_", "");
                int x = Integer.parseInt(parsed[3]);
                int y = Integer.parseInt(parsed[4].replace("~", "63"));
                int z = Integer.parseInt(parsed[5]);
                String group = parsed[9];
                class_2338 pos = new class_2338(x, y, z);
                if (name.equalsIgnoreCase("deathpoint")) {
                    return (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", pos, name, dimension, true, true);
                }
                ClientWaypointImpl waypoint = (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", pos, name, dimension, false, true);
                if (!group.contains("xaero_default")) {
                    waypoint.setGroupId(group);
                }
                return waypoint;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error parsing external waypoint: {} because: ", (Object)wp, (Object)e);
        }
        return null;
    }

    private String getDimensionFromDirectoryName(String name) {
        String value;
        return switch (value = name.split("%")[1]) {
            case "-1" -> "minecraft:the_nether";
            case "1" -> "minecraft:the_end";
            case "0" -> "minecraft:overworld";
            default -> value.replace("$", ":");
        };
    }
}

