/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.JourneymapClient;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointOrigin;
import journeymap.common.waypoint.WaypointPos;
import journeymap.common.waypoint.WaypointSettings;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11200;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;

public class ClientWaypointImpl
extends WaypointImpl {
    public ClientWaypointImpl(Waypoint waypoint) {
        super((WaypointImpl)waypoint);
    }

    public ClientWaypointImpl(String name, String version, String modId, String guid, String origin, String groupId, WaypointPos pos, Integer color, WaypointIcon icon, WaypointSettings settings, TreeSet<String> dimensions, Optional<String> customData) {
        super(name, guid);
        this.origin = origin;
        this.pos = pos;
        this.color = color;
        this.icon = icon;
        this.dimensions = dimensions;
        this.version = version;
        this.modId = modId;
        this.settings = settings;
        this.groupId = groupId;
        customData.ifPresent(this::setCustomData);
        if (dimensions.size() == 1) {
            pos.setPrimaryDimension(dimensions.first());
        }
    }

    @ApiStatus.Internal
    public ClientWaypointImpl(String name, WaypointPos pos, Integer color, WaypointSettings settings, String origin, TreeSet<String> dimensions, WaypointIcon icon, String groupId) {
        this(name, "1", WaypointOrigin.fromValue(origin) == null ? origin : "journeymap", UUID.randomUUID().toString(), WaypointOrigin.fromValue(origin) != null ? origin : "journeymap", groupId, pos, color, icon, settings, dimensions, Optional.empty());
        if (!dimensions.isEmpty()) {
            pos.setPrimaryDimension(dimensions.first());
            if ("minecraft:the_nether".equals(pos.getPrimaryDimension())) {
                pos.setX(pos.getX() >> 3);
                pos.setZ(pos.getZ() >> 3);
            }
        }
    }

    public String getDisplayName() {
        String tag = this.getGroup().getTag();
        if (tag != null && !tag.isEmpty()) {
            return "[" + tag + "] " + this.getName();
        }
        return this.getName();
    }

    @Override
    public int getX() {
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null && this.neitherShiftRight((class_1937)mc.field_1687)) {
            return super.getX() >> 3;
        }
        if (mc != null && mc.field_1724 != null && this.netherShiftLeft((class_1937)mc.field_1687)) {
            return super.getX() << 3;
        }
        return super.getX();
    }

    @Override
    public int getZ() {
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null && this.neitherShiftRight((class_1937)mc.field_1687)) {
            return super.getZ() >> 3;
        }
        if (mc != null && mc.field_1724 != null && this.netherShiftLeft((class_1937)mc.field_1687)) {
            return super.getZ() << 3;
        }
        return super.getZ();
    }

    public int getRawX() {
        return super.getX();
    }

    public int getRawZ() {
        return super.getZ();
    }

    public double getRawCenterX() {
        return (double)super.getX() + 0.5;
    }

    public double getRawCenterZ() {
        return (double)super.getZ() + 0.5;
    }

    public double getBlockCenteredX() {
        return (double)this.getX() + 0.5;
    }

    public double getBlockCenteredY() {
        return (double)this.getY() + 0.5;
    }

    public double getBlockCenteredZ() {
        return (double)this.getZ() + 0.5;
    }

    public class_243 getPosition() {
        return new class_243(this.getBlockCenteredX(), this.getBlockCenteredY(), this.getBlockCenteredZ());
    }

    @Override
    public Integer getIconColor() {
        if (this.getIcon() != null && !this.getIcon().useBeaconColor()) {
            return this.getIcon().getColor();
        }
        return this.getRenderColor();
    }

    public int getRenderColor() {
        if (this.getGroup().colorOverride() && this.getGroup().getColor() != null) {
            return this.getGroup().getColor();
        }
        return super.getColor();
    }

    public boolean isDeathPoint() {
        return WaypointGroupStore.DEATH.getGuid().equals(this.groupId);
    }

    public Integer getSafeColor() {
        if (this.getRed() + this.getGreen() + this.getBlue() >= 100) {
            return this.getRenderColor();
        }
        return 0x404040;
    }

    public class_1044 getTexture() {
        class_1044 tex = TextureCache.getTexture(this.getTextureResource());
        if (tex == null) {
            tex = TextureCache.getTexture(TextureCache.Waypoint);
        }
        ((TextureAccess)tex).journeymap$setDisplayHeight(16);
        ((TextureAccess)tex).journeymap$setDisplayWidth(16);
        return tex;
    }

    public boolean isTeleportReady() {
        return this.getY() >= class_310.method_1551().field_1687.method_31607() && this.isInPlayerDimension();
    }

    public boolean isInPlayerDimension() {
        return this.getDimensions().contains(class_310.method_1551().field_1724.method_37908().method_27983().method_29177().toString());
    }

    public String toChatString() {
        boolean useName = !this.getName().equals(String.format("%s, %s", this.getX(), this.getZ()));
        return this.toChatString(useName);
    }

    public String toChatString(boolean useName) {
        return ClientWaypointImpl.toChatString(this, useName);
    }

    public static String toChatString(Waypoint waypoint) {
        boolean useName = !waypoint.getName().equals(String.format("%s, %s", waypoint.getX(), waypoint.getZ()));
        return ClientWaypointImpl.toChatString(waypoint, useName);
    }

    public static String toChatString(Waypoint waypoint, boolean useName) {
        String format;
        String result;
        String dim = waypoint.getPrimaryDimension();
        if (!waypoint.getDimensions().isEmpty()) {
            dim = (String)waypoint.getDimensions().first();
        }
        boolean useDim = !"overworld".equalsIgnoreCase(dim);
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Object> args = new ArrayList<Object>();
        if (useName) {
            parts.add("name:\"%s\"");
            args.add(waypoint.getName().replaceAll("\"", " "));
        }
        parts.add("x:%s, y:%s, z:%s");
        args.add(waypoint.getX());
        args.add(waypoint.getY());
        args.add(waypoint.getZ());
        if (useDim) {
            parts.add("dim:%s");
            args.add(dim);
        }
        if (WaypointParser.parse(result = String.format(format = "[" + Joiner.on((String)", ").join(parts) + "]", args.toArray())) == null) {
            Journeymap.getLogger().warn("Couldn't produce parsable chat string from Waypoint: " + String.valueOf(waypoint));
            if (useName) {
                return ClientWaypointImpl.toChatString(waypoint, false);
            }
        }
        return result;
    }

    public String getPrettyName() {
        class_124 textFormatting = class_124.field_1068;
        for (class_124 tf : class_124.values()) {
            if (tf.method_532() == null || !tf.method_532().equals((this.getRed() & 0xFF) << 16 | (this.getGreen() & 0xFF) << 8 | this.getBlue() & 0xFF)) continue;
            textFormatting = tf;
        }
        return String.valueOf(textFormatting) + this.getName() + String.valueOf(class_124.field_1068);
    }

    public static ClientWaypointImpl fromString(String json) {
        WaypointImpl waypoint = (WaypointImpl)GSON.fromJson(json, WaypointImpl.class);
        return new ClientWaypointImpl((Waypoint)waypoint);
    }

    public class_2960 getTextureResource() {
        if (this.getGroup().getIconResourceLocation() != null && this.getGroup().iconOverride()) {
            return this.getGroup().getIconResourceLocation();
        }
        if (this.getIcon() != null && this.getIcon().getResourceLocation() != null) {
            return this.getIcon().getResourceLocation();
        }
        if (WaypointGroupStore.DEATH.getGuid().equals(this.groupId)) {
            return WaypointIcon.DEFAULT_ICON_DEATH;
        }
        return WaypointIcon.DEFAULT_ICON_NORMAL;
    }

    public boolean hasCustomTexture() {
        if (this.getIcon() != null && this.getIcon().getResourceLocation() != null) {
            return this.getIcon().getResourceLocation() != WaypointIcon.DEFAULT_ICON_DEATH && this.getIcon().getResourceLocation() != WaypointIcon.DEFAULT_ICON_NORMAL;
        }
        return false;
    }

    public boolean hasCustomIconColor() {
        return this.hasCustomTexture() && this.getIcon().getColor() != null;
    }

    public String getUuid() {
        return this.getGuid();
    }

    private boolean showOnLocatorBar() {
        WaypointGroupImpl group = (WaypointGroupImpl)this.getGroup();
        if (group == null) {
            return false;
        }
        return group.shouldShowOnLocatorBar() && JourneymapClient.getInstance().getWaypointProperties().displayOnLocatorBar.get() != false && this.isEnabled();
    }

    private class_243 positionFromPlayer() {
        class_746 player = class_310.method_1551().field_1724;
        return class_310.method_1551().field_1724.method_24515().method_19455((class_2382)this.getBlockPos()) > 3 ? class_243.method_24953((class_2382)this.getBlockPos()) : player.method_33571();
    }

    public double yawAngleToCamera(class_1937 level, class_11200.class_11297 camera) {
        class_243 vec3 = camera.method_71156().method_1020(this.positionFromPlayer()).method_70762();
        float f = (float)class_3532.method_15349((double)vec3.method_10215(), (double)vec3.method_10216()) * 57.295776f;
        return class_3532.method_15381((float)camera.method_71155(), (float)f);
    }

    public class_11200.class_11379 pitchDirectionToCamera(class_1937 level, class_11200.class_11204 projector) {
        double d;
        class_243 vec3 = projector.method_70778(this.positionFromPlayer());
        boolean bl = vec3.field_1350 > 1.0;
        double d2 = d = bl ? -vec3.field_1351 : vec3.field_1351;
        if (d < -1.0) {
            return class_11200.class_11379.field_60425;
        }
        if (d > 1.0) {
            return class_11200.class_11379.field_60424;
        }
        if (bl) {
            if (vec3.field_1351 > 0.0) {
                return class_11200.class_11379.field_60424;
            }
            if (vec3.field_1351 < 0.0) {
                return class_11200.class_11379.field_60425;
            }
        }
        return class_11200.class_11379.field_60423;
    }

    public double distanceSquared(class_1297 entity) {
        return entity.method_5707(class_243.method_24953((class_2382)this.getBlockPos()));
    }

    public void renderToLocatorBar(class_332 guiGraphics, int top, class_2960 down, class_2960 up, class_1937 level) {
        if (this.showOnLocatorBar()) {
            class_310 minecraft = class_310.method_1551();
            double d = this.yawAngleToCamera(level, (class_11200.class_11297)minecraft.field_1773.method_19418());
            if (!(d <= -61.0) && !(d > 60.0)) {
                int j = class_3532.method_15386((float)((float)(guiGraphics.method_51421() - 9) / 2.0f));
                class_2960 resourceLocation = this.getTextureResource();
                int color = this.getIconColor();
                int l = (int)(d * 173.0 / 2.0 / 60.0);
                guiGraphics.method_25291(class_10799.field_56883, resourceLocation, j + l, top - 1, 0.0f, 0.0f, 8, 8, 8, 8, color);
                class_11200.class_11379 pitchDirection = this.pitchDirectionToCamera(level, (class_11200.class_11204)minecraft.field_1773);
                if (pitchDirection != class_11200.class_11379.field_60423) {
                    class_2960 resourceLocation2;
                    int m;
                    if (pitchDirection == class_11200.class_11379.field_60425) {
                        m = 6;
                        resourceLocation2 = down;
                    } else {
                        m = -6;
                        resourceLocation2 = up;
                    }
                    guiGraphics.method_52706(class_10799.field_56883, resourceLocation2, j + l, top + m, 7, 5);
                }
            }
        }
    }
}

