/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.google.common.base.Strings;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import journeymap.client.JourneymapClient;
import journeymap.client.command.ClientCommandInvoker;
import journeymap.client.command.CmdChatPosition;
import journeymap.client.command.CmdEditWaypoint;
import journeymap.client.command.CmdReloadWaypoint;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ChatEventHandler {
    private final ClientCommandInvoker clientCommandInvoker = new ClientCommandInvoker();
    private static ChatEventHandler INSTANCE;

    private ChatEventHandler() {
        this.clientCommandInvoker.registerSub(new CmdChatPosition());
        this.clientCommandInvoker.registerSub(new CmdEditWaypoint());
        this.clientCommandInvoker.registerSub(new CmdReloadWaypoint());
    }

    public static ChatEventHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ChatEventHandler();
        }
        return INSTANCE;
    }

    public class_2561 onClientChatEventReceived(class_2561 message) {
        if (JourneymapClient.getInstance().enabled() && message != null) {
            try {
                String text = message.getString();
                if (!Strings.isNullOrEmpty((String)text) && !text.startsWith("jmc")) {
                    return WaypointParser.parseChatForWaypoints(message);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
        return message;
    }

    public boolean onChatEvent(String message) {
        if (JourneymapClient.getInstance().enabled() && message.regionMatches(0, "jmc", 0, 3)) {
            if (message.length() > 3) {
                try {
                    class_746 player = class_310.method_1551().field_1724;
                    message = message.substring(4);
                    this.clientCommandInvoker.execute(player, message.split(" "));
                }
                catch (CommandSyntaxException e) {
                    Journeymap.getLogger().error((Object)e);
                }
            } else {
                String commands = this.clientCommandInvoker.getPossibleCommands();
                String text = "Available sub commands are: " + commands;
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)text));
            }
            return true;
        }
        return false;
    }
}

