/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.datafixers.util.Either;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;

public class ItemInHandGeoLayer<T extends class_1309, O, R extends GeoRenderState>
extends BlockAndItemGeoLayer<T, O, R> {
    protected final String rightHandBone;
    protected final String leftHandBone;

    public ItemInHandGeoLayer(GeoRenderer<T, O, R> renderer) {
        this(renderer, "RightHandItem", "LeftHandItem");
    }

    public ItemInHandGeoLayer(GeoRenderer<T, O, R> renderer, String rightHandBoneName, String leftHandBoneName) {
        super(renderer);
        this.rightHandBone = rightHandBoneName;
        this.leftHandBone = leftHandBoneName;
    }

    @Override
    protected List<BlockAndItemGeoLayer.RenderData<R>> getRelevantBones(R renderState, BakedGeoModel model) {
        boolean isLeftHanded = renderState.getGeckolibData(DataTickets.IS_LEFT_HANDED);
        return List.of(ItemInHandGeoLayer.renderDataForHand(this.rightHandBone, class_1306.field_6183, isLeftHanded, renderState), ItemInHandGeoLayer.renderDataForHand(this.leftHandBone, class_1306.field_6182, isLeftHanded, renderState));
    }

    protected static <R extends GeoRenderState> BlockAndItemGeoLayer.RenderData<R> renderDataForHand(String boneName, R renderState) {
        return ItemInHandGeoLayer.renderDataForHand(boneName, class_1306.field_6183, false, renderState);
    }

    protected static <R extends GeoRenderState> BlockAndItemGeoLayer.RenderData<R> renderDataForHand(String boneName, class_1306 arm, boolean isLeftHanded, R renderState) {
        class_1306 mainHandArm = isLeftHanded ? class_1306.field_6182 : class_1306.field_6183;
        class_1304 slot = arm == mainHandArm ? class_1304.field_6173 : class_1304.field_6171;
        class_811 context = switch (slot) {
            case class_1304.field_6173 -> {
                if (mainHandArm == class_1306.field_6183) {
                    yield class_811.field_4320;
                }
                yield class_811.field_4323;
            }
            case class_1304.field_6171 -> {
                if (mainHandArm == class_1306.field_6183) {
                    yield class_811.field_4323;
                }
                yield class_811.field_4322;
            }
            default -> class_811.field_4315;
        };
        return new BlockAndItemGeoLayer.RenderData<GeoRenderState>(boneName, context, (bone, renderState2) -> Either.left((Object)((class_1799)renderState2.getGeckolibData(DataTickets.EQUIPMENT_BY_SLOT).get(slot))));
    }

    @Override
    public void addRenderData(T animatable, O relatedObject, R renderState) {
        EnumMap<class_1304, class_1799> equipment = renderState.getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(class_1304.class));
        equipment.put(class_1304.field_6173, animatable.method_6047());
        equipment.put(class_1304.field_6171, animatable.method_6079());
        renderState.addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, equipment);
        renderState.addGeckolibData(DataTickets.IS_LEFT_HANDED, animatable.method_6068() == class_1306.field_6182);
    }

    @Override
    protected void renderStackForBone(class_4587 poseStack, GeoBone bone, class_1799 stack, class_811 displayContext, R renderState, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (displayContext == class_811.field_4320) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(90.0f));
            poseStack.method_46416(0.0f, 0.125f, -0.0625f);
            if (stack.method_7909() instanceof class_1819) {
                poseStack.method_22904(0.0, 0.125, -0.25);
            }
        } else if (displayContext == class_811.field_4323) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
            poseStack.method_46416(0.0f, 0.125f, -0.0625f);
            if (stack.method_7909() instanceof class_1819) {
                poseStack.method_22904(0.0, 0.125, 0.25);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
            }
        }
        super.renderStackForBone(poseStack, bone, stack, displayContext, renderState, bufferSource, packedLight, packedOverlay);
    }
}

