/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public abstract class BlockAndItemGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    public BlockAndItemGeoLayer(GeoRenderer<T, O, R> renderer) {
        super(renderer);
    }

    protected abstract List<RenderData<R>> getRelevantBones(R var1, BakedGeoModel var2);

    @Override
    public abstract void addRenderData(T var1, O var2, R var3);

    @Override
    public void addPerBoneRender(R renderState, BakedGeoModel model, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        for (RenderData<R> renderData : this.getRelevantBones(renderState, model)) {
            model.getBone(renderData.boneName).ifPresentOrElse(bone -> this.createPerBoneRender((GeoBone)bone, renderData, consumer, renderState), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(GeoBone bone, RenderData<R> renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer, R renderState) {
        Either<class_1799, class_2680> renderObject = renderData.retrievalFunction().apply(bone, renderState);
        renderObject.ifLeft(stack -> {
            if (!stack.method_7960()) {
                consumer.accept(bone, (renderState2, poseStack, bone2, renderType, bufferSource, packedLight, packedOverlay, renderColor) -> {
                    RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
                    this.renderStackForBone(poseStack, bone, (class_1799)stack, renderData.displayContext, renderState, bufferSource, packedLight, packedOverlay);
                });
            }
        }).ifRight(blockState -> {
            if (!blockState.method_26215()) {
                consumer.accept(bone, (renderState2, poseStack, bone2, renderType, bufferSource, packedLight, packedOverlay, renderColor) -> {
                    RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
                    this.renderBlockForBone(poseStack, bone, (class_2680)blockState, renderState, bufferSource, packedLight, packedOverlay);
                });
            }
        });
    }

    protected void renderStackForBone(class_4587 poseStack, GeoBone bone, class_1799 stack, class_811 displayContext, R renderState, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_310.method_1551().method_1480().method_23178(stack, displayContext, packedLight, packedOverlay, poseStack, bufferSource, ClientUtil.getLevel(), renderState.getGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID).intValue());
    }

    protected void renderBlockForBone(class_4587 poseStack, GeoBone bone, class_2680 state, R renderState, class_4597 bufferSource, int packedLight, int packedOverlay) {
        poseStack.method_22903();
        poseStack.method_46416(-0.25f, -0.25f, -0.25f);
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        class_310.method_1551().method_1541().method_3353(state, poseStack, bufferSource, packedLight, class_4608.field_21444);
        poseStack.method_22909();
    }

    public record RenderData<R extends GeoRenderState>(String boneName, class_811 displayContext, BiFunction<GeoBone, R, Either<@NotNull class_1799, @NotNull class_2680>> retrievalFunction) {
    }
}

