/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_10017;
import net.minecraft.class_10034;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoObjectRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public interface GeoRenderEvent<T extends GeoAnimatable, O, R extends GeoRenderState> {
    public GeoRenderer<T, O, R> getRenderer();

    public R getRenderState();

    @Nullable
    default public <D> D getRenderData(DataTicket<D> dataTicket) {
        R renderState = this.getRenderState();
        return renderState.hasGeckolibData(dataTicket) ? (D)this.getRenderState().getGeckolibData(dataTicket) : null;
    }

    default public float getPartialTick() {
        return this.getRenderData(DataTickets.PARTIAL_TICK).floatValue();
    }

    default public int packedLight() {
        return this.getRenderData(DataTickets.PACKED_LIGHT);
    }

    default public Class<? extends GeoAnimatable> getAnimatableClass() {
        return this.getRenderData(DataTickets.ANIMATABLE_CLASS);
    }

    public static abstract class Object<T extends GeoAnimatable>
    implements GeoRenderEvent<T, Void, GeoRenderState> {
        private final GeoObjectRenderer<T> renderer;
        private final GeoRenderState renderState;

        public Object(GeoObjectRenderer<T> renderer, GeoRenderState renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public GeoRenderState getRenderState() {
            return this.renderState;
        }

        public GeoObjectRenderer<T> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends GeoAnimatable>
        extends Object<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Post(GeoObjectRenderer<T> renderer, GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable> {
                public void handle(Post<T> var1);
            }
        }

        public static class Pre<T extends GeoAnimatable>
        extends Object<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Pre(GeoObjectRenderer<T> renderer, GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable> {
                public boolean handle(Pre<T> var1);
            }
        }

        public static class CompileRenderState<T extends GeoAnimatable>
        extends Object<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final T animatable;

            public CompileRenderState(GeoObjectRenderer<T> renderer, GeoRenderState renderState, T animatable) {
                super(renderer, renderState);
                this.animatable = animatable;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return this.getRenderState().hasGeckolibData(dataTicket);
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable> {
                public void handle(CompileRenderState<T> var1);
            }
        }

        public static class CompileRenderLayers<T extends GeoAnimatable>
        extends Object<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoObjectRenderer<T> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public GeoRenderState getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, Void, GeoRenderState> renderLayer) {
                ((GeoObjectRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable> {
                public void handle(CompileRenderLayers<T> var1);
            }
        }
    }

    public static abstract class Item<T extends class_1792>
    implements GeoRenderEvent<T, GeoItemRenderer.RenderData, GeoRenderState> {
        private final GeoItemRenderer<T> renderer;
        private final GeoRenderState renderState;

        public Item(GeoItemRenderer<T> renderer, GeoRenderState renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public GeoRenderState getRenderState() {
            return this.renderState;
        }

        public GeoItemRenderer<T> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends class_1792>
        extends Item<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Post(GeoItemRenderer<T> renderer, GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792> {
                public void handle(Post<T> var1);
            }
        }

        public static class Pre<T extends class_1792>
        extends Item<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Pre(GeoItemRenderer<T> renderer, GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792> {
                public boolean handle(Pre<T> var1);
            }
        }

        public static class CompileRenderState<T extends class_1792>
        extends Item<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final T animatable;
            private final GeoItemRenderer.RenderData renderData;

            public CompileRenderState(GeoItemRenderer<T> renderer, GeoRenderState renderState, T animatable, GeoItemRenderer.RenderData renderData) {
                super(renderer, renderState);
                this.animatable = animatable;
                this.renderData = renderData;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public GeoItemRenderer.RenderData getRenderData() {
                return this.renderData;
            }

            public class_1799 getItemStack() {
                return this.renderData.itemStack();
            }

            public class_811 getRenderPerspective() {
                return this.renderData.renderPerspective();
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return this.getRenderState().hasGeckolibData(dataTicket);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792> {
                public void handle(CompileRenderState<T> var1);
            }
        }

        public static class CompileRenderLayers<T extends class_1792>
        extends Item<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoItemRenderer<T> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public GeoRenderState getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, GeoItemRenderer.RenderData, GeoRenderState> renderLayer) {
                ((GeoItemRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792> {
                public void handle(CompileRenderLayers<T> var1);
            }
        }
    }

    public static abstract class ReplacedEntity<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
    implements GeoRenderEvent<T, E, R> {
        private final GeoReplacedEntityRenderer<T, E, R> renderer;
        private final R renderState;

        public ReplacedEntity(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public R getRenderState() {
            return this.renderState;
        }

        @Override
        public GeoReplacedEntityRenderer<T, E, R> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Post(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable, E extends class_1297, R extends class_10017> {
                public void handle(Post<T, E, R> var1);
            }
        }

        public static class Pre<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Pre(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable, E extends class_1297, R extends class_10017> {
                public boolean handle(Pre<T, E, R> var1);
            }
        }

        public static class CompileRenderState<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final GeoAnimatable animatable;
            private final E entity;

            public CompileRenderState(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState, GeoAnimatable animatable, E entity) {
                super(renderer, renderState);
                this.animatable = animatable;
                this.entity = entity;
            }

            public GeoAnimatable getAnimatable() {
                return this.animatable;
            }

            public class_1297 getReplacedEntity() {
                return this.entity;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)this.getRenderState()).addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return ((GeoRenderState)this.getRenderState()).hasGeckolibData(dataTicket);
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable, E extends class_1297, R extends class_10017> {
                public void handle(CompileRenderState<T, E, R> var1);
            }
        }

        public static class CompileRenderLayers<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoReplacedEntityRenderer<T, E, R> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, E, R> renderLayer) {
                ((GeoReplacedEntityRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener<T extends GeoAnimatable, E extends class_1297, R extends class_10017> {
                public void handle(CompileRenderLayers<T, E, R> var1);
            }
        }
    }

    public static abstract class Entity<T extends class_1297, R extends class_10017>
    implements GeoRenderEvent<T, Void, R> {
        private final GeoEntityRenderer<T, R> renderer;
        private final R renderState;

        public Entity(GeoEntityRenderer<T, R> renderer, R renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public R getRenderState() {
            return this.renderState;
        }

        public GeoEntityRenderer<T, R> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Post(GeoEntityRenderer<T, R> renderer, R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1297, R extends class_10017> {
                public void handle(Post<T, R> var1);
            }
        }

        public static class Pre<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Pre(GeoEntityRenderer<T, R> renderer, R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1297, R extends class_10017> {
                public boolean handle(Pre<T, R> var1);
            }
        }

        public static class CompileRenderState<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final T animatable;

            public CompileRenderState(GeoEntityRenderer<T, R> renderer, R renderState, T animatable) {
                super(renderer, renderState);
                this.animatable = animatable;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)this.getRenderState()).addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return ((GeoRenderState)this.getRenderState()).hasGeckolibData(dataTicket);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1297, R extends class_10017> {
                public void handle(CompileRenderState<T, R> var1);
            }
        }

        public static class CompileRenderLayers<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoEntityRenderer<T, R> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, Void, R> renderLayer) {
                ((GeoEntityRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1297, R extends class_10017> {
                public void handle(CompileRenderLayers<T, R> var1);
            }
        }
    }

    public static abstract class Armor<T extends class_1792, R extends class_10034>
    implements GeoRenderEvent<T, GeoArmorRenderer.RenderData, R> {
        private final GeoArmorRenderer<T, R> renderer;
        private final R renderState;

        public Armor(GeoArmorRenderer<T, R> renderer, R renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        public GeoArmorRenderer<T, R> getRenderer() {
            return this.renderer;
        }

        @Override
        public R getRenderState() {
            return this.renderState;
        }

        public class_1304 getEquipmentSlot() {
            return this.getRenderData(DataTickets.EQUIPMENT_SLOT);
        }

        public static class Post<T extends class_1792, R extends class_10034>
        extends Armor<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Post(GeoArmorRenderer<T, R> renderer, R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792, R extends class_10034> {
                public void handle(Post<T, R> var1);
            }
        }

        public static class Pre<T extends class_1792, R extends class_10034>
        extends Armor<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Pre(GeoArmorRenderer<T, R> renderer, R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792, R extends class_10034> {
                public boolean handle(Pre<T, R> var1);
            }
        }

        public static class CompileRenderState<T extends class_1792, R extends class_10034>
        extends Armor<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final T animatable;
            private final GeoArmorRenderer.RenderData renderData;

            public CompileRenderState(GeoArmorRenderer<T, R> renderer, R renderState, T animatable, GeoArmorRenderer.RenderData renderData) {
                super(renderer, renderState);
                this.animatable = animatable;
                this.renderData = renderData;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public GeoArmorRenderer.RenderData getRenderData() {
                return this.renderData;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)this.getRenderState()).addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return ((GeoRenderState)this.getRenderState()).hasGeckolibData(dataTicket);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792, R extends class_10034> {
                public void handle(CompileRenderState<T, R> var1);
            }
        }

        public static class CompileRenderLayers<T extends class_1792, R extends class_10034>
        extends Armor<T, R> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoArmorRenderer<T, R> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, GeoArmorRenderer.RenderData, R> renderLayer) {
                ((GeoArmorRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_1792, R extends class_10034> {
                public void handle(CompileRenderLayers<T, R> var1);
            }
        }
    }

    public static abstract class Block<T extends class_2586>
    implements GeoRenderEvent<T, Void, GeoRenderState> {
        private final GeoBlockRenderer<T> renderer;
        private final GeoRenderState renderState;

        public Block(GeoBlockRenderer<T> renderer, GeoRenderState renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public GeoRenderState getRenderState() {
            return this.renderState;
        }

        public GeoBlockRenderer<T> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends class_2586>
        extends Block<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Post(GeoBlockRenderer<T> renderer, GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_2586> {
                public void handle(Post<T> var1);
            }
        }

        public static class Pre<T extends class_2586>
        extends Block<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final class_4587 poseStack;
            private final BakedGeoModel model;
            private final class_4597 bufferSource;

            public Pre(GeoBlockRenderer<T> renderer, GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public class_4587 getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public class_4597 getBufferSource() {
                return this.bufferSource;
            }

            @FunctionalInterface
            public static interface Listener<T extends class_2586> {
                public boolean handle(Pre<T> var1);
            }
        }

        public static class CompileRenderState<T extends class_2586>
        extends Block<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final T animatable;

            public CompileRenderState(GeoBlockRenderer<T> renderer, GeoRenderState renderState, T animatable) {
                super(renderer, renderState);
                this.animatable = animatable;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return this.getRenderState().hasGeckolibData(dataTicket);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_2586> {
                public void handle(CompileRenderState<T> var1);
            }
        }

        public static class CompileRenderLayers<T extends class_2586>
        extends Block<T> {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoBlockRenderer<T> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public GeoRenderState getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, Void, GeoRenderState> renderLayer) {
                ((GeoBlockRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener<T extends class_2586> {
                public void handle(CompileRenderLayers<T> var1);
            }
        }
    }
}

