/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.object;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.loading.json.raw.ModelProperties;

public record BakedGeoModel(List<GeoBone> topLevelBones, ModelProperties properties, Supplier<Map<String, GeoBone>> boneMap) {
    public BakedGeoModel(List<GeoBone> topLevelBones, ModelProperties properties) {
        this(topLevelBones, properties, BakedGeoModel.createBoneMap(topLevelBones));
    }

    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable(this.boneMap.get().get(name));
    }

    private static Supplier<Map<String, GeoBone>> createBoneMap(List<GeoBone> topLevelBones) {
        return Suppliers.memoize(() -> {
            Object2ReferenceOpenHashMap boneMap = new Object2ReferenceOpenHashMap();
            for (GeoBone bone : topLevelBones) {
                boneMap.put((Object)bone.getName(), (Object)bone);
                for (GeoBone child : BakedGeoModel.collectChildBones(bone)) {
                    boneMap.put((Object)child.getName(), (Object)child);
                }
            }
            return boneMap;
        });
    }

    private static List<GeoBone> collectChildBones(GeoBone bone) {
        ObjectArrayList bones = new ObjectArrayList();
        for (GeoBone child : bone.getChildBones()) {
            bones.add(child);
            bones.addAll(BakedGeoModel.collectChildBones(child));
        }
        return bones;
    }
}

