/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;

public final class SyncedSingletonAnimatableCache {
    private static final Int2ObjectMap<String> ANIMATABLE_IDENTITIES = new Int2ObjectOpenHashMap();
    private static final Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void registerSyncedAnimatable(SingletonGeoAnimatable animatable) {
        Map<String, GeoAnimatable> map = SYNCED_ANIMATABLES;
        synchronized (map) {
            GeoAnimatable existing = SYNCED_ANIMATABLES.put(SyncedSingletonAnimatableCache.getOrCreateId(animatable), animatable);
            if (existing == null) {
                GeckoLibConstants.LOGGER.debug("Registered SyncedAnimatable for {}", animatable.getClass());
            }
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static GeoAnimatable getSyncedAnimatable(String syncedAnimatableId) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(syncedAnimatableId);
        if (animatable == null) {
            GeckoLibConstants.LOGGER.error("Attempting to retrieve unregistered synced animatable! ({})", (Object)syncedAnimatableId);
        }
        return animatable;
    }

    public static String getOrCreateId(SingletonGeoAnimatable animatable) {
        return (String)ANIMATABLE_IDENTITIES.computeIfAbsent(System.identityHashCode(animatable), i -> {
            String baseId = animatable.getClass().getName();
            i = 0;
            while (SYNCED_ANIMATABLES.containsKey(baseId + i)) {
                ++i;
            }
            return baseId + i;
        });
    }
}

