/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Predicate;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.LoadedConfig;
import net.blay09.mods.balm.api.config.LoadedTableConfig;
import net.blay09.mods.balm.api.config.MutableLoadedConfig;
import net.blay09.mods.balm.api.config.PropertyAwareConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.api.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.api.config.schema.builder.ConfigCategory;
import net.blay09.mods.balm.common.config.AbstractBalmConfig;
import net.blay09.mods.balm.common.config.ConfigSync;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ClientboundConfigPacket(BalmConfigSchema schema, LoadedConfig config) implements class_8710
{
    public static final class_8710.class_9154<ClientboundConfigPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"balm", (String)"config"));
    public static final class_9139<class_9129, ClientboundConfigPacket> STREAM_CODEC = class_9139.method_56437(ClientboundConfigPacket::encode, ClientboundConfigPacket::decode);

    private static ClientboundConfigPacket decode(class_9129 buf) {
        class_2960 identifier = (class_2960)class_2960.field_48267.decode((Object)buf);
        BalmConfigSchema schema = Balm.getConfig().getSchema(identifier);
        if (schema == null) {
            throw new RuntimeException("Received config packet for unknown schema: " + String.valueOf(identifier));
        }
        LoadedTableConfig config = new LoadedTableConfig();
        int rootPropertyCount = buf.method_10816();
        for (int j = 0; j < rootPropertyCount; ++j) {
            String property = buf.method_19772();
            ConfiguredProperty<?> propertySchema = schema.findRootProperty(property);
            ClientboundConfigPacket.decodePropertyInto(propertySchema, (ByteBuf)buf, config);
        }
        int categoryCount = buf.method_10816();
        for (int i = 0; i < categoryCount; ++i) {
            String category = buf.method_19772();
            int propertyCount = buf.method_10816();
            for (int j = 0; j < propertyCount; ++j) {
                String property = buf.method_19772();
                ConfiguredProperty<?> propertySchema = schema.findProperty(category, property);
                ClientboundConfigPacket.decodePropertyInto(propertySchema, (ByteBuf)buf, config);
            }
        }
        return new ClientboundConfigPacket(schema, config);
    }

    private static void encode(class_9129 buf, ClientboundConfigPacket packet) {
        class_2960.field_48267.encode((Object)buf, (Object)packet.schema.identifier());
        List<ConfiguredProperty> rootProperties = packet.schema.rootProperties().stream().filter(ConfiguredProperty::synced).toList();
        buf.method_10804(rootProperties.size());
        for (ConfiguredProperty rootProperty : rootProperties) {
            buf.method_10814(rootProperty.name());
            ClientboundConfigPacket.encodeProperty(rootProperty, (ByteBuf)buf, packet.config);
        }
        List<ConfigCategory> categories = packet.schema.categories().stream().filter(ConfigSync::hasSyncedProperties).toList();
        buf.method_10804(categories.size());
        for (ConfigCategory category : categories) {
            buf.method_10814(category.name());
            List<ConfiguredProperty> properties = category.properties().stream().filter(ConfiguredProperty::synced).toList();
            buf.method_10804(properties.size());
            for (ConfiguredProperty property : properties) {
                buf.method_10814(property.name());
                ClientboundConfigPacket.encodeProperty(property, (ByteBuf)buf, packet.config);
            }
        }
    }

    private static <T> void decodePropertyInto(ConfiguredProperty<T> property, ByteBuf buf, MutableLoadedConfig config) {
        Object value = property.streamCodec().decode((Object)buf);
        config.setRaw(property, value);
    }

    private static <T> void encodeProperty(ConfiguredProperty<T> property, ByteBuf buf, LoadedConfig config) {
        T value = config.getRaw(property);
        property.streamCodec().encode((Object)buf, value);
    }

    public static void handle(class_1657 player, ClientboundConfigPacket packet) {
        Predicate<ConfiguredProperty<?>> predicate;
        MutableLoadedConfig localConfig = Balm.getConfig().getLocalConfig(packet.schema);
        MutableLoadedConfig newConfig = localConfig.copy();
        Object object = packet.config;
        if (object instanceof PropertyAwareConfig) {
            PropertyAwareConfig propertyAwareConfig = (PropertyAwareConfig)object;
            predicate = propertyAwareConfig::hasProperty;
        } else {
            predicate = it -> true;
        }
        Predicate<ConfiguredProperty<?>> propertyFilter = predicate;
        newConfig.applyFrom(packet.schema, packet.config, propertyFilter);
        object = Balm.getConfig();
        if (object instanceof AbstractBalmConfig) {
            AbstractBalmConfig config = (AbstractBalmConfig)object;
            config.setActiveConfig(packet.schema, newConfig);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

