/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config.annotation;

import com.google.common.base.Predicates;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.impl.config.annotation.ValueEntry;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public abstract class LimitedEntry<T>
extends ValueEntry<T> {
    public LimitedEntry(Field field) {
        super(field);
    }

    private Set<String> getAllowedValues() {
        Config.AllowedValues allowedValues = this.field.getDeclaredAnnotation(Config.AllowedValues.class);
        if (allowedValues != null && allowedValues.values().length != 0) {
            return new LinkedHashSet<String>(Arrays.asList(allowedValues.values()));
        }
        return this.getAllValues();
    }

    Set<String> getAllValues() {
        return Collections.emptySet();
    }

    public final Set<String> getAllowedValueStrings() {
        Set<String> allValues;
        Set<String> allowedValues = this.getAllowedValues();
        if (!allowedValues.isEmpty() && !(allValues = this.getAllValues()).isEmpty()) {
            for (String s : allowedValues) {
                if (allValues.contains(s)) continue;
                throw new IllegalArgumentException(s + " is not contained in " + String.valueOf(allValues));
            }
        }
        return allowedValues;
    }

    static <E extends Enum<E>> Set<String> getAllEnumValues(Class<?> clazz) {
        return Arrays.stream(clazz.getEnumConstants()).map(value -> (Enum)value).map(Enum::name).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public List<String> getComments(@Nullable Object o) {
        List<String> comments = super.getComments(o);
        this.addAllowedValuesComment(comments);
        return comments;
    }

    public void addAllowedValuesComment(List<String> comments) {
        Set<String> allowedValues = this.getAllowedValueStrings();
        if (!allowedValues.isEmpty()) {
            comments.add("Allowed Values: " + String.join((CharSequence)", ", allowedValues));
        }
    }

    public Predicate<Object> getValidator() {
        Set<String> allowedValues = this.getAllowedValueStrings();
        if (!allowedValues.isEmpty()) {
            return o -> {
                if (o != null) {
                    String string = o instanceof Enum ? ((Enum)o).name() : o.toString();
                    return allowedValues.contains(string);
                }
                return false;
            };
        }
        return this.getEmptyValidator();
    }

    public Predicate<Object> getEmptyValidator() {
        return Predicates.alwaysTrue();
    }

    public static final class ListEntry
    extends LimitedEntry<List<?>> {
        public ListEntry(Field field) {
            super(field);
        }

        @Nullable
        public Type getListType() {
            ParameterizedType type;
            Type type2 = this.field.getGenericType();
            if (type2 instanceof ParameterizedType && (type = (ParameterizedType)type2).getActualTypeArguments().length > 0) {
                return type.getActualTypeArguments()[0];
            }
            return null;
        }

        @Override
        public ModConfigSpec.ConfigValue<List<?>> getConfigValue(ModConfigSpec.Builder builder, @Nullable Object o) {
            Supplier<?> newElementSupplier = ListEntry.getNewElementSupplier(this.getListType());
            return builder.defineList(this.getName(), (List)this.getDefaultValue(o), newElementSupplier, this.getValidator());
        }

        @Override
        public Set<String> getAllValues() {
            Class clazz;
            Type type = this.getListType();
            if (type instanceof Class && (clazz = (Class)type).isEnum()) {
                return ListEntry.getAllEnumValues(clazz);
            }
            return super.getAllValues();
        }

        static Supplier<?> getNewElementSupplier(Type type) {
            Objects.requireNonNull(type, "type is null");
            return () -> {
                Object object;
                Type type2 = type;
                Objects.requireNonNull(type2);
                Type selector0$temp = type2;
                int index$1 = 0;
                block8: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class, Class.class, Class.class, Class.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            Class clazz = (Class)selector0$temp;
                            if (clazz != String.class) {
                                index$1 = 1;
                                continue block8;
                            }
                            object = "";
                            break block8;
                        }
                        case 1: {
                            Class clazz = (Class)selector0$temp;
                            if (!clazz.isEnum()) {
                                index$1 = 2;
                                continue block8;
                            }
                            object = clazz.getEnumConstants()[0];
                            break block8;
                        }
                        case 2: {
                            Class clazz = (Class)selector0$temp;
                            if (clazz != Boolean.class) {
                                index$1 = 3;
                                continue block8;
                            }
                            object = false;
                            break block8;
                        }
                        case 3: {
                            Class clazz = (Class)selector0$temp;
                            if (clazz != Integer.class) {
                                index$1 = 4;
                                continue block8;
                            }
                            object = 0;
                            break block8;
                        }
                        case 4: {
                            Class clazz = (Class)selector0$temp;
                            if (clazz != Long.class) {
                                index$1 = 5;
                                continue block8;
                            }
                            object = 0L;
                            break block8;
                        }
                        case 5: {
                            Class clazz = (Class)selector0$temp;
                            if (clazz != Double.class) {
                                index$1 = 6;
                                continue block8;
                            }
                            object = 0.0;
                            break block8;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported list type: " + String.valueOf(type));
                        }
                    }
                    break;
                }
                return object;
            };
        }
    }

    public static final class EnumEntry<E extends Enum<E>>
    extends LimitedEntry<E> {
        public EnumEntry(Field field) {
            super(field);
        }

        @Override
        public ModConfigSpec.EnumValue<E> getConfigValue(ModConfigSpec.Builder builder, @Nullable Object o) {
            return builder.defineEnum(this.getName(), (Enum)this.getDefaultValue(o), this.getValidator());
        }

        @Override
        Set<String> getAllValues() {
            return EnumEntry.getAllEnumValues(this.field.getType());
        }

        @Override
        public void addAllowedValuesComment(List<String> comments) {
        }
    }

    public static final class StringEntry
    extends LimitedEntry<String> {
        public StringEntry(Field field) {
            super(field);
        }

        @Override
        public ModConfigSpec.ConfigValue<String> getConfigValue(ModConfigSpec.Builder builder, @Nullable Object o) {
            return builder.define(this.getName(), (Object)((String)this.getDefaultValue(o)), this.getValidator());
        }

        @Override
        public Predicate<Object> getEmptyValidator() {
            return String.class::isInstance;
        }
    }
}

