/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.core.context;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.context.VillagerTradesContext;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;

public final class VillagerTradesContextFabricImpl
implements VillagerTradesContext {
    @Override
    public void registerVillagerTrades(class_5321<class_3852> profession, VillagerTradesContext.VillagerLevel level, Consumer<List<class_3853.class_1652>> factories) {
        Objects.requireNonNull(profession, "profession is null");
        Objects.requireNonNull(level, "level is null");
        Objects.requireNonNull(factories, "factories is null");
        TradeOfferHelper.registerVillagerOffers(profession, (int)level.getLevel(), factories);
    }

    @Override
    public void registerWanderingTrades(VillagerTradesContext.WanderingTradesPool pool, class_3853.class_1652 ... itemListings) {
        Objects.requireNonNull(pool, "pool is null");
        Objects.requireNonNull(itemListings, "item listings is null");
        Preconditions.checkArgument((itemListings.length > 0 ? 1 : 0) != 0, (Object)"item listings is empty");
        TradeOfferHelper.registerWanderingTraderOffers(builder -> {
            class_2960 resourceLocation = this.getTradesPool(pool);
            builder.addOffersToPool(resourceLocation, itemListings);
        });
    }

    class_2960 getTradesPool(VillagerTradesContext.WanderingTradesPool pool) {
        return switch (pool) {
            default -> throw new MatchException(null, null);
            case VillagerTradesContext.WanderingTradesPool.PURCHASES -> TradeOfferHelper.WanderingTraderOffersBuilder.BUY_ITEMS_POOL;
            case VillagerTradesContext.WanderingTradesPool.COMMON_SALES -> TradeOfferHelper.WanderingTraderOffersBuilder.SELL_COMMON_ITEMS_POOL;
            case VillagerTradesContext.WanderingTradesPool.SPECIAL_SALES -> TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL;
        };
    }
}

