/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client;

import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.gui.HealthBarRenderer;
import fuzs.overflowingbars.client.handler.GuiLayerHandler;
import fuzs.overflowingbars.client.helper.ChatOffsetHelper;
import fuzs.overflowingbars.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.CustomizeChatPanelCallback;
import net.minecraft.class_310;
import net.minecraft.class_329;

public class OverflowingBarsClient
implements ClientModConstructor {
    public void onConstructMod() {
        OverflowingBarsClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ClientTickEvents.START.register(HealthBarRenderer.INSTANCE::onStartTick);
        CustomizeChatPanelCallback.EVENT.register(GuiLayerHandler::onRenderChatPanel);
    }

    public void onRegisterGuiLayers(GuiLayersContext context) {
        if (((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.allowHealthLayers) {
            context.replaceGuiLayer(GuiLayersContext.PLAYER_HEALTH, layer -> GuiLayerHandler::onRenderPlayerHealth);
            context.addLeftStatusBarHeightProvider(GuiLayersContext.PLAYER_HEALTH, player -> (ChatOffsetHelper.twoHealthRows(player) ? 20 : 10) + ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.manualRowShift());
        }
        if (((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor.allowArmorLayers) {
            context.replaceGuiLayer(GuiLayersContext.ARMOR_LEVEL, layer -> GuiLayerHandler::onRenderArmorLevel);
            context.addLeftStatusBarHeightProvider(GuiLayersContext.ARMOR_LEVEL, player -> {
                if (ChatOffsetHelper.armorRow(player)) {
                    return 10 + ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor.manualRowShift();
                }
                return 0;
            });
        }
        context.registerGuiLayer(GuiLayersContext.ARMOR_LEVEL, GuiLayerHandler.TOUGHNESS_LEVEL_LEFT_LOCATION, (guiGraphics, deltaTracker) -> GuiLayerHandler.onRenderToughnessLevel(guiGraphics, deltaTracker, GuiLayerHandler.TOUGHNESS_LEVEL_LEFT_LOCATION, true));
        context.registerGuiLayer(GuiLayersContext.FOOD_LEVEL, GuiLayerHandler.TOUGHNESS_LEVEL_RIGHT_LOCATION, (guiGraphics, deltaTracker) -> {
            class_329 gui = class_310.method_1551().field_1705;
            int vehicleMaxHearts = gui.method_1744(gui.method_1734());
            if (vehicleMaxHearts == 0) {
                GuiLayerHandler.onRenderToughnessLevel(guiGraphics, deltaTracker, GuiLayerHandler.TOUGHNESS_LEVEL_RIGHT_LOCATION, false);
            }
        });
        context.registerGuiLayer(GuiLayersContext.VEHICLE_HEALTH, GuiLayerHandler.TOUGHNESS_LEVEL_RIGHT_MOUNTED_LOCATION, (guiGraphics, deltaTracker) -> {
            class_329 gui = class_310.method_1551().field_1705;
            int vehicleMaxHearts = gui.method_1744(gui.method_1734());
            if (vehicleMaxHearts != 0) {
                GuiLayerHandler.onRenderToughnessLevel(guiGraphics, deltaTracker, GuiLayerHandler.TOUGHNESS_LEVEL_RIGHT_MOUNTED_LOCATION, false);
            }
        });
        context.addLeftStatusBarHeightProvider(GuiLayerHandler.TOUGHNESS_LEVEL_LEFT_LOCATION, player -> {
            if (ChatOffsetHelper.toughnessRow(player) && ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness.leftSide) {
                return 10 + ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness.manualRowShift();
            }
            return 0;
        });
        context.addRightStatusBarHeightProvider(GuiLayerHandler.TOUGHNESS_LEVEL_RIGHT_LOCATION, player -> {
            class_329 gui = class_310.method_1551().field_1705;
            int vehicleMaxHearts = gui.method_1744(gui.method_1734());
            if (vehicleMaxHearts == 0 && ChatOffsetHelper.toughnessRow(player) && !((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness.leftSide) {
                return 10 + ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness.manualRowShift();
            }
            return 0;
        });
        context.addRightStatusBarHeightProvider(GuiLayerHandler.TOUGHNESS_LEVEL_RIGHT_MOUNTED_LOCATION, player -> {
            class_329 gui = class_310.method_1551().field_1705;
            int vehicleMaxHearts = gui.method_1744(gui.method_1734());
            if (vehicleMaxHearts != 0 && ChatOffsetHelper.toughnessRow(player) && !((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness.leftSide) {
                return 10 + ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness.manualRowShift();
            }
            return 0;
        });
    }
}

