/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_3612;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.NarratableComponent;
import snownee.jade.util.FluidTextHelper;

public class FluidView {
    public static final class_2561 EMPTY_FLUID = class_2561.method_43471((String)"jade.fluid.empty");
    public Element overlay;
    public class_2561 current;
    public class_2561 max;
    public float ratio;
    @Nullable
    public class_2561 fluidName;
    @Nullable
    public class_2561 overrideText;

    public FluidView(Element overlay) {
        this.overlay = overlay;
        Objects.requireNonNull(overlay);
    }

    @Nullable
    public static FluidView readDefault(Data data) {
        if (data.capacity <= 0L || data.fluids.size() > 1) {
            return null;
        }
        JadeFluidObject fluidObject = data.fluids.isEmpty() ? JadeFluidObject.empty() : data.fluids.getFirst();
        long amount = fluidObject.getAmount();
        FluidView view = new FluidView(JadeUI.fluid(fluidObject));
        view.fluidName = fluidObject.getDisplayName();
        view.current = FluidTextHelper.getMillibuckets(amount, true);
        view.max = FluidTextHelper.getMillibuckets(data.capacity, true);
        view.ratio = (float)((double)amount / (double)data.capacity);
        if (fluidObject.getType().method_15780(class_3612.field_15906)) {
            view.overrideText = NarratableComponent.translatable("jade.fluid", EMPTY_FLUID, NarratableComponent.attach((class_2561)class_2561.method_43470((String)view.max.getString()), view.max));
        }
        return view;
    }

    public record Data(List<JadeFluidObject> fluids, long capacity) {
        public static final class_9139<class_9129, Data> STREAM_CODEC = class_9139.method_56435((class_9139)JadeFluidObject.STREAM_CODEC.method_56433(class_9135.method_56363()), Data::fluids, (class_9139)class_9135.field_54505, Data::capacity, Data::new);

        public Data(JadeFluidObject fluid, long capacity) {
            this(List.of(fluid), capacity);
        }
    }
}

