/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.math.IntMath;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.util.CommonProxy;

public abstract class ItemIterator<T> {
    public static final AtomicLong version = new AtomicLong();
    protected final Function<Accessor<?>, @Nullable T> containerFinder;
    protected final int fromIndex;
    protected boolean finished;
    protected int currentIndex;

    protected ItemIterator(Function<Accessor<?>, @Nullable T> containerFinder, int fromIndex) {
        this.containerFinder = containerFinder;
        this.currentIndex = this.fromIndex = fromIndex;
    }

    @Nullable
    public T find(Accessor<?> accessor) {
        return this.containerFinder.apply(accessor);
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public long getVersion(T container) {
        return version.getAndIncrement();
    }

    public abstract Stream<class_1799> populate(T var1, int var2);

    public void reset() {
        this.currentIndex = this.fromIndex;
        this.finished = false;
    }

    public void afterPopulate(int count) {
        this.currentIndex += count;
        if (count == 0 || this.currentIndex >= 10000) {
            this.finished = true;
        }
    }

    public float getCollectingProgress() {
        return Float.NaN;
    }

    public static abstract class SlotlessItemIterator<T>
    extends ItemIterator<T> {
        protected SlotlessItemIterator(Function<Accessor<?>, @Nullable T> containerFinder, int fromIndex) {
            super(containerFinder, fromIndex);
        }

        @Override
        public Stream<class_1799> populate(T container, int amount) {
            return this.populateRaw(container).skip(this.currentIndex).limit(amount);
        }

        protected abstract Stream<class_1799> populateRaw(T var1);
    }

    public static class ContainerItemIterator
    extends SlottedItemIterator<class_1263> {
        public ContainerItemIterator(int fromIndex) {
            this(CommonProxy::findContainer, fromIndex);
        }

        public ContainerItemIterator(Function<Accessor<?>, @Nullable class_1263> containerFinder, int fromIndex) {
            super(containerFinder, fromIndex);
        }

        @Override
        protected int getSlotCount(class_1263 container) {
            return container.method_5439();
        }

        @Override
        protected class_1799 getItemInSlot(class_1263 container, int slot) {
            return container.method_5438(slot);
        }
    }

    public static abstract class SlottedItemIterator<T>
    extends ItemIterator<T> {
        protected float progress;

        public SlottedItemIterator(Function<Accessor<?>, @Nullable T> containerFinder, int fromIndex) {
            super(containerFinder, fromIndex);
        }

        protected abstract int getSlotCount(T var1);

        protected abstract class_1799 getItemInSlot(T var1, int var2);

        @Override
        public Stream<class_1799> populate(T container, int amount) {
            int slotCount = this.getSlotCount(container);
            int toIndex = IntMath.saturatedAdd((int)this.currentIndex, (int)amount);
            if (toIndex >= slotCount) {
                toIndex = slotCount;
                this.finished = true;
                this.progress = 1.0f;
            } else {
                this.progress = (float)(this.currentIndex - this.fromIndex) / (float)(slotCount - this.fromIndex);
            }
            return IntStream.range(this.currentIndex, toIndex).mapToObj(slot -> this.getItemInSlot(container, slot));
        }

        @Override
        public float getCollectingProgress() {
            return this.progress;
        }
    }
}

