/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.util;

import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import net.minecraft.class_1887;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class EnchantmentCostHelper {
    public static float getEnchantmentCosts(class_9304 itemEnchantments, float scale) {
        float enchantmentCosts = 0.0f;
        for (Object2IntMap.Entry entry : itemEnchantments.method_57539()) {
            int enchantmentLevel = entry.getIntValue();
            if (((class_6880)entry.getKey()).method_40220(class_9636.field_51557)) {
                enchantmentLevel *= 2;
            }
            enchantmentCosts += Math.max((float)enchantmentLevel, (float)EnchantmentCostHelper.getEnchantmentCost((class_6880<class_1887>)((class_6880)entry.getKey()), enchantmentLevel) * scale);
        }
        return enchantmentCosts;
    }

    public static int getScalingEnchantmentCosts(Collection<class_6880<class_1887>> itemEnchantments, Collection<String> scalingNamespaces) {
        int scalingEnchantmentCosts = 0;
        for (class_6880<class_1887> enchantment : EnchantmentCostHelper.getMostExpensiveEnchantments(itemEnchantments)) {
            if (!scalingNamespaces.isEmpty() && !scalingNamespaces.contains(((class_5321)enchantment.method_40230().orElseThrow()).method_29177().method_12836())) continue;
            scalingEnchantmentCosts += EnchantmentCostHelper.getMaxEnchantmentCost(enchantment);
        }
        return scalingEnchantmentCosts;
    }

    private static Collection<class_6880<class_1887>> getMostExpensiveEnchantments(Collection<class_6880<class_1887>> itemEnchantments) {
        Object2IntOpenHashMap itemEnchantmentCosts = new Object2IntOpenHashMap();
        for (class_6880<class_1887> enchantment : itemEnchantments) {
            int newEnchantmentCost = EnchantmentCostHelper.getMaxEnchantmentCost(enchantment);
            class_6880<class_1887> incompatibleEnchantment = EnchantmentCostHelper.findIncompatibleEnchantment(enchantment, (Collection<class_6880<class_1887>>)itemEnchantmentCosts.keySet());
            if (incompatibleEnchantment != null) {
                int oldEnchantmentCost = itemEnchantmentCosts.removeInt(incompatibleEnchantment);
                if (newEnchantmentCost > oldEnchantmentCost) {
                    itemEnchantmentCosts.put(enchantment, newEnchantmentCost);
                    continue;
                }
                itemEnchantmentCosts.put(incompatibleEnchantment, oldEnchantmentCost);
                continue;
            }
            itemEnchantmentCosts.put(enchantment, newEnchantmentCost);
        }
        return itemEnchantmentCosts.keySet();
    }

    @Nullable
    private static class_6880<class_1887> findIncompatibleEnchantment(class_6880<class_1887> enchantment, Collection<class_6880<class_1887>> enchantments) {
        for (class_6880<class_1887> holder : enchantments) {
            if (class_1887.method_60033(enchantment, holder)) continue;
            return holder;
        }
        return null;
    }

    private static int getMaxEnchantmentCost(class_6880<class_1887> enchantment) {
        return EnchantmentCostHelper.getEnchantmentCost(enchantment, EnchantingBehavior.get().getMaxLevel(enchantment));
    }

    private static int getEnchantmentCost(class_6880<class_1887> enchantment, int enchantmentLevel) {
        return ((class_1887)enchantment.comp_349()).method_58446() * enchantmentLevel;
    }
}

