/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.util;

import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1887;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTooltipHelper {
    public static final String KEY_INCOMPATIBLE_ENCHANTMENTS = class_156.method_646((String)"gui", (class_2960)EnchantingInfuser.id("enchantment.tooltip.incompatible"));
    public static final class_2561 UNKNOWN_ENCHANT_COMPONENT = class_2561.method_43471((String)class_156.method_646((String)"gui", (class_2960)EnchantingInfuser.id("enchantment.tooltip.unknown_enchantment"))).method_27692(class_124.field_1080);
    public static final class_2561 INCREASE_LEVEL_COMPONENT = class_2561.method_43471((String)class_156.method_646((String)"gui", (class_2960)EnchantingInfuser.id("enchantment.tooltip.low_power1"))).method_27692(class_124.field_1080);
    public static final class_2561 MODIFY_LEVEL_COMPONENT = class_2561.method_43471((String)class_156.method_646((String)"gui", (class_2960)EnchantingInfuser.id("enchantment.tooltip.low_power2"))).method_27692(class_124.field_1080);
    public static final String KEY_CURRENT_ENCHANTING_POWER = class_156.method_646((String)"gui", (class_2960)EnchantingInfuser.id("enchantment.tooltip.current_enchanting_power"));

    public static List<class_2561> getWeakPowerTooltip(int currentPower, int requiredPower, class_2561 component) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_5250 currentPowerComponent = class_2561.method_43470((String)String.valueOf(currentPower)).method_27692(class_124.field_1061);
        class_5250 requiredPowerComponent = class_2561.method_43470((String)String.valueOf(requiredPower));
        lines.add((class_2561)class_2561.method_43469((String)KEY_CURRENT_ENCHANTING_POWER, (Object[])new Object[]{currentPowerComponent, requiredPowerComponent}));
        lines.add(component);
        return lines;
    }

    public static List<class_2561> getIncompatibleEnchantmentsTooltip(Collection<class_6880<class_1887>> incompatibleEnchantments) {
        class_5250 component = class_2561.method_43469((String)KEY_INCOMPATIBLE_ENCHANTMENTS, (Object[])new Object[]{incompatibleEnchantments.stream().map(EnchantmentTooltipHelper::getDisplayName).reduce((o1, o2) -> o1.method_27693(", ").method_10852((class_2561)o2)).orElse(class_2561.method_43473()).method_27692(class_124.field_1080)});
        return Collections.singletonList(component);
    }

    public static List<class_2561> getEnchantmentTooltip(class_6880<class_1887> enchantment) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add((class_2561)class_2561.method_43473().method_10852(((class_1887)enchantment.comp_349()).comp_2686()).method_10852(class_5244.field_41874).method_10852(EnchantmentTooltipHelper.getLevelComponent(enchantment)));
        String translationKey = EnchantmentTooltipHelper.getEnchantmentDescriptionKey(enchantment);
        if (translationKey != null) {
            lines.add((class_2561)class_2561.method_43471((String)translationKey).method_27692(class_124.field_1080));
        }
        return lines;
    }

    private static class_2561 getLevelComponent(class_6880<class_1887> enchantment) {
        int minLevel = ((class_1887)enchantment.comp_349()).method_8187();
        int maxLevel = EnchantingBehavior.get().getMaxLevel(enchantment);
        class_5250 component = class_2561.method_43471((String)("enchantment.level." + minLevel));
        if (minLevel != maxLevel) {
            component.method_27693("-").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + maxLevel)));
        }
        return EnchantmentTooltipHelper.wrapInRoundBrackets((class_2561)component).method_27692(class_124.field_1080);
    }

    static class_5250 wrapInRoundBrackets(class_2561 component) {
        return class_2561.method_43470((String)"(").method_10852(component).method_27693(")");
    }

    @Nullable
    private static String getEnchantmentDescriptionKey(class_6880<class_1887> enchantment) {
        String translationKey = enchantment.method_40230().map(resourceKey -> class_156.method_646((String)resourceKey.method_41185().method_12832(), (class_2960)resourceKey.method_29177())).orElse(null);
        if (translationKey == null) {
            return null;
        }
        if (class_2477.method_10517().method_4678(translationKey + ".desc")) {
            return translationKey + ".desc";
        }
        if (class_2477.method_10517().method_4678(translationKey + ".description")) {
            return translationKey + ".description";
        }
        return null;
    }

    public static class_5250 getDisplayName(class_6880<class_1887> enchantment) {
        return ((class_1887)enchantment.comp_349()).comp_2686().method_27661().method_10862(class_2583.field_24360);
    }

    public static class_5250 getDisplayNameWithLevel(class_6880<class_1887> enchantment, int level) {
        class_5250 component = EnchantmentTooltipHelper.getDisplayName(enchantment);
        if (level != 1 || EnchantingBehavior.get().getMaxLevel(enchantment) != 1) {
            return component.method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + level)));
        }
        return component;
    }
}

