/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.client.gui.components.AbstractMenuSelectionList;
import fuzs.enchantinginfuser.client.gui.components.EnchantingOperationButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserEnchantButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserMenuButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserRepairButton;
import fuzs.enchantinginfuser.client.gui.screens.inventory.EnchantmentComponent;
import fuzs.enchantinginfuser.client.util.EnchantmentTooltipHelper;
import fuzs.enchantinginfuser.network.client.ServerboundEnchantmentLevelMessage;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4265;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class InfuserScreen
extends class_465<InfuserMenu>
implements class_1712 {
    public static final class_2960 INFUSER_LOCATION = EnchantingInfuser.id("textures/gui/container/enchanting_infuser.png");
    private static final class_2960 SLOT_HIGHLIGHT_BACK_SPRITE = class_2960.method_60656((String)"container/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE = class_2960.method_60656((String)"container/slot_highlight_front");
    private static final int BUTTONS_OFFSET_X = 7;
    private static final int ENCHANT_BUTTON_OFFSET_Y = 44;
    private static final int ENCHANT_ONLY_BUTTON_OFFSET_Y = 55;
    private static final int REPAIR_BUTTON_OFFSET_Y = 66;
    private static boolean isPowerTooLow;
    public final int enchantmentSeed = new Random().nextInt();
    private class_342 searchBox;
    private EnchantmentSelectionList scrollingList;
    private boolean ignoreTextInput;
    private class_339 powerWidget;
    private InfuserMenuButton enchantButton;
    @Nullable
    private InfuserMenuButton repairButton;

    public InfuserScreen(InfuserMenu infuserMenu, class_1661 inventory, class_2561 title) {
        super((class_1703)infuserMenu, inventory, title);
        this.field_2792 = 220;
        this.field_2779 = 185;
        this.field_25269 = 30;
        this.field_25270 = this.field_2779 - 94;
        ((InfuserMenu)this.field_2797).method_7596(this);
    }

    public static void setIsPowerTooLow(boolean isPowerTooLow) {
        InfuserScreen.isPowerTooLow = isPowerTooLow;
    }

    protected void method_25426() {
        super.method_25426();
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 67, this.field_2800 + 6, 116, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(-1);
        this.method_25429((class_364)this.searchBox);
        this.scrollingList = new EnchantmentSelectionList(this.field_2776 + 30, this.field_2800 + 18);
        this.method_37063((class_364)this.scrollingList);
        this.powerWidget = (class_339)this.method_37060((class_4068)new class_339(this.field_2776 + 196, this.field_2800 + 161, 16, 16, class_5244.field_39003){

            protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                if (this.method_25367()) {
                    guiGraphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_BACK_SPRITE, this.method_46426() - 4, this.method_46427() - 4, 24, 24);
                }
                guiGraphics.method_51445(new class_1799((class_1935)class_1802.field_8536), this.method_46426(), this.method_46427());
                int posX = this.method_46426() + 19 - 2 - InfuserScreen.this.field_22793.method_27525((class_5348)this.method_25369());
                int posY = this.method_46427() + 6 + 3;
                guiGraphics.method_27535(InfuserScreen.this.field_22793, this.method_25369(), posX, posY, class_9848.method_61334((int)this.getStringColor().method_532()));
                if (this.method_25367()) {
                    guiGraphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_SPRITE, this.method_46426() - 4, this.method_46427() - 4, 24, 24);
                }
            }

            private class_124 getStringColor() {
                if (((InfuserMenu)InfuserScreen.this.field_2797).getEnchantmentPower() >= ((InfuserMenu)InfuserScreen.this.field_2797).getEnchantmentPowerLimit()) {
                    return class_124.field_1054;
                }
                if (isPowerTooLow) {
                    return class_124.field_1061;
                }
                return class_124.field_1068;
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return false;
            }

            protected void method_47399(class_6382 narrationElementOutput) {
            }
        });
        this.enchantButton = (InfuserMenuButton)this.method_37063((class_364)new InfuserEnchantButton(this.field_2776 + 7, this.field_2800 + (((InfuserMenu)this.field_2797).getConfig().allowRepairing.isActive() ? 44 : 55), button -> {
            if (((InfuserMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, 0)) {
                this.field_22787.field_1761.method_2900(((InfuserMenu)this.field_2797).field_7763, 0);
            }
            this.searchBox.method_1852("");
        }));
        this.repairButton = ((InfuserMenu)this.field_2797).getConfig().allowRepairing.isActive() ? (InfuserMenuButton)this.method_37063((class_364)new InfuserRepairButton(this.field_2776 + 7, this.field_2800 + 66, button -> {
            if (((InfuserMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, 1)) {
                this.field_22787.field_1761.method_2900(((InfuserMenu)this.field_2797).field_7763, 1);
            }
        })) : null;
        this.refreshButton(0);
        this.refreshButton(1);
        this.refreshButton(2);
    }

    private void refreshButton(int dataSlot) {
        switch (dataSlot) {
            case 0: {
                this.refreshEnchantingPower(((InfuserMenu)this.field_2797).getEnchantmentPower());
                break;
            }
            case 1: {
                this.refreshButton(this.enchantButton, ((InfuserMenu)this.field_2797).getEnchantingCost(), ((InfuserMenu)this.field_2797).canEnchant((class_1657)this.field_22787.field_1724));
                break;
            }
            case 2: {
                if (this.repairButton == null) break;
                this.refreshButton(this.repairButton, ((InfuserMenu)this.field_2797).getRepairCost(), ((InfuserMenu)this.field_2797).canRepair((class_1657)this.field_22787.field_1724));
            }
        }
    }

    private void refreshButton(InfuserMenuButton button, int value, boolean mayApply) {
        button.refreshMessage(value, mayApply);
        button.refreshTooltip(((InfuserMenu)this.field_2797).getEnchantableStack(), ((InfuserMenu)this.field_2797).getItemEnchantments(), value, mayApply);
        button.field_22763 = mayApply;
    }

    private void refreshEnchantingPower(int enchantmentPower) {
        this.powerWidget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(enchantmentPower)));
        int enchantmentPowerLimit = ((InfuserMenu)this.field_2797).getEnchantmentPowerLimit();
        TooltipBuilder builder = TooltipBuilder.create().splitLines(200).addLines(new class_5348[]{class_2561.method_43469((String)EnchantmentTooltipHelper.KEY_CURRENT_ENCHANTING_POWER, (Object[])new Object[]{enchantmentPower, enchantmentPowerLimit}).method_27692(class_124.field_1054)});
        if (enchantmentPower < enchantmentPowerLimit) {
            builder.addLines(new class_5348[]{class_2561.method_43471((String)InfuserMenuButton.KEY_TOOLTIP_HINT).method_27692(class_124.field_1080)});
        }
        builder.build(this.powerWidget);
    }

    public void method_25432() {
        super.method_25432();
        ((InfuserMenu)this.field_2797).method_7603(this);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String s = this.searchBox.method_1882();
        super.method_25410(minecraft, width, height);
        this.searchBox.method_1852(s);
        this.refreshSearchResults();
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.method_1882();
        if (this.searchBox.method_25400(codePoint, modifiers)) {
            if (!Objects.equals(s, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        if (!this.searchBox.method_25370()) {
            if (this.field_22787.field_1690.field_1890.method_1417(keyCode, scanCode)) {
                this.ignoreTextInput = true;
                this.searchBox.method_25365(true);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        boolean flag = this.field_2787 != null && this.field_2787.method_7681();
        boolean flag1 = class_3675.method_15985((int)keyCode, (int)scanCode).method_30103().isPresent();
        if (flag && flag1 && this.method_2384(keyCode, scanCode)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.method_1882();
        if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(s, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.method_25370() && this.searchBox.method_1885() && keyCode != 256 || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public void refreshSearchResults() {
        EnchantmentComponent enchantmentComponent;
        InfuserMenu.EnchantmentValues enchantmentValues;
        int size = this.scrollingList.method_25396().size();
        this.scrollingList.method_25339();
        class_9304 itemEnchantments = ((InfuserMenu)this.field_2797).getItemEnchantments();
        Set<class_6880<class_1887>> enchantments = ((InfuserMenu)this.field_2797).getAllEnchantments();
        class_5455.class_6890 registries = this.field_22787.method_1562().method_29091();
        class_6885.class_6888 holders = registries.method_46762(class_7924.field_41265).method_46735(class_9636.field_51362);
        for (class_6880<class_1887> enchantment : holders) {
            if (!enchantments.contains(enchantment) || !this.matchesSearch(enchantment)) continue;
            enchantmentValues = ((InfuserMenu)this.field_2797).getEnchantmentValues(enchantment);
            enchantmentComponent = EnchantmentComponent.create(enchantment, enchantmentValues, itemEnchantments);
            this.scrollingList.addEntry(enchantment, enchantmentComponent);
        }
        for (class_6880<class_1887> enchantment : enchantments) {
            if (holders.method_40241(enchantment) || !this.matchesSearch(enchantment)) continue;
            enchantmentValues = ((InfuserMenu)this.field_2797).getEnchantmentValues(enchantment);
            enchantmentComponent = EnchantmentComponent.create(enchantment, enchantmentValues, itemEnchantments);
            this.scrollingList.addEntry(enchantment, enchantmentComponent);
        }
        if (size != this.scrollingList.method_25396().size()) {
            this.scrollingList.method_44382(0.0);
        }
    }

    private boolean matchesSearch(class_6880<class_1887> enchantment) {
        String s = this.searchBox.method_1882().toLowerCase(Locale.ROOT).trim();
        if (s.isEmpty()) {
            return true;
        }
        if (((InfuserMenu)this.field_2797).getAvailableEnchantmentLevel(enchantment) == 0) {
            return false;
        }
        return ((class_1887)enchantment.comp_349()).comp_2686().getString().toLowerCase(Locale.ROOT).contains(s);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        isPowerTooLow = false;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.method_25290(class_10799.field_56883, INFUSER_LOCATION, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        this.searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25290(class_10799.field_56883, INFUSER_LOCATION, this.field_2776 + 8 - 1, this.field_2800 + (((InfuserMenu)this.field_2797).getConfig().allowRepairing.isActive() ? 23 : 34) - 1, 196.0f, 185.0f, 18, 18, 256, 256);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.method_19355(mouseX, mouseY).filter(listener -> listener.method_25401(mouseX, mouseY, scrollX, scrollY)).isPresent()) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike() && this.method_25399() != null && this.method_25397() && button == 0 && this.method_25399().method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void method_7635(class_1703 containerMenu, int dataSlotIndex, class_1799 itemStack) {
        if (dataSlotIndex == 0) {
            this.refreshButton(1);
            this.refreshButton(2);
        }
    }

    public void method_7633(class_1703 containerMenu, int dataSlotIndex, int value) {
        this.refreshButton(dataSlotIndex);
    }

    private class EnchantmentSelectionList
    extends AbstractMenuSelectionList<Entry> {
        public EnchantmentSelectionList(int x, int y) {
            super(InfuserScreen.this.field_22787, x, y, 160, 70, 18, 8);
        }

        public void addEntry(class_6880<class_1887> enchantment, EnchantmentComponent enchantmentComponent) {
            this.method_25321((class_350.class_351)new Entry(enchantment, enchantmentComponent));
        }

        public void method_25339() {
            super.method_25339();
        }

        class Entry
        extends class_4265.class_4266<Entry> {
            private final EnchantmentComponent enchantmentComponent;
            private final class_2561 component;
            private final List<class_5481> tooltip;
            private final class_339 removeButton;
            private final class_339 addButton;

            public Entry(class_6880<class_1887> enchantment, EnchantmentComponent enchantmentComponent) {
                this.enchantmentComponent = enchantmentComponent;
                this.component = enchantmentComponent.getDisplayName(enchantment, EnchantmentSelectionList.this.method_25368() - 36, ((EnchantmentSelectionList)EnchantmentSelectionList.this).field_22740.field_1772, InfuserScreen.this.enchantmentSeed);
                this.tooltip = ClientComponentSplitter.splitTooltipLines(enchantmentComponent.getTooltip(enchantment)).toList();
                this.removeButton = new EnchantingOperationButton.Remove(enchantmentComponent, EnchantmentSelectionList.this.method_46426(), EnchantmentSelectionList.this.method_46427(), button -> {
                    if (((InfuserMenu)InfuserScreen.this.method_17577()).clickClientEnchantmentLevelButton(enchantment, enchantmentComponent.enchantmentLevel(), ServerboundEnchantmentLevelMessage.Operation.remove())) {
                        InfuserScreen.this.refreshSearchResults();
                    }
                });
                this.addButton = new EnchantingOperationButton.Add(enchantmentComponent, EnchantmentSelectionList.this.method_46426() + EnchantmentSelectionList.this.method_25368() - 18, EnchantmentSelectionList.this.method_46427(), button -> {
                    if (((InfuserMenu)InfuserScreen.this.method_17577()).clickClientEnchantmentLevelButton(enchantment, enchantmentComponent.enchantmentLevel(), ServerboundEnchantmentLevelMessage.Operation.add())) {
                        InfuserScreen.this.refreshSearchResults();
                    }
                });
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                guiGraphics.method_25290(class_10799.field_56883, INFUSER_LOCATION, left, top, 0.0f, (float)(185 + this.getYImage() * EnchantmentSelectionList.this.field_22741), width, height, 256, 256);
                class_339.method_52718((class_332)guiGraphics, (class_327)((EnchantmentSelectionList)EnchantmentSelectionList.this).field_22740.field_1772, (class_2561)this.component, (int)(left + 18 + 2), (int)top, (int)(left + width - 18 - 2), (int)(top + height), (int)class_9848.method_61334((int)this.getFontColor()));
                for (class_339 class_3392 : this.method_25396()) {
                    class_3392.method_46419(top);
                    class_3392.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
                if (hovering && (this.enchantmentComponent.isInactive() || mouseX >= left + 18 && mouseX < left + width - 18)) {
                    guiGraphics.method_71274(this.tooltip, mouseX, mouseY);
                    if (this.enchantmentComponent.isNotAvailable()) {
                        InfuserScreen.setIsPowerTooLow(true);
                    }
                }
            }

            private int getYImage() {
                return this.enchantmentComponent.isInactive() ? 0 : (this.enchantmentComponent.isPresent() ? 2 : 1);
            }

            private int getFontColor() {
                return this.enchantmentComponent.isInactive() ? 6839882 : (this.enchantmentComponent.isPresent() ? class_124.field_1054.method_532() : -1);
            }

            public List<? extends class_339> method_25396() {
                return List.of(this.removeButton, this.addButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.removeButton, this.addButton);
            }
        }
    }
}

