/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.components;

import fuzs.enchantinginfuser.client.gui.screens.inventory.EnchantmentComponent;
import fuzs.enchantinginfuser.client.gui.screens.inventory.InfuserScreen;
import fuzs.enchantinginfuser.client.util.EnchantmentTooltipHelper;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public abstract class EnchantingOperationButton
extends SpritelessImageButton {
    private final boolean isPowerTooLow;

    public EnchantingOperationButton(EnchantmentComponent enchantmentComponent, int x, int y, int xTexOffset, class_4185.class_4241 onPress) {
        super(x, y, 18, 18, 220 + xTexOffset, 0, InfuserScreen.INFUSER_LOCATION, onPress);
        this.field_22764 = !enchantmentComponent.isNotAvailable() && this.getVisibleValue(enchantmentComponent);
        this.field_22763 = this.getActiveValue(enchantmentComponent);
        class_2561 component = this.getTooltipComponent(enchantmentComponent);
        boolean bl = this.isPowerTooLow = component != null;
        if (this.isPowerTooLow) {
            TooltipBuilder.create(enchantmentComponent.getWeakPowerTooltip(component)).splitLines().build((class_339)this);
        }
        this.setTextureLayout(LEGACY_TEXTURE_LAYOUT);
    }

    protected abstract boolean getVisibleValue(EnchantmentComponent var1);

    protected abstract boolean getActiveValue(EnchantmentComponent var1);

    @Nullable
    protected abstract class_2561 getTooltipComponent(EnchantmentComponent var1);

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.method_37303() && class_437.method_25442()) {
            int yImage = this.method_25367() ? 2 : 1;
            guiGraphics.method_25291(class_10799.field_56883, this.resourceLocation, this.method_46426() + 3, this.method_46427(), (float)this.xTexStart, (float)(this.yTexStart + yImage * this.yDiffTex), this.field_22758, this.field_22759, this.textureWidth, this.textureHeight, class_9848.method_61317((float)this.field_22765));
            guiGraphics.method_25291(class_10799.field_56883, this.resourceLocation, this.method_46426() - 3, this.method_46427(), (float)this.xTexStart, (float)(this.yTexStart + yImage * this.yDiffTex), this.field_22758, this.field_22759, this.textureWidth, this.textureHeight, class_9848.method_61317((float)this.field_22765));
        } else {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.isPowerTooLow && this.method_25367()) {
            InfuserScreen.setIsPowerTooLow(true);
        }
    }

    public static class Remove
    extends EnchantingOperationButton {
        public Remove(EnchantmentComponent enchantmentComponent, int x, int y, class_4185.class_4241 onPress) {
            super(enchantmentComponent, x, y, 0, onPress);
        }

        @Override
        protected boolean getVisibleValue(EnchantmentComponent enchantmentComponent) {
            return enchantmentComponent.isPresent();
        }

        @Override
        protected boolean getActiveValue(EnchantmentComponent enchantmentComponent) {
            return !enchantmentComponent.isIncompatible() && enchantmentComponent.enchantmentLevel() - 1 < enchantmentComponent.enchantmentValues().availableLevel();
        }

        @Override
        @Nullable
        protected class_2561 getTooltipComponent(EnchantmentComponent enchantmentComponent) {
            if (enchantmentComponent.enchantmentLevel() - 1 >= enchantmentComponent.enchantmentValues().availableLevel() && !enchantmentComponent.isNotAvailable()) {
                return EnchantmentTooltipHelper.MODIFY_LEVEL_COMPONENT;
            }
            return null;
        }
    }

    public static class Add
    extends EnchantingOperationButton {
        public Add(EnchantmentComponent enchantmentComponent, int x, int y, class_4185.class_4241 onPress) {
            super(enchantmentComponent, x, y, 18, onPress);
        }

        @Override
        protected boolean getVisibleValue(EnchantmentComponent enchantmentComponent) {
            return enchantmentComponent.enchantmentLevel() < enchantmentComponent.enchantmentValues().maxLevel();
        }

        @Override
        protected boolean getActiveValue(EnchantmentComponent enchantmentComponent) {
            return !enchantmentComponent.isIncompatible() && enchantmentComponent.enchantmentLevel() < enchantmentComponent.enchantmentValues().availableLevel();
        }

        @Override
        @Nullable
        protected class_2561 getTooltipComponent(EnchantmentComponent enchantmentComponent) {
            if (enchantmentComponent.enchantmentLevel() >= enchantmentComponent.enchantmentValues().availableLevel() && !enchantmentComponent.isNotAvailable()) {
                return EnchantmentTooltipHelper.INCREASE_LEVEL_COMPONENT;
            }
            return null;
        }
    }
}

