/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.transition.sentry;

import dev.tr7zw.lib.sentry.Sentry;
import dev.tr7zw.lib.sentry.SentryLevel;
import dev.tr7zw.lib.sentry.protocol.SentryId;
import dev.tr7zw.transition.sentry.SentryDataProvider;
import dev.tr7zw.transition.sentry.SentryLogFilter;
import dev.tr7zw.transition.sentry.SentryTagResolver;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class SentryInstance {
    private static final SentryInstance INSTANCE = new SentryInstance();
    public static final Logger logger = LogManager.getLogger();
    private SentryDataProvider dataProvider;
    private Set<String> seenMessages = new HashSet<String>();
    private boolean filterLoaded = false;

    public static void initialize(SentryDataProvider dataProvider) {
        INSTANCE.init(dataProvider);
    }

    private void init(SentryDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        if (dataProvider == null || !dataProvider.userConsentedToCrashReports()) {
            return;
        }
        this.registerSentryFilter();
        Sentry.init(options -> {
            options.setDsn("https://edfbf3e57316f04a7e5d43ba16f097cb@o4510312664596480.ingest.de.sentry.io/4510312670036048");
            options.setRelease("transition@" + SentryInstance.INSTANCE.dataProvider.getModVersion());
            options.setTag("minecraft_version", SentryInstance.INSTANCE.dataProvider.getMinecraftVersion());
            options.setTag("loader", SentryInstance.INSTANCE.dataProvider.getModloader());
            options.setEnvironment("production");
            options.setSendDefaultPii(false);
            options.setBeforeSend((event, hint) -> {
                if (event.getThrowable() != null && event.isCrashed()) {
                    boolean relatedToMod = false;
                    for (Throwable t = event.getThrowable(); t != null && !relatedToMod; t = t.getCause()) {
                        relatedToMod = Arrays.stream(t.getStackTrace()).anyMatch(e -> e.getClassName().startsWith("dev.tr7zw"));
                    }
                    if (!relatedToMod) {
                        return null;
                    }
                }
                return event;
            });
        });
        logger.info("Setup Sentry for error reporting");
    }

    private void registerSentryFilter() {
        if (this.filterLoaded) {
            return;
        }
        this.filterLoaded = true;
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        SentryLogFilter filter = new SentryLogFilter();
        LoggerConfig rootLoggerConfig = config.getRootLogger();
        rootLoggerConfig.addFilter((Filter)filter);
        context.updateLoggers();
    }

    public static boolean maybeReport(String loggerName, String thread, String message, Throwable throwable) {
        if (SentryInstance.INSTANCE.dataProvider == null || !SentryInstance.INSTANCE.dataProvider.userConsentedToCrashReports()) {
            return false;
        }
        boolean relatedToMod = false;
        for (Throwable t = throwable; t != null && !relatedToMod; t = t.getCause()) {
            relatedToMod = Arrays.stream(t.getStackTrace()).anyMatch(e -> e.getClassName().startsWith("dev.tr7zw"));
        }
        if (!relatedToMod) {
            return false;
        }
        if (SentryInstance.INSTANCE.seenMessages.contains(throwable.getMessage())) {
            return false;
        }
        SentryInstance.INSTANCE.seenMessages.add(throwable.getMessage());
        Sentry.configureScope(scope -> {
            scope.setContexts("loaded_mods", SentryInstance.INSTANCE.dataProvider.getLoadedMods());
            scope.setContexts("Message", message);
            scope.setTag("suspectMod", SentryTagResolver.findSuspectMod(throwable));
            scope.setTag("Logger", loggerName);
            scope.setTag("Thread", thread);
            scope.setTag("hasPlayer", Boolean.toString(SentryInstance.INSTANCE.dataProvider.hasPlayer()));
            scope.setTag("LevelType", SentryInstance.INSTANCE.dataProvider.getLevelType());
            scope.setTag("Screen", SentryInstance.INSTANCE.dataProvider.getScreen());
            scope.setLevel("CrashReport".equals(loggerName) ? SentryLevel.FATAL : SentryLevel.ERROR);
        });
        SentryId id = Sentry.captureException(throwable);
        logger.info("Logged to Sentry {}", (Object)id);
        return true;
    }

    public static void forceFlush() {
        if (SentryInstance.INSTANCE.dataProvider == null || !SentryInstance.INSTANCE.dataProvider.userConsentedToCrashReports()) {
            return;
        }
        logger.info("Waiting for Sentry to flush...");
        Sentry.flush(3000L);
    }
}

