/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.lib.sentry;

import dev.tr7zw.lib.sentry.Breadcrumb;
import dev.tr7zw.lib.sentry.ISerializer;
import dev.tr7zw.lib.sentry.JsonDeserializer;
import dev.tr7zw.lib.sentry.JsonObjectReader;
import dev.tr7zw.lib.sentry.JsonObjectWriter;
import dev.tr7zw.lib.sentry.ProfileChunk;
import dev.tr7zw.lib.sentry.ProfileContext;
import dev.tr7zw.lib.sentry.ProfilingTraceData;
import dev.tr7zw.lib.sentry.ProfilingTransactionData;
import dev.tr7zw.lib.sentry.ReplayRecording;
import dev.tr7zw.lib.sentry.SentryAppStartProfilingOptions;
import dev.tr7zw.lib.sentry.SentryEnvelope;
import dev.tr7zw.lib.sentry.SentryEnvelopeHeader;
import dev.tr7zw.lib.sentry.SentryEnvelopeItem;
import dev.tr7zw.lib.sentry.SentryEnvelopeItemHeader;
import dev.tr7zw.lib.sentry.SentryEvent;
import dev.tr7zw.lib.sentry.SentryItemType;
import dev.tr7zw.lib.sentry.SentryLevel;
import dev.tr7zw.lib.sentry.SentryLockReason;
import dev.tr7zw.lib.sentry.SentryLogEvents;
import dev.tr7zw.lib.sentry.SentryOptions;
import dev.tr7zw.lib.sentry.SentryReplayEvent;
import dev.tr7zw.lib.sentry.Session;
import dev.tr7zw.lib.sentry.SpanContext;
import dev.tr7zw.lib.sentry.SpanId;
import dev.tr7zw.lib.sentry.SpanStatus;
import dev.tr7zw.lib.sentry.UserFeedback;
import dev.tr7zw.lib.sentry.clientreport.ClientReport;
import dev.tr7zw.lib.sentry.profilemeasurements.ProfileMeasurement;
import dev.tr7zw.lib.sentry.profilemeasurements.ProfileMeasurementValue;
import dev.tr7zw.lib.sentry.protocol.App;
import dev.tr7zw.lib.sentry.protocol.Browser;
import dev.tr7zw.lib.sentry.protocol.Contexts;
import dev.tr7zw.lib.sentry.protocol.DebugImage;
import dev.tr7zw.lib.sentry.protocol.DebugMeta;
import dev.tr7zw.lib.sentry.protocol.Device;
import dev.tr7zw.lib.sentry.protocol.Feedback;
import dev.tr7zw.lib.sentry.protocol.Geo;
import dev.tr7zw.lib.sentry.protocol.Gpu;
import dev.tr7zw.lib.sentry.protocol.MeasurementValue;
import dev.tr7zw.lib.sentry.protocol.Mechanism;
import dev.tr7zw.lib.sentry.protocol.Message;
import dev.tr7zw.lib.sentry.protocol.OperatingSystem;
import dev.tr7zw.lib.sentry.protocol.Request;
import dev.tr7zw.lib.sentry.protocol.SdkInfo;
import dev.tr7zw.lib.sentry.protocol.SdkVersion;
import dev.tr7zw.lib.sentry.protocol.SentryException;
import dev.tr7zw.lib.sentry.protocol.SentryPackage;
import dev.tr7zw.lib.sentry.protocol.SentryRuntime;
import dev.tr7zw.lib.sentry.protocol.SentrySpan;
import dev.tr7zw.lib.sentry.protocol.SentryStackFrame;
import dev.tr7zw.lib.sentry.protocol.SentryStackTrace;
import dev.tr7zw.lib.sentry.protocol.SentryThread;
import dev.tr7zw.lib.sentry.protocol.SentryTransaction;
import dev.tr7zw.lib.sentry.protocol.User;
import dev.tr7zw.lib.sentry.protocol.ViewHierarchy;
import dev.tr7zw.lib.sentry.protocol.ViewHierarchyNode;
import dev.tr7zw.lib.sentry.rrweb.RRWebBreadcrumbEvent;
import dev.tr7zw.lib.sentry.rrweb.RRWebEventType;
import dev.tr7zw.lib.sentry.rrweb.RRWebInteractionEvent;
import dev.tr7zw.lib.sentry.rrweb.RRWebInteractionMoveEvent;
import dev.tr7zw.lib.sentry.rrweb.RRWebMetaEvent;
import dev.tr7zw.lib.sentry.rrweb.RRWebSpanEvent;
import dev.tr7zw.lib.sentry.rrweb.RRWebVideoEvent;
import dev.tr7zw.lib.sentry.util.Objects;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSerializer
implements ISerializer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Map<Class<?>, JsonDeserializer<?>> deserializersByClass;

    public JsonSerializer(@NotNull SentryOptions options) {
        this.options = options;
        this.deserializersByClass = new HashMap();
        this.deserializersByClass.put(App.class, new App.Deserializer());
        this.deserializersByClass.put(Breadcrumb.class, new Breadcrumb.Deserializer());
        this.deserializersByClass.put(Browser.class, new Browser.Deserializer());
        this.deserializersByClass.put(Contexts.class, new Contexts.Deserializer());
        this.deserializersByClass.put(DebugImage.class, new DebugImage.Deserializer());
        this.deserializersByClass.put(DebugMeta.class, new DebugMeta.Deserializer());
        this.deserializersByClass.put(Device.class, new Device.Deserializer());
        this.deserializersByClass.put(Device.DeviceOrientation.class, new Device.DeviceOrientation.Deserializer());
        this.deserializersByClass.put(Feedback.class, new Feedback.Deserializer());
        this.deserializersByClass.put(Gpu.class, new Gpu.Deserializer());
        this.deserializersByClass.put(MeasurementValue.class, new MeasurementValue.Deserializer());
        this.deserializersByClass.put(Mechanism.class, new Mechanism.Deserializer());
        this.deserializersByClass.put(Message.class, new Message.Deserializer());
        this.deserializersByClass.put(OperatingSystem.class, new OperatingSystem.Deserializer());
        this.deserializersByClass.put(ProfileChunk.class, new ProfileChunk.Deserializer());
        this.deserializersByClass.put(ProfileContext.class, new ProfileContext.Deserializer());
        this.deserializersByClass.put(ProfilingTraceData.class, new ProfilingTraceData.Deserializer());
        this.deserializersByClass.put(ProfilingTransactionData.class, new ProfilingTransactionData.Deserializer());
        this.deserializersByClass.put(ProfileMeasurement.class, new ProfileMeasurement.Deserializer());
        this.deserializersByClass.put(ProfileMeasurementValue.class, new ProfileMeasurementValue.Deserializer());
        this.deserializersByClass.put(Request.class, new Request.Deserializer());
        this.deserializersByClass.put(ReplayRecording.class, new ReplayRecording.Deserializer());
        this.deserializersByClass.put(RRWebBreadcrumbEvent.class, new RRWebBreadcrumbEvent.Deserializer());
        this.deserializersByClass.put(RRWebEventType.class, new RRWebEventType.Deserializer());
        this.deserializersByClass.put(RRWebInteractionEvent.class, new RRWebInteractionEvent.Deserializer());
        this.deserializersByClass.put(RRWebInteractionMoveEvent.class, new RRWebInteractionMoveEvent.Deserializer());
        this.deserializersByClass.put(RRWebMetaEvent.class, new RRWebMetaEvent.Deserializer());
        this.deserializersByClass.put(RRWebSpanEvent.class, new RRWebSpanEvent.Deserializer());
        this.deserializersByClass.put(RRWebVideoEvent.class, new RRWebVideoEvent.Deserializer());
        this.deserializersByClass.put(SdkInfo.class, new SdkInfo.Deserializer());
        this.deserializersByClass.put(SdkVersion.class, new SdkVersion.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeHeader.class, new SentryEnvelopeHeader.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeItemHeader.class, new SentryEnvelopeItemHeader.Deserializer());
        this.deserializersByClass.put(SentryEvent.class, new SentryEvent.Deserializer());
        this.deserializersByClass.put(SentryException.class, new SentryException.Deserializer());
        this.deserializersByClass.put(SentryItemType.class, new SentryItemType.Deserializer());
        this.deserializersByClass.put(SentryLevel.class, new SentryLevel.Deserializer());
        this.deserializersByClass.put(SentryLockReason.class, new SentryLockReason.Deserializer());
        this.deserializersByClass.put(SentryLogEvents.class, new SentryLogEvents.Deserializer());
        this.deserializersByClass.put(SentryPackage.class, new SentryPackage.Deserializer());
        this.deserializersByClass.put(SentryRuntime.class, new SentryRuntime.Deserializer());
        this.deserializersByClass.put(SentryReplayEvent.class, new SentryReplayEvent.Deserializer());
        this.deserializersByClass.put(SentrySpan.class, new SentrySpan.Deserializer());
        this.deserializersByClass.put(SentryStackFrame.class, new SentryStackFrame.Deserializer());
        this.deserializersByClass.put(SentryStackTrace.class, new SentryStackTrace.Deserializer());
        this.deserializersByClass.put(SentryAppStartProfilingOptions.class, new SentryAppStartProfilingOptions.Deserializer());
        this.deserializersByClass.put(SentryThread.class, new SentryThread.Deserializer());
        this.deserializersByClass.put(SentryTransaction.class, new SentryTransaction.Deserializer());
        this.deserializersByClass.put(Session.class, new Session.Deserializer());
        this.deserializersByClass.put(SpanContext.class, new SpanContext.Deserializer());
        this.deserializersByClass.put(SpanId.class, new SpanId.Deserializer());
        this.deserializersByClass.put(SpanStatus.class, new SpanStatus.Deserializer());
        this.deserializersByClass.put(User.class, new User.Deserializer());
        this.deserializersByClass.put(Geo.class, new Geo.Deserializer());
        this.deserializersByClass.put(UserFeedback.class, new UserFeedback.Deserializer());
        this.deserializersByClass.put(ClientReport.class, new ClientReport.Deserializer());
        this.deserializersByClass.put(ViewHierarchyNode.class, new ViewHierarchyNode.Deserializer());
        this.deserializersByClass.put(ViewHierarchy.class, new ViewHierarchy.Deserializer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T, R> T deserializeCollection(@NotNull Reader reader, @NotNull Class<T> clazz, @Nullable JsonDeserializer<R> elementDeserializer) {
        try (JsonObjectReader jsonObjectReader = new JsonObjectReader(reader);){
            if (Collection.class.isAssignableFrom(clazz)) {
                if (elementDeserializer == null) {
                    Object object = jsonObjectReader.nextObjectOrNull();
                    return (T)object;
                }
                List<R> list = jsonObjectReader.nextListOrNull(this.options.getLogger(), elementDeserializer);
                return (T)list;
            }
            Object object = jsonObjectReader.nextObjectOrNull();
            return (T)object;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T deserialize(@NotNull Reader reader, @NotNull Class<T> clazz) {
        try (JsonObjectReader jsonObjectReader = new JsonObjectReader(reader);){
            JsonDeserializer<?> deserializer = this.deserializersByClass.get(clazz);
            if (deserializer != null) {
                Object object = deserializer.deserialize(jsonObjectReader, this.options.getLogger());
                T t = clazz.cast(object);
                return t;
            }
            if (this.isKnownPrimitive(clazz)) {
                Object object = jsonObjectReader.nextObjectOrNull();
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing", e);
            return null;
        }
    }

    @Override
    @Nullable
    public SentryEnvelope deserializeEnvelope(@NotNull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream object is required.");
        try {
            return this.options.getEnvelopeReader().read(inputStream);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error deserializing envelope.", e);
            return null;
        }
    }

    @Override
    public <T> void serialize(@NotNull T entity, @NotNull Writer writer) throws IOException {
        Objects.requireNonNull(entity, "The entity is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        if (this.options.getLogger().isEnabled(SentryLevel.DEBUG)) {
            String serialized = this.serializeToString(entity, this.options.isEnablePrettySerializationOutput());
            this.options.getLogger().log(SentryLevel.DEBUG, "Serializing object: %s", serialized);
        }
        JsonObjectWriter jsonObjectWriter = new JsonObjectWriter(writer, this.options.getMaxDepth());
        jsonObjectWriter.value(this.options.getLogger(), entity);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(@NotNull SentryEnvelope envelope, @NotNull OutputStream outputStream) throws Exception {
        Objects.requireNonNull(envelope, "The SentryEnvelope object is required.");
        Objects.requireNonNull(outputStream, "The Stream object is required.");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, UTF_8));
        try {
            envelope.getHeader().serialize(new JsonObjectWriter(writer, this.options.getMaxDepth()), this.options.getLogger());
            writer.write("\n");
            for (SentryEnvelopeItem item : envelope.getItems()) {
                try {
                    byte[] data = item.getData();
                    item.getHeader().serialize(new JsonObjectWriter(writer, this.options.getMaxDepth()), this.options.getLogger());
                    writer.write("\n");
                    ((Writer)writer).flush();
                    outputStream.write(data);
                    writer.write("\n");
                }
                catch (Exception exception) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to create envelope item. Dropping it.", exception);
                }
            }
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    @Override
    @NotNull
    public String serialize(@NotNull Map<String, Object> data) throws Exception {
        return this.serializeToString(data, false);
    }

    @NotNull
    private String serializeToString(Object object, boolean pretty) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonObjectWriter jsonObjectWriter = new JsonObjectWriter(stringWriter, this.options.getMaxDepth());
        if (pretty) {
            jsonObjectWriter.setIndent("\t");
        }
        jsonObjectWriter.value(this.options.getLogger(), object);
        return stringWriter.toString();
    }

    private <T> boolean isKnownPrimitive(@NotNull Class<T> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }
}

