/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries.datamaps;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import org.jetbrains.annotations.Nullable;

public sealed class DataMapType<R, T>
permits AdvancedDataMapType {
    private final class_5321<class_2378<R>> registryKey;
    private final class_2960 id;
    private final Codec<T> codec;
    @Nullable
    private final Codec<T> networkCodec;
    private final boolean mandatorySync;

    DataMapType(class_5321<class_2378<R>> registryKey, class_2960 id, Codec<T> codec, @Nullable Codec<T> networkCodec, boolean mandatorySync) {
        Preconditions.checkArgument((networkCodec != null || !mandatorySync ? 1 : 0) != 0, (Object)"Mandatory sync cannot be enabled when the attachment isn't synchronized");
        this.registryKey = Objects.requireNonNull(registryKey, "registryKey must not be null");
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.codec = Objects.requireNonNull(codec, "codec must not be null");
        this.networkCodec = networkCodec;
        this.mandatorySync = mandatorySync;
    }

    public static <T, R> Builder<T, R> builder(class_2960 id, class_5321<class_2378<R>> registry, Codec<T> codec) {
        return new Builder<T, R>(registry, id, codec);
    }

    public class_5321<class_2378<R>> registryKey() {
        return this.registryKey;
    }

    public class_2960 id() {
        return this.id;
    }

    public Codec<T> codec() {
        return this.codec;
    }

    @Nullable
    public Codec<T> networkCodec() {
        return this.networkCodec;
    }

    public boolean mandatorySync() {
        return this.mandatorySync;
    }

    public static sealed class Builder<T, R>
    permits AdvancedDataMapType.Builder {
        protected final class_5321<class_2378<R>> registryKey;
        protected final class_2960 id;
        protected final Codec<T> codec;
        @Nullable
        protected Codec<T> networkCodec;
        protected boolean mandatorySync;

        Builder(class_5321<class_2378<R>> registryKey, class_2960 id, Codec<T> codec) {
            this.registryKey = registryKey;
            this.id = id;
            this.codec = codec;
        }

        public Builder<T, R> synced(Codec<T> networkCodec, boolean mandatory) {
            this.mandatorySync = mandatory;
            this.networkCodec = networkCodec;
            return this;
        }

        public DataMapType<R, T> build() {
            return new DataMapType<R, T>(this.registryKey, this.id, this.codec, this.networkCodec, this.mandatorySync);
        }
    }
}

