/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fuzs.neoforgedatapackextensions.fabric.api.v1.DataMapsUpdatedCallback;
import fuzs.neoforgedatapackextensions.fabric.impl.registries.datamaps.IRegistryWithData;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_10209;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapEntry;
import net.neoforged.neoforge.registries.datamaps.DataMapFile;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapValueMerger;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;
import org.slf4j.Logger;

public class DataMapLoader
implements class_3302 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String PATH = "data_maps";
    private Map<class_5321<? extends class_2378<?>>, LoadResult<?>> results;
    private final class_5455 registryAccess;

    public DataMapLoader(class_5455 registryAccess) {
        this.registryAccess = registryAccess;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)this.load(resourceManager, backgroundExecutor, class_10209.method_64146()).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(values -> {
            this.results = values;
        }, gameExecutor);
    }

    public void apply() {
        this.results.forEach((key, result) -> this.apply((class_2370)((class_2370)this.registryAccess.method_30530(key)), (LoadResult)result));
        this.results = null;
    }

    private <T> void apply(class_2370<T> registry, LoadResult<T> result) {
        ((IRegistryWithData)registry).neoforgedatapackextensions$getDataMaps().clear();
        result.results().forEach((key, entries) -> ((IRegistryWithData)registry).neoforgedatapackextensions$getDataMaps().put(key, this.buildDataMap((class_2378)registry, (DataMapType)key, (List)entries)));
        ((DataMapsUpdatedCallback)DataMapsUpdatedCallback.EVENT.invoker()).onDataMapsUpdated((class_7225.class_7874)this.registryAccess, (class_2378<?>)registry, DataMapsUpdatedCallback.UpdateCause.SERVER_RELOAD);
    }

    private <T, R> Map<class_5321<R>, T> buildDataMap(class_2378<R> registry, DataMapType<R, T> attachment, List<DataMapFile<T, R>> entries) {
        DataMapValueMerger dataMapValueMerger;
        record WithSource<T, R>(T attachment, Either<class_6862<R>, class_5321<R>> source) {
        }
        IdentityHashMap<class_5321, WithSource> result = new IdentityHashMap<class_5321, WithSource>();
        if (attachment instanceof AdvancedDataMapType) {
            AdvancedDataMapType adv = (AdvancedDataMapType)attachment;
            dataMapValueMerger = adv.merger();
        } else {
            dataMapValueMerger = DataMapValueMerger.defaultMerger();
        }
        DataMapValueMerger merger = dataMapValueMerger;
        entries.forEach(entry -> {
            if (entry.replace()) {
                result.clear();
            }
            entry.values().forEach((tKey, value) -> {
                if (value.isEmpty()) {
                    return;
                }
                this.resolve(registry, (Either)tKey, true, holder -> {
                    DataMapEntry newValue = (DataMapEntry)value.get();
                    class_5321 key = holder.method_40230().orElse(null);
                    WithSource oldValue = (WithSource)result.get(key);
                    if (oldValue == null || newValue.replace()) {
                        result.put(key, new WithSource(newValue.value(), tKey));
                    } else {
                        result.put(key, new WithSource(merger.merge(registry, oldValue.source(), oldValue.attachment(), tKey, newValue.value()), tKey));
                    }
                });
            });
            for (DataMapEntry.Removal removal : entry.removals()) {
                if (removal.remover().isPresent()) {
                    DataMapValueRemover remover = removal.remover().orElseThrow();
                    this.resolve(registry, removal.key(), false, holder -> {
                        class_5321 key = holder.method_40230().orElse(null);
                        WithSource oldValue = (WithSource)result.get(key);
                        if (oldValue != null) {
                            Optional newValue = remover.remove(oldValue.attachment(), registry, oldValue.source(), holder.comp_349());
                            if (newValue.isEmpty()) {
                                result.remove(key);
                            } else {
                                result.put(key, new WithSource(newValue.get(), oldValue.source()));
                            }
                        }
                    });
                    continue;
                }
                this.resolve(registry, removal.key(), false, holder -> result.remove(holder.method_40230().orElse(null)));
            }
        });
        IdentityHashMap newMap = new IdentityHashMap();
        result.forEach((key, val) -> newMap.put(key, val.attachment()));
        return newMap;
    }

    private <R> void resolve(class_2378<R> registry, Either<class_6862<R>, class_5321<R>> value, boolean required, Consumer<class_6880<R>> consumer) {
        if (value.left().isPresent()) {
            registry.method_40286((class_6862)value.left().orElseThrow()).forEach(consumer);
        } else {
            Optional object = registry.method_46746((class_5321)value.right().orElseThrow());
            if (object.isPresent()) {
                consumer.accept((class_6880)object.get());
            } else if (required) {
                LOGGER.error("Object with ID {} specified in data map for registry {} doesn't exist", (Object)((class_5321)value.right().orElseThrow()).method_29177(), (Object)registry.method_46765().method_29177());
            }
        }
    }

    private CompletableFuture<Map<class_5321<? extends class_2378<?>>, LoadResult<?>>> load(class_3300 manager, Executor executor, class_3695 profiler) {
        return CompletableFuture.supplyAsync(() -> DataMapLoader.load(manager, profiler, this.registryAccess), executor);
    }

    private static Map<class_5321<? extends class_2378<?>>, LoadResult<?>> load(class_3300 manager, class_3695 profiler, class_5455 access) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)access);
        HashMap values = new HashMap();
        access.method_40311().forEach(registryEntry -> {
            class_5321 registryKey = registryEntry.comp_350();
            profiler.method_15396("registry_data_maps/" + String.valueOf(registryKey.method_29177()) + "/locating");
            class_7654 fileToId = class_7654.method_45114((String)("data_maps/" + DataMapLoader.getFolderLocation(registryKey.method_29177())));
            for (Map.Entry entry : fileToId.method_45116(manager).entrySet()) {
                class_2960 key = (class_2960)entry.getKey();
                class_2960 attachmentId = fileToId.method_45115(key);
                DataMapType attachment = RegistryManager.getDataMap(registryKey, attachmentId);
                if (attachment == null) {
                    LOGGER.warn("Found data map file for non-existent data map type '{}' on registry '{}'.", (Object)attachmentId, (Object)registryKey.method_29177());
                    continue;
                }
                profiler.method_15405("registry_data_maps/" + String.valueOf(registryKey.method_29177()) + "/" + String.valueOf(attachmentId) + "/loading");
                values.computeIfAbsent(registryKey, (Function<class_5321, LoadResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$load$10(net.minecraft.class_5321 ), (Lnet/minecraft/class_5321;)Lnet/neoforged/neoforge/registries/DataMapLoader$LoadResult;)()).results.put(attachment, DataMapLoader.readData((class_6903<JsonElement>)ops, attachment, registryKey, (List)entry.getValue()));
            }
            profiler.method_15407();
        });
        return values;
    }

    public static String getFolderLocation(class_2960 registryId) {
        return (String)(registryId.method_12836().equals("minecraft") ? "" : registryId.method_12836() + "/") + registryId.method_12832();
    }

    private static <A, T> List<DataMapFile<A, T>> readData(class_6903<JsonElement> ops, DataMapType<T, A> attachmentType, class_5321<class_2378<T>> registryKey, List<class_3298> resources) {
        Codec<DataMapFile<A, T>> codec = DataMapFile.codec(registryKey, attachmentType);
        LinkedList<DataMapFile<A, T>> entries = new LinkedList<DataMapFile<A, T>>();
        for (class_3298 resource : resources) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                    entries.add((DataMapFile)((Pair)codec.decode(ops, (Object)jsonelement).getOrThrow()).getFirst());
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Could not read data map of type {} for registry {}", new Object[]{attachmentType.id(), registryKey, exception});
            }
        }
        return entries;
    }

    private static /* synthetic */ LoadResult lambda$load$10(class_5321 k) {
        return new LoadResult(new HashMap());
    }

    private record LoadResult<T>(Map<DataMapType<T, ?>, List<DataMapFile<?, T>>> results) {
    }
}

