/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.neoforged.neoforge.registries.DataMapLoader;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapEntry;
import net.neoforged.neoforge.registries.datamaps.DataMapFile;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;

public abstract class DataMapProvider
implements class_2405 {
    protected final CompletableFuture<class_7225.class_7874> lookupProvider;
    protected final class_7784.class_7489 pathProvider;
    private final Map<DataMapType<?, ?>, Builder<?, ?>> builders = new HashMap();

    protected DataMapProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "data_maps");
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.gather();
        return this.lookupProvider.thenCompose(provider -> {
            class_6903 dynamicOps = provider.method_57093((DynamicOps)JsonOps.INSTANCE);
            return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(arg_0 -> this.lambda$run$0(cache, (DynamicOps)dynamicOps, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T, R> CompletableFuture<?> generate(Path out, class_7403 cache, Builder<T, R> builder, DynamicOps<JsonElement> ops) {
        return CompletableFuture.supplyAsync(() -> {
            Codec withConditionsCodec = class_5699.method_57155(DataMapFile.codec(builder.registryKey, builder.type));
            return (JsonElement)withConditionsCodec.encodeStart(ops, Optional.of(builder.build())).getOrThrow(msg -> new RuntimeException("Failed to encode %s: %s".formatted(out, msg)));
        }).thenComposeAsync(encoded -> class_2405.method_10320((class_7403)cache, (JsonElement)encoded, (Path)out));
    }

    protected abstract void gather();

    public <T, R> Builder<T, R> builder(DataMapType<R, T> type) {
        if (type instanceof AdvancedDataMapType) {
            AdvancedDataMapType advanced = (AdvancedDataMapType)type;
            return this.builder(advanced);
        }
        return this.builders.computeIfAbsent(type, k -> new Builder(type));
    }

    public <T, R, VR extends DataMapValueRemover<R, T>> AdvancedBuilder<T, R, VR> builder(AdvancedDataMapType<R, T, VR> type) {
        return (AdvancedBuilder)this.builders.computeIfAbsent(type, k -> new AdvancedBuilder(type));
    }

    public String method_10321() {
        return "Data Maps";
    }

    private /* synthetic */ CompletableFuture lambda$run$0(class_7403 cache, DynamicOps dynamicOps, Map.Entry entry) {
        DataMapType type = (DataMapType)entry.getKey();
        Path path = this.pathProvider.method_44107(type.id().method_45138(DataMapLoader.getFolderLocation(type.registryKey().method_29177()) + "/"));
        return this.generate(path, cache, (Builder)entry.getValue(), (DynamicOps<JsonElement>)dynamicOps);
    }

    public static class Builder<T, R> {
        private final Map<Either<class_6862<R>, class_5321<R>>, Optional<DataMapEntry<T>>> values = new LinkedHashMap<Either<class_6862<R>, class_5321<R>>, Optional<DataMapEntry<T>>>();
        protected final List<DataMapEntry.Removal<T, R>> removals = new ArrayList<DataMapEntry.Removal<T, R>>();
        protected final class_5321<class_2378<R>> registryKey;
        private final DataMapType<R, T> type;
        private boolean replace;

        public Builder(DataMapType<R, T> type) {
            this.type = type;
            this.registryKey = type.registryKey();
        }

        public Builder<T, R> add(class_5321<R> key, T value, boolean replace) {
            this.values.put(Either.right(key), Optional.of(new DataMapEntry<T>(value, replace)));
            return this;
        }

        public Builder<T, R> add(class_2960 id, T value, boolean replace) {
            return this.add(class_5321.method_29179(this.registryKey, (class_2960)id), value, replace);
        }

        public Builder<T, R> add(class_6880<R> object, T value, boolean replace) {
            return this.add((class_5321)object.method_40230().orElseThrow(), value, replace);
        }

        public Builder<T, R> add(class_6862<R> tag, T value, boolean replace) {
            this.values.put(Either.left(tag), Optional.of(new DataMapEntry<T>(value, replace)));
            return this;
        }

        public Builder<T, R> remove(class_2960 id) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)class_5321.method_29179(this.registryKey, (class_2960)id)), Optional.empty()));
            return this;
        }

        public Builder<T, R> remove(class_6862<R> tag) {
            this.removals.add(new DataMapEntry.Removal(Either.left(tag), Optional.empty()));
            return this;
        }

        public Builder<T, R> remove(class_6880<R> value) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)((class_5321)value.method_40229().orThrow())), Optional.empty()));
            return this;
        }

        public Builder<T, R> replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public DataMapFile<T, R> build() {
            return new DataMapFile<T, R>(this.replace, this.values, this.removals);
        }
    }

    public static class AdvancedBuilder<T, R, VR extends DataMapValueRemover<R, T>>
    extends Builder<T, R> {
        public AdvancedBuilder(AdvancedDataMapType<R, T, VR> type) {
            super(type);
        }

        public AdvancedBuilder<T, R, VR> remove(class_6862<R> tag, VR remover) {
            this.removals.add(new DataMapEntry.Removal(Either.left(tag), Optional.of(remover)));
            return this;
        }

        public AdvancedBuilder<T, R, VR> remove(class_6880<R> value, VR remover) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)((class_5321)value.method_40229().orThrow())), Optional.of(remover)));
            return this;
        }

        public AdvancedBuilder<T, R, VR> remove(class_2960 id, VR remover) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)class_5321.method_29179((class_5321)this.registryKey, (class_2960)id)), Optional.of(remover)));
            return this;
        }
    }
}

