/*
 * Decompiled with CFR 0.152.
 */
package fuzs.neoforgedatapackextensions.fabric.impl;

import fuzs.neoforgedatapackextensions.impl.NeoForgeDataPackExtensions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3302;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7782;
import net.minecraft.class_8605;
import net.neoforged.neoforge.network.configuration.RegistryDataMapNegotiation;
import net.neoforged.neoforge.network.payload.KnownRegistryDataMapsPayload;
import net.neoforged.neoforge.network.payload.KnownRegistryDataMapsReplyPayload;
import net.neoforged.neoforge.network.payload.RegistryDataMapSyncPayload;
import net.neoforged.neoforge.registries.DataMapLoader;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.Nullable;

public class NeoForgeDataPackExtensionsFabric
implements ModInitializer {
    @Nullable
    private static DataMapLoader dataMapLoader;

    public void onInitialize() {
        NeoForgeDataPackExtensionsFabric.registerEventHandlers();
        NeoForgeDataPackExtensionsFabric.registerNetworkMessages();
    }

    private static void registerEventHandlers() {
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (!client) {
                Objects.requireNonNull(dataMapLoader, "data map loader is null");
                dataMapLoader.apply();
            }
        });
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> handler.addTask((class_8605)new RegistryDataMapNegotiation(handler)));
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> RegistryManager.getDataMaps().forEach((registry, values) -> {
            Optional regOpt = player.method_5682().method_30002().method_30349().method_46759(registry);
            if (regOpt.isEmpty()) {
                return;
            }
            if (!ServerPlayNetworking.canSend((class_3222)player, RegistryDataMapSyncPayload.TYPE)) {
                return;
            }
            if (player.field_13987.field_45013.method_10756() && !class_7782.method_62704((class_5321)registry)) {
                return;
            }
            Map playerMaps = (Map)player.field_13987.field_45013.field_11651.attr(RegistryManager.ATTRIBUTE_KNOWN_DATA_MAPS).get();
            if (playerMaps == null) {
                return;
            }
            NeoForgeDataPackExtensionsFabric.handleSync(player, (class_2378)regOpt.get(), playerMaps.getOrDefault(registry, List.of()));
        }));
    }

    public static void onAddDataPackReloadListeners(class_5455 fullRegistries, class_7225.class_7874 lookupWithUpdatedTags, BiConsumer<class_2960, class_3302> consumer) {
        dataMapLoader = new DataMapLoader(fullRegistries);
        consumer.accept(NeoForgeDataPackExtensions.id("data_maps"), dataMapLoader);
    }

    private static <T> void handleSync(class_3222 player, class_2378<T> registry, Collection<class_2960> attachments) {
        if (attachments.isEmpty()) {
            return;
        }
        HashMap att = new HashMap();
        attachments.forEach(key -> {
            DataMapType attach = RegistryManager.getDataMap(registry.method_46765(), key);
            if (attach == null || attach.networkCodec() == null) {
                return;
            }
            att.put((class_2960)key, registry.neoforgedatapackextensions$getDataMap(attach));
        });
        if (!att.isEmpty()) {
            ServerPlayNetworking.send((class_3222)player, new RegistryDataMapSyncPayload(registry.method_46765(), att));
        }
    }

    private static void registerNetworkMessages() {
        PayloadTypeRegistry.configurationC2S().register(KnownRegistryDataMapsReplyPayload.TYPE, KnownRegistryDataMapsReplyPayload.STREAM_CODEC);
        PayloadTypeRegistry.configurationS2C().register(KnownRegistryDataMapsPayload.TYPE, KnownRegistryDataMapsPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(RegistryDataMapSyncPayload.TYPE, RegistryDataMapSyncPayload.STREAM_CODEC);
        ServerConfigurationNetworking.registerGlobalReceiver(KnownRegistryDataMapsReplyPayload.TYPE, RegistryManager::handleKnownDataMapsReply);
    }
}

