/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.util;

import com.google.gson.JsonElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.ramixin.mixson.inline.BuiltMixsonEvent;
import net.ramixin.mixson.inline.BuiltResourceReference;
import net.ramixin.mixson.inline.ContextCreationType;
import net.ramixin.mixson.inline.EventContext;
import net.ramixin.mixson.inline.MixsonCodec;
import net.ramixin.mixson.inline.entries.EventEntry;
import net.ramixin.mixson.util.ErrorMessageProvider;
import org.apache.logging.log4j.util.TriConsumer;

public interface MixsonUtil {
    public static ByteArrayOutputStream exportJson(JsonElement json) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(json.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos;
    }

    public static String identifierToPathString(String resourceId, String extension) {
        class_2960 usable = class_2960.method_60654((String)resourceId);
        return usable.method_12836() + "~" + usable.method_12832().replaceFirst("\\" + extension, "").replaceAll("/", "-");
    }

    public static String stringToUsablePath(String string) {
        return string.replaceAll("[*|/\\\\:?<>\"]", "");
    }

    public static class_2960 removeExtension(class_2960 id) {
        String stringId = id.method_12832();
        for (int i = stringId.length() - 1; i > 0; --i) {
            if (stringId.charAt(i) != '.') continue;
            return class_2960.method_60655((String)id.method_12836(), (String)stringId.substring(0, i));
        }
        return id;
    }

    public static Function<class_2960, Boolean> getLocatorFromString(String resourceId) {
        if (resourceId.endsWith("*")) {
            String id = MixsonUtil.removeWildcard(resourceId);
            return resourceLoc -> resourceLoc.toString().startsWith(id);
        }
        return resourceLoc -> resourceLoc.equals((Object)class_2960.method_60654((String)resourceId));
    }

    public static <T> void addComponent(T component, int priority, UUID uuid, Map<UUID, T> components, SortedMap<Integer, List<T>> orderedComponents) {
        components.put(uuid, component);
        List<Object> componentSet = orderedComponents.get(priority) == null ? new ArrayList<T>() : (List)orderedComponents.get(priority);
        componentSet.add(component);
        orderedComponents.put(priority, componentSet);
    }

    public static String removeWildcard(String string) {
        return string.substring(0, string.length() - 1);
    }

    public static <T> EventContext<T> createContext(ContextCreationType creationType, class_2960 resourceId, T file, EventEntry<T> entry, boolean markedForDeletion, Function<UUID, BuiltResourceReference<?>> referenceCallback) {
        BuiltMixsonEvent<T> event = entry.event();
        BuiltResourceReference[] gatheredReferences = new BuiltResourceReference[event.referenceIds().length];
        for (int i = 0; i < event.referenceIds().length; ++i) {
            BuiltResourceReference<?> ref;
            gatheredReferences[i] = ref = referenceCallback.apply(event.referenceIds()[i]);
        }
        return new EventContext<T>(creationType, file, resourceId, entry, markedForDeletion, gatheredReferences);
    }

    public static <T> Optional<T> getFile(MixsonCodec<T> codec, class_3298 resource, ErrorMessageProvider messageProvider, class_2960 resourceId, TriConsumer<Exception, ErrorMessageProvider, class_2960> errorCallback) {
        try {
            return Optional.of(codec.deserialize(resource));
        }
        catch (IOException e) {
            errorCallback.accept((Object)e, (Object)messageProvider, (Object)resourceId);
            return Optional.empty();
        }
    }
}

