/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.inline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import net.ramixin.mixson.inline.BuiltMixsonEvent;
import net.ramixin.mixson.inline.BuiltResourceReference;
import net.ramixin.mixson.inline.entries.AbstractEntry;
import net.ramixin.mixson.inline.entries.EventEntry;
import net.ramixin.mixson.inline.entries.ReferenceEntry;

public class MixsonRuntime {
    private final List<AbstractEntry> queuedEvents = new ArrayList<AbstractEntry>();
    private final HashMap<UUID, BuiltResourceReference<?>> runtimeReferences = new HashMap();

    protected MixsonRuntime(SortedMap<Integer, List<BuiltMixsonEvent<?>>> events, SortedMap<Integer, List<BuiltResourceReference<?>>> references) {
        List entries;
        TreeMap<Integer, List> combinedEntries = new TreeMap<Integer, List>();
        for (int priority : references.keySet()) {
            List builtReference = (List)references.get(priority);
            entries = combinedEntries.computeIfAbsent(priority, k -> new ArrayList());
            builtReference.stream().map(reference -> new ReferenceEntry(priority, reference)).forEach(entries::add);
        }
        for (int priority : events.keySet()) {
            List builtEvents = (List)events.get(priority);
            entries = combinedEntries.computeIfAbsent(priority, k -> new ArrayList());
            builtEvents.stream().map(event -> new EventEntry(priority, event)).forEach(entries::add);
        }
        combinedEntries.sequencedValues().forEach(this.queuedEvents::addAll);
    }

    protected AbstractEntry pop() {
        return this.queuedEvents.removeFirst();
    }

    protected boolean hasFinished() {
        return !this.queuedEvents.isEmpty();
    }

    protected void insertEntry(AbstractEntry entry) {
        if (entry instanceof ReferenceEntry) {
            ReferenceEntry referenceEntry = (ReferenceEntry)entry;
            this.runtimeReferences.put(referenceEntry.reference().getUuid(), referenceEntry.reference());
        }
        int priority = entry.priority();
        for (int i = 0; i < this.queuedEvents.size(); ++i) {
            AbstractEntry abstractEntry = this.queuedEvents.get(i);
            if (abstractEntry.priority() <= priority) continue;
            this.queuedEvents.add(i, entry);
            return;
        }
        this.queuedEvents.add(entry);
    }

    protected void cancelEvent(UUID uuid) {
        for (int i = 0; i < this.queuedEvents.size(); ++i) {
            EventEntry eventEntry;
            AbstractEntry abstractEntry = this.queuedEvents.get(i);
            if (!(abstractEntry instanceof EventEntry) || !(eventEntry = (EventEntry)abstractEntry).event().uuid().equals(uuid)) continue;
            this.queuedEvents.remove(i);
            return;
        }
    }

    protected BuiltResourceReference<?> getReference(UUID uuid, Function<UUID, BuiltResourceReference<?>> globalCallback) {
        BuiltResourceReference<?> reference = this.runtimeReferences.containsKey(uuid) ? this.runtimeReferences.get(uuid) : globalCallback.apply(uuid);
        return reference;
    }
}

