/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.inline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.class_3298;
import net.ramixin.mixson.util.ResourceDeserializer;
import net.ramixin.mixson.util.ResourceExporter;
import net.ramixin.mixson.util.ResourceSerializer;

public interface MixsonCodec<T> {
    public T deserialize(class_3298 var1) throws IOException;

    public class_3298 serialize(class_3298 var1, T var2);

    public ByteArrayOutputStream serializeOutputFile(T var1) throws IOException;

    public String extensionAndDot();

    @Deprecated(forRemoval=true)
    public static <T> MixsonCodec<T> of(String extension, ResourceDeserializer<T> deserializer, ResourceSerializer<T> serializer, Function<T, String> outputFileSerializer) {
        return MixsonCodec.create(extension, deserializer, serializer, item -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(((String)outputFileSerializer.apply(item)).getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return baos;
        });
    }

    public static <T> MixsonCodec<T> create(final String extension, final ResourceDeserializer<T> deserializer, final ResourceSerializer<T> serializer, final ResourceExporter<T> outputFileSerializer) {
        return new MixsonCodec<T>(){

            @Override
            public T deserialize(class_3298 resource) throws IOException {
                return deserializer.deserialize(resource);
            }

            @Override
            public class_3298 serialize(class_3298 associatedResource, T file) {
                return serializer.serialize(associatedResource, file);
            }

            @Override
            public ByteArrayOutputStream serializeOutputFile(T file) throws IOException {
                return outputFileSerializer.export(file);
            }

            @Override
            public String extensionAndDot() {
                return "." + extension;
            }
        };
    }
}

