/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.inline;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.ramixin.mixson.MixsonError;
import net.ramixin.mixson.atp.MixsonAnnotationProcessor;
import net.ramixin.mixson.debug.CallCountEntry;
import net.ramixin.mixson.debug.DebugMode;
import net.ramixin.mixson.debug.MixsonCommand;
import net.ramixin.mixson.inline.BuiltMixsonEvent;
import net.ramixin.mixson.inline.BuiltResourceReference;
import net.ramixin.mixson.inline.ContextCreationType;
import net.ramixin.mixson.inline.EventContext;
import net.ramixin.mixson.inline.MixsonCodec;
import net.ramixin.mixson.inline.MixsonEvent;
import net.ramixin.mixson.inline.MixsonRuntime;
import net.ramixin.mixson.inline.ResourceReference;
import net.ramixin.mixson.inline.entries.AbstractEntry;
import net.ramixin.mixson.inline.entries.EventEntry;
import net.ramixin.mixson.inline.entries.ReferenceEntry;
import net.ramixin.mixson.util.ErrorMessageProvider;
import net.ramixin.mixson.util.HexRecord;
import net.ramixin.mixson.util.MixsonUtil;
import net.ramixin.mixson.util.QuintConsumer;
import net.ramixin.mixson.util.ResourceExporter;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mixson
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mixson");
    private static DebugMode debugMode = DebugMode.OFF;
    private static final Map<UUID, BuiltMixsonEvent<?>> events = Collections.synchronizedMap(new ConcurrentHashMap());
    private static final SortedMap<Integer, List<BuiltMixsonEvent<?>>> orderedEvents = Collections.synchronizedSortedMap(new TreeMap());
    private static final Map<UUID, CallCountEntry> callCounts = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, BuiltResourceReference<?>> references = Collections.synchronizedMap(new ConcurrentHashMap());
    private static final SortedMap<Integer, List<BuiltResourceReference<?>>> orderedReferences = Collections.synchronizedSortedMap(new TreeMap());
    public static final int DEFAULT_PRIORITY = 1000;
    public static final MixsonCodec<JsonElement> JSON_ELEMENT_CODEC = MixsonCodec.create("json", r -> JsonParser.parseReader((Reader)r.method_43039()), (r, x) -> new class_3298(r.method_45304(), () -> new ByteArrayInputStream(x.toString().getBytes()), () -> ((class_3298)r).method_14481()), MixsonUtil::exportJson);

    public static UUID registerEvent(int priority, String resourceId, String eventName, MixsonEvent<JsonElement> event, ResourceReference ... references) {
        return Mixson.registerEvent(priority, resourceId, eventName, event, false, references);
    }

    public static UUID registerEvent(int priority, String resourceId, String eventName, MixsonEvent<JsonElement> event, boolean silentlyFail, ResourceReference ... references) {
        return Mixson.registerEvent(JSON_ELEMENT_CODEC, priority, resourceId, eventName, event, silentlyFail, references);
    }

    public static UUID registerEvent(int priority, Function<class_2960, Boolean> resourceLocator, String eventName, MixsonEvent<JsonElement> event, boolean silentlyFail, ResourceReference ... references) {
        return Mixson.registerEvent(JSON_ELEMENT_CODEC, priority, resourceLocator, eventName, event, silentlyFail, references);
    }

    public static <T> UUID registerEvent(MixsonCodec<T> codec, int priority, String resourceId, String eventName, MixsonEvent<T> event, boolean silentlyFail, ResourceReference ... references) {
        return Mixson.registerEvent(codec, priority, MixsonUtil.getLocatorFromString(resourceId), eventName, event, silentlyFail, references);
    }

    public static <T> UUID registerEvent(MixsonCodec<T> codec, int priority, Function<class_2960, Boolean> resourceLocator, String eventName, MixsonEvent<T> event, boolean silentlyFail, ResourceReference ... references) {
        return Mixson.finalizeEventRegistration(priority, Mixson.buildMixsonEvent(codec, priority, resourceLocator, eventName, event, silentlyFail, references, Mixson::finalizeReferenceRegistration));
    }

    private static <T> UUID finalizeEventRegistration(int priority, BuiltMixsonEvent<T> builtEvent) {
        MixsonUtil.addComponent(builtEvent, priority, builtEvent.uuid(), events, orderedEvents);
        return builtEvent.uuid();
    }

    private static <T> void finalizeReferenceRegistration(int priority, BuiltResourceReference<T> builtReference) {
        MixsonUtil.addComponent(builtReference, priority, builtReference.getUuid(), references, orderedReferences);
    }

    @NotNull
    private static <T> BuiltMixsonEvent<T> buildMixsonEvent(MixsonCodec<T> codec, int priority, Function<class_2960, Boolean> resourceLocator, String eventName, MixsonEvent<T> event, boolean silentlyFail, ResourceReference[] references, BiConsumer<Integer, BuiltResourceReference<T>> referenceCallback) {
        boolean fail = event.ordinal() < 0 && event.ordinal() != -1;
        Mixson.logEventRegistration(eventName, priority);
        UUID[] referenceIds = new UUID[references.length];
        for (ResourceReference ref : references) {
            BuiltResourceReference<T> builtReference = new BuiltResourceReference<T>(ref, codec);
            referenceIds[i] = builtReference.getUuid();
            referenceCallback.accept(ref.priority(), builtReference);
        }
        BuiltMixsonEvent<T> builtEvent = new BuiltMixsonEvent<T>(codec, resourceLocator, eventName, event, silentlyFail, referenceIds);
        if (fail) {
            Mixson.registrationError(new MixsonError("event ordinal value cannot be negative", new Object[0]), builtEvent);
        }
        return builtEvent;
    }

    public void onInitialize() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            CustomValue mixson = mod.getMetadata().getCustomValue("mixson");
            if (mixson == null) continue;
            if (!(mixson instanceof CustomValue.CvArray)) {
                throw new MixsonError("'mixson' field in mod '%s' is not of type array", mod.getMetadata().getId());
            }
            CustomValue.CvArray array = (CustomValue.CvArray)mixson;
            for (CustomValue entry : array) {
                if (entry.getType() != CustomValue.CvType.STRING) {
                    throw new MixsonError("'mixson' field in mod '%s' contains non-string value '%s'", mod.getMetadata().getId(), entry);
                }
                String className = entry.getAsString();
                try {
                    MixsonAnnotationProcessor.processClass(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    throw new MixsonError("class '%s' in 'mixson' field in mod '%s' does not exist", className, mod.getMetadata().getId());
                }
            }
        }
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        if (!FabricLoader.getInstance().isModLoaded("fabric")) {
            return;
        }
        MixsonCommand.onInitialize();
    }

    public static Map<class_2960, class_3298> runStandardEvents(Map<class_2960, class_3298> original) {
        MixsonRuntime runtime = new MixsonRuntime(orderedEvents, orderedReferences);
        HashSet markedForDeletion = new HashSet();
        HashSet<UUID> filledReferences = new HashSet<UUID>();
        while (runtime.hasFinished()) {
            AbstractEntry entry = runtime.pop();
            if (entry instanceof ReferenceEntry) {
                ReferenceEntry referenceEntry = (ReferenceEntry)entry;
                int ordinal = entry.getOrdinal();
                BuiltResourceReference ref = referenceEntry.reference();
                class_2960 resourceId = ref.getResourceId().method_48331(ref.getCodec().extensionAndDot());
                if (!original.containsKey(resourceId)) continue;
                if (ordinal >= 1) {
                    Mixson.ordinalError(ordinal, 0, ref, resourceId);
                }
                Mixson.fulfillReference(original.get(resourceId), ref, filledReferences);
                continue;
            }
            Mixson.beginEventProcessing(Mixson::processStandardEvent, original, (EventEntry)entry, runtime, markedForDeletion);
        }
        filledReferences.forEach(uuid -> {
            if (references.containsKey(uuid)) {
                references.get(uuid).clear();
            }
        });
        for (class_2960 id : markedForDeletion) {
            original.remove(id);
        }
        return original;
    }

    public static Map<class_2960, List<class_3298>> runListEvents(Map<class_2960, List<class_3298>> original) {
        MixsonRuntime runtime = new MixsonRuntime(orderedEvents, orderedReferences);
        HashSet markedForDeletion = new HashSet();
        HashSet<UUID> filledReferences = new HashSet<UUID>();
        while (runtime.hasFinished()) {
            AbstractEntry entry = runtime.pop();
            if (entry instanceof ReferenceEntry) {
                ReferenceEntry referenceEntry = (ReferenceEntry)entry;
                int ordinal = entry.getOrdinal();
                BuiltResourceReference ref = referenceEntry.reference();
                class_2960 resourceId = ref.getResourceId().method_48331(ref.getCodec().extensionAndDot());
                if (!original.containsKey(resourceId)) continue;
                List<class_3298> resources = original.get(resourceId);
                if (ordinal >= resources.size()) {
                    Mixson.ordinalError(ordinal, resources.size() - 1, ref, resourceId);
                }
                class_3298 resource = resources.get(ordinal);
                Mixson.fulfillReference(resource, ref, filledReferences);
                continue;
            }
            Mixson.beginEventProcessing(Mixson::prepareListEventProcessing, original, (EventEntry)entry, runtime, markedForDeletion);
        }
        filledReferences.forEach(uuid -> {
            if (references.containsKey(uuid)) {
                references.get(uuid).clear();
            }
        });
        for (Pair pairId : markedForDeletion) {
            List<class_3298> resources = original.get(pairId.getFirst());
            resources.set((Integer)pairId.getSecond(), null);
        }
        for (class_2960 resourceId : original.keySet()) {
            List<class_3298> resources = original.get(resourceId);
            resources.removeIf(Objects::isNull);
        }
        return original;
    }

    public static List<class_3298> runNamespaceEvents(List<class_3298> original, class_2960 id) {
        MixsonRuntime runtime = new MixsonRuntime(orderedEvents, orderedReferences);
        HashSet<Integer> markedForDeletion = new HashSet<Integer>();
        HashSet<UUID> filledReferences = new HashSet<UUID>();
        while (runtime.hasFinished()) {
            AbstractEntry entry = runtime.pop();
            if (entry instanceof ReferenceEntry) {
                ReferenceEntry referenceEntry = (ReferenceEntry)entry;
                int ordinal = entry.getOrdinal();
                BuiltResourceReference ref = referenceEntry.reference();
                if (!ref.getResourceId().method_48331(ref.getCodec().extensionAndDot()).equals((Object)id)) continue;
                if (ordinal >= original.size()) {
                    Mixson.ordinalError(ordinal, original.size() - 1, ref, ref.getResourceId());
                }
                class_3298 resource = original.get(ordinal);
                Mixson.fulfillReference(resource, ref, filledReferences);
                continue;
            }
            EventEntry eventEntry = (EventEntry)entry;
            BuiltMixsonEvent event = eventEntry.event();
            int fileOperations = 0;
            if (!event.isApplicable(id)) continue;
            int ordinal = eventEntry.getOrdinal();
            if (ordinal >= original.size()) {
                Mixson.ordinalError(ordinal, original.size() - 1, event, id);
            }
            if (ordinal == -1) {
                int toIter = original.size();
                for (int i = 0; i < toIter; ++i) {
                    Mixson.processNamespaceEvent(original, runtime, markedForDeletion, eventEntry, id, i);
                    ++fileOperations;
                }
            } else {
                Mixson.processNamespaceEvent(original, runtime, markedForDeletion, eventEntry, id, ordinal);
                ++fileOperations;
            }
            Mixson.incrementCallCounts(event, fileOperations);
        }
        filledReferences.forEach(uuid -> {
            if (references.containsKey(uuid)) {
                references.get(uuid).clear();
            }
        });
        markedForDeletion.stream().sorted(Comparator.reverseOrder()).forEach(clazzInt -> original.remove((int)clazzInt));
        return original;
    }

    private static <T, M, K> void beginEventProcessing(QuintConsumer<Map<class_2960, K>, MixsonRuntime, Set<T>, EventEntry<M>, class_2960> processor, Map<class_2960, K> original, EventEntry<M> entry, MixsonRuntime runtime, Set<T> markedForDeletion) {
        BuiltMixsonEvent<M> event = entry.event();
        int fileOperations = 0;
        List<class_2960> keys = original.keySet().stream().filter(event::isApplicable).sorted(class_2960::method_12833).toList();
        for (class_2960 resourceId : keys) {
            ++fileOperations;
            processor.accept(original, runtime, markedForDeletion, entry, resourceId);
        }
        if (fileOperations != 0) {
            Mixson.incrementCallCounts(event, fileOperations);
        }
    }

    private static <T> void processNamespaceEvent(List<class_3298> original, MixsonRuntime runtime, Set<Integer> markedForDeletion, EventEntry<T> eventEntry, class_2960 resourceId, int i) {
        BuiltMixsonEvent<T> event = eventEntry.event();
        class_3298 resource = original.get(i);
        Optional<T> file = MixsonUtil.getFile(event.codec(), resource, event, resourceId, (TriConsumer<Exception, ErrorMessageProvider, class_2960>)((TriConsumer)Mixson::runtimeError));
        if (file.isEmpty()) {
            return;
        }
        try {
            EventContext<T> context = Mixson.processContext(runtime, markedForDeletion, eventEntry, event, resourceId, i, file.get());
            for (T createdEntry : context.getIndexedCreatedResources()) {
                original.add(event.codec().serialize(resource, createdEntry));
            }
            original.set(i, event.codec().serialize(resource, context.getFile()));
        }
        catch (Exception e) {
            Mixson.runtimeError(e, event, resourceId);
        }
    }

    private static <T> void prepareListEventProcessing(Map<class_2960, List<class_3298>> original, MixsonRuntime runtime, Set<Pair<class_2960, Integer>> markedForDeletion, EventEntry<T> eventEntry, class_2960 resourceId) {
        BuiltMixsonEvent<T> event = eventEntry.event();
        List<class_3298> resources = original.get(resourceId);
        int ordinal = eventEntry.getOrdinal();
        if (ordinal >= resources.size()) {
            Mixson.ordinalError(ordinal, resources.size() - 1, event, resourceId);
        }
        if (ordinal == -1) {
            for (int i = 0; i < resources.size(); ++i) {
                Mixson.processListEvent(original, resourceId, resources, i, event, runtime, eventEntry, markedForDeletion);
            }
        } else {
            Mixson.processListEvent(original, resourceId, resources, ordinal, event, runtime, eventEntry, markedForDeletion);
        }
    }

    private static <T> void processListEvent(Map<class_2960, List<class_3298>> original, class_2960 resourceId, List<class_3298> resources, int ordinal, BuiltMixsonEvent<T> event, MixsonRuntime runtime, EventEntry<T> eventEntry, Set<Pair<class_2960, Integer>> markedForDeletion) {
        class_3298 resource = resources.get(ordinal);
        Pair pairedId = Pair.of((Object)resourceId, (Object)ordinal);
        Optional<T> file = MixsonUtil.getFile(event.codec(), resources.get(ordinal), event, resourceId, (TriConsumer<Exception, ErrorMessageProvider, class_2960>)((TriConsumer)Mixson::runtimeError));
        if (file.isEmpty()) {
            return;
        }
        try {
            EventContext<T> context = Mixson.processContext(runtime, markedForDeletion, eventEntry, event, resourceId, pairedId, file.get());
            context.getCancelledFutures().forEach(runtime::cancelEvent);
            for (Map.Entry<class_2960, T> createdEntry : context.getIdentifiedCreatedResources().entrySet()) {
                List createdResources = original.computeIfAbsent(createdEntry.getKey(), unused -> new ArrayList());
                createdResources.add(event.codec().serialize(resource, createdEntry.getValue()));
            }
            resources.set(ordinal, event.codec().serialize(resource, context.getFile()));
        }
        catch (Exception e) {
            Mixson.runtimeError(e, event, resourceId);
        }
    }

    private static <T> void processStandardEvent(Map<class_2960, class_3298> original, MixsonRuntime runtime, Set<class_2960> markedForDeletion, EventEntry<T> eventEntry, class_2960 resourceId) {
        BuiltMixsonEvent<T> event = eventEntry.event();
        class_3298 resource = original.get(resourceId);
        Optional<T> file = MixsonUtil.getFile(event.codec(), resource, event, resourceId, (TriConsumer<Exception, ErrorMessageProvider, class_2960>)((TriConsumer)Mixson::runtimeError));
        if (file.isEmpty()) {
            return;
        }
        try {
            EventContext<T> context = Mixson.processContext(runtime, markedForDeletion, eventEntry, event, resourceId, resourceId, file.get());
            for (Map.Entry<class_2960, T> createdEntry : context.getIdentifiedCreatedResources().entrySet()) {
                original.put(createdEntry.getKey(), event.codec().serialize(resource, createdEntry.getValue()));
            }
            original.put(resourceId, event.codec().serialize(resource, context.getFile()));
        }
        catch (Exception e) {
            Mixson.runtimeError(e, event, resourceId);
        }
    }

    @NotNull
    private static <N, T> EventContext<T> processContext(MixsonRuntime runtime, Set<N> markedForDeletion, EventEntry<T> eventEntry, BuiltMixsonEvent<T> event, class_2960 resourceId, N indexer, T file) {
        BuiltMixsonEvent builtEvent;
        EventContext<T> context = MixsonUtil.createContext(ContextCreationType.IDENTIFIED, resourceId, file, eventEntry, markedForDeletion.contains(indexer), uuid -> runtime.getReference((UUID)uuid, references::get));
        Mixson.logEventRun(event, resourceId);
        event.event().runEvent(context);
        Mixson.exportDebugFile(event.codec()::serializeOutputFile, context.getFile(), event.eventName(), resourceId.toString(), event.codec().extensionAndDot());
        if (context.isMarkedForDeletion()) {
            markedForDeletion.add(indexer);
        } else {
            markedForDeletion.remove(indexer);
        }
        context.getCancelledFutures().forEach(runtime::cancelEvent);
        ArrayList appendable = new ArrayList();
        for (HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]> createdEvent : context.getCreatedEvents()) {
            builtEvent = createdEvent.apply((integer, locator, string2, mixsonEvent, aBoolean, resourceReferences) -> Mixson.buildMixsonEvent(event.codec(), integer, locator, string2, mixsonEvent, aBoolean, resourceReferences, (integer1, reference) -> {
                appendable.add(new ReferenceEntry((int)integer1, reference));
                Mixson.finalizeReferenceRegistration(integer1, reference);
            }));
            appendable.add(new EventEntry(createdEvent.first(), builtEvent));
            Mixson.finalizeEventRegistration(createdEvent.first(), builtEvent);
        }
        for (HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]> createdEvent : context.getCreatedRuntimeEvents()) {
            builtEvent = createdEvent.apply((integer, locator, string2, mixsonEvent, aBoolean, resourceReferences) -> Mixson.buildMixsonEvent(event.codec(), integer, locator, string2, mixsonEvent, aBoolean, resourceReferences, (integer1, reference) -> appendable.add(new ReferenceEntry((int)integer1, reference))));
            appendable.add(new EventEntry(createdEvent.first(), builtEvent));
        }
        appendable.forEach(runtime::insertEntry);
        return context;
    }

    private static <T> void fulfillReference(class_3298 resource, BuiltResourceReference<T> ref, Set<UUID> filledReferences) {
        try {
            T file = ref.getCodec().deserialize(resource);
            ref.fulfill(file);
            filledReferences.add(ref.getUuid());
        }
        catch (IOException e) {
            Mixson.runtimeError(e, ref, ref.getResourceId());
        }
    }

    private static void registrationError(Exception e, ErrorMessageProvider errorMessageProvider) {
        if (!errorMessageProvider.failSilently()) {
            throw new MixsonError(errorMessageProvider.getRegistrationMessage() + String.valueOf(e), new Object[0]);
        }
        LOGGER.error(errorMessageProvider.getRegistrationMessage(), (Throwable)e);
    }

    private static void runtimeError(Exception e, ErrorMessageProvider errorMessageProvider, class_2960 resourceId) {
        if (!errorMessageProvider.failSilently()) {
            throw new MixsonError(errorMessageProvider.getRuntimeMessage(resourceId) + String.valueOf(e), new Object[0]);
        }
        LOGGER.error(errorMessageProvider.getRuntimeMessage(resourceId), (Throwable)e);
    }

    private static void ordinalError(int ordinal, int maxOrdinal, BuiltMixsonEvent<?> event, class_2960 resourceId) {
        Mixson.runtimeError(new MixsonError("ordinal value '" + ordinal + "' points to no value. Max Ordinal Value: " + maxOrdinal, new Object[0]), event, resourceId);
    }

    private static void ordinalError(int ordinal, int maxOrdinal, BuiltResourceReference<?> reference, class_2960 resourceId) {
        Mixson.runtimeError(new MixsonError("ordinal value '" + ordinal + "' points to no value. Max Ordinal Value: " + maxOrdinal, new Object[0]), reference, resourceId);
    }

    public static boolean removeEvent(UUID uuid) {
        for (List<BuiltMixsonEvent<?>> eventSet : orderedEvents.values()) {
            eventSet.removeIf(event -> event.uuid().equals(uuid));
        }
        return events.remove(uuid) != null;
    }

    public static String getEventName(UUID uuid) {
        return events.get(uuid).eventName();
    }

    public static void setDebugMode(DebugMode debugMode) {
        Mixson.debugMode = debugMode;
        LOGGER.info("Mixson Debug Mode has been set to: {}", (Object)debugMode);
    }

    private static void logEventRun(BuiltMixsonEvent<?> event, class_2960 resourceId) {
        Mixson.logAction("Running '{}' on resource '{}'", event.eventName(), resourceId);
    }

    private static void logEventRegistration(String eventName, int priority) {
        Mixson.logAction("Registering '{}' with priority {}", eventName, priority);
    }

    private static void logAction(String action, Object ... args) {
        if (debugMode.ordinal() > 0) {
            LOGGER.info(action, args);
        }
    }

    private static void incrementCallCounts(BuiltMixsonEvent<?> event, int fileOperations) {
        CallCountEntry pair = callCounts.getOrDefault(event.uuid(), CallCountEntry.DEFAULT);
        callCounts.put(event.uuid(), pair.update(fileOperations));
    }

    private static <T> void exportDebugFile(ResourceExporter<T> resourceExporter, T resource, String eventName, String resourceId, String extension) {
        if (debugMode.ordinal() <= 1) {
            return;
        }
        Path dir = FabricLoader.getInstance().getGameDir().resolve(".mixson").resolve(MixsonUtil.identifierToPathString(resourceId, extension));
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            FileOutputStream fos = new FileOutputStream(dir.resolve(MixsonUtil.stringToUsablePath(eventName) + extension).toFile());
            fos.write(resourceExporter.export(resource).toByteArray());
            fos.close();
        }
        catch (IOException e) {
            LOGGER.error("failed to export debug file", (Throwable)e);
        }
    }

    public static void clearCalls() {
        callCounts.clear();
    }

    public static List<UUID> getCallCountsOrder() {
        return callCounts.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static CallCountEntry getCallCount(UUID uuid) {
        return callCounts.getOrDefault(uuid, CallCountEntry.DEFAULT);
    }

    static {
        try {
            FileUtils.deleteDirectory((File)FabricLoader.getInstance().getGameDir().resolve(".mixson").toFile());
        }
        catch (IOException e) {
            LOGGER.error("failed to delete .mixson debug directory", (Throwable)e);
        }
    }
}

