/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.inline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.ramixin.mixson.inline.BuiltMixsonEvent;
import net.ramixin.mixson.inline.BuiltResourceReference;
import net.ramixin.mixson.inline.ContextCreationType;
import net.ramixin.mixson.inline.MixsonEvent;
import net.ramixin.mixson.inline.ResourceReference;
import net.ramixin.mixson.inline.entries.EventEntry;
import net.ramixin.mixson.util.HexRecord;
import net.ramixin.mixson.util.MixsonUtil;

public class EventContext<T> {
    private final ContextCreationType creationType;
    private final T file;
    private final class_2960 resourceId;
    private final EventEntry<T> entry;
    private final HashMap<class_2960, BuiltResourceReference<T>> references = new HashMap();
    private boolean markedForDeletion;
    private final Set<UUID> cancelledFutures = new HashSet<UUID>();
    private final HashMap<class_2960, T> identifiedCreatedResources = new HashMap();
    private final List<T> indexedCreatedResources = new ArrayList<T>();
    private final List<HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>> createdRuntimeEvents = new ArrayList<HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>>();
    private final List<HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>> createdEvents = new ArrayList<HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>>();

    public EventContext(ContextCreationType creationType, T file, class_2960 resourceId, EventEntry<T> entry, boolean markedForDeletion, BuiltResourceReference<T>[] references) {
        this.creationType = creationType;
        this.file = file;
        this.resourceId = resourceId;
        this.entry = entry;
        this.markedForDeletion = markedForDeletion;
        for (BuiltResourceReference<T> ref : references) {
            this.references.put(ref.getReferenceId(), ref);
        }
    }

    public T getFile() {
        return this.file;
    }

    public class_2960 getResourceId() {
        return this.resourceId;
    }

    public String getEventName() {
        return this.getEvent().eventName();
    }

    public BuiltMixsonEvent<T> getEvent() {
        return this.entry.event();
    }

    public int getPriority() {
        return this.entry.priority();
    }

    public BuiltResourceReference<T> getReference(String id) {
        return this.references.get(class_2960.method_60654((String)id));
    }

    public void markForDeletion(boolean shouldDelete) {
        this.markedForDeletion = shouldDelete;
    }

    public void createResource(class_2960 id, T elem) {
        if (this.creationType != ContextCreationType.IDENTIFIED) {
            throw new IllegalCallerException(String.format("cannot created identified resources for event '%s'", this.getEventName()));
        }
        this.identifiedCreatedResources.put(id, elem);
    }

    public void createResource(T elem) {
        if (this.creationType != ContextCreationType.INDEXED) {
            throw new IllegalCallerException(String.format("cannot created indexed resources for event '%s'", this.getEventName()));
        }
        this.indexedCreatedResources.add(elem);
    }

    protected HashMap<class_2960, T> getIdentifiedCreatedResources() {
        return this.identifiedCreatedResources;
    }

    protected List<T> getIndexedCreatedResources() {
        return this.indexedCreatedResources;
    }

    public void cancelFutureEvent(UUID uuid) {
        this.cancelledFutures.add(uuid);
    }

    public void registerRuntimeEvent(int priority, String resourceId, String eventName, MixsonEvent<T> event, boolean failSilently, ResourceReference ... references) {
        this.registerRuntimeEvent(priority, MixsonUtil.getLocatorFromString(resourceId), eventName, event, failSilently, references);
    }

    public void registerDualEvent(int priority, String resourceId, String eventName, MixsonEvent<T> event, boolean failSilently, ResourceReference ... references) {
        this.registerDualEvent(priority, MixsonUtil.getLocatorFromString(resourceId), eventName, event, failSilently, references);
    }

    public void registerDualEvent(int priority, Function<class_2960, Boolean> resourceLocator, String eventName, MixsonEvent<T> event, boolean failSilently, ResourceReference ... references) {
        this.createdEvents.add(new HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>(priority, resourceLocator, eventName, event, failSilently, references));
    }

    public void registerRuntimeEvent(int priority, Function<class_2960, Boolean> resourceLocator, String eventName, MixsonEvent<T> event, boolean failSilently, ResourceReference ... references) {
        this.createdRuntimeEvents.add(new HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>(priority, resourceLocator, eventName, event, failSilently, references));
    }

    protected List<HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>> getCreatedRuntimeEvents() {
        return this.createdRuntimeEvents;
    }

    protected List<HexRecord<Integer, Function<class_2960, Boolean>, String, MixsonEvent<T>, Boolean, ResourceReference[]>> getCreatedEvents() {
        return this.createdEvents;
    }

    protected boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    protected Set<UUID> getCancelledFutures() {
        return this.cancelledFutures;
    }

    public ContextCreationType getCreationType() {
        return this.creationType;
    }
}

