/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.inline;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2960;
import net.ramixin.mixson.inline.MixsonCodec;
import net.ramixin.mixson.inline.ResourceReference;
import net.ramixin.mixson.util.ErrorMessageProvider;

public class BuiltResourceReference<T>
implements ErrorMessageProvider {
    private T resource;
    private final class_2960 referenceId;
    private final class_2960 resourceId;
    private final int ordinal;
    private final UUID uuid = UUID.randomUUID();
    private final MixsonCodec<T> codec;

    protected BuiltResourceReference(ResourceReference reference, MixsonCodec<T> codec) {
        if (reference.ordinal() == -1) {
            throw new IllegalArgumentException(String.format("Ordinal for resource reference: %s cannot be -1", reference.referenceId()));
        }
        if (reference.ordinal() < 0) {
            throw new IllegalArgumentException(String.format("Ordinal for resource reference: %s cannot be negative", reference.referenceId()));
        }
        this.resourceId = class_2960.method_60654((String)reference.resourceId());
        this.referenceId = class_2960.method_60654((String)reference.referenceId());
        this.ordinal = reference.ordinal();
        this.codec = codec;
    }

    public Optional<T> retrieve() {
        if (this.resource == null) {
            return Optional.empty();
        }
        return Optional.of(this.resource);
    }

    public void fulfill(T elem) {
        this.resource = elem;
    }

    public class_2960 getReferenceId() {
        return this.referenceId;
    }

    public class_2960 getResourceId() {
        return this.resourceId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public MixsonCodec<T> getCodec() {
        return this.codec;
    }

    @Override
    public String getRuntimeMessage(class_2960 resourceId) {
        return String.format("Failed to capture %s file '%s' for reference '%s'\n", this.codec.extensionAndDot(), resourceId, this.referenceId);
    }

    @Override
    public String getRegistrationMessage() {
        return String.format("Failed to register reference '%s' for file '%s'\n", this.referenceId, this.resourceId);
    }

    @Override
    public boolean failSilently() {
        return false;
    }

    protected void clear() {
        this.resource = null;
    }
}

