/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.debug;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.ramixin.mixson.debug.CallCountEntry;
import net.ramixin.mixson.inline.Mixson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixsonCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mixson Debug");

    public static void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mixson").executes(context -> {
            for (String line : MixsonCommand.buildOutput()) {
                LOGGER.info(line);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Dumped Mixson event calls to console"), true);
            return 1;
        })).then(class_2170.method_9247((String)"clear").executes(context -> {
            Mixson.clearCalls();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"cleared Mixson event calls"), true);
            return 1;
        }))));
    }

    private static String fillToLength(String string, int length) {
        int repeatFor = length - string.length();
        if (repeatFor <= 0) {
            return string;
        }
        return string + " ".repeat(repeatFor);
    }

    private static List<String> buildOutput() {
        ArrayList<String> list = new ArrayList<String>();
        List<UUID> order = Mixson.getCallCountsOrder();
        LinkedHashMap<String, CallCountEntry> map = new LinkedHashMap<String, CallCountEntry>();
        if (order.isEmpty()) {
            String spacer = "-".repeat(30);
            list.add(spacer);
            list.add("no events have been called yet");
            list.add(spacer);
            return list;
        }
        for (UUID uUID : order) {
            map.put(Mixson.getEventName(uUID), Mixson.getCallCount(uUID));
        }
        int eventNameSpacing = 9;
        for (String eventName : map.keySet()) {
            if (eventName.length() <= eventNameSpacing) continue;
            eventNameSpacing = eventName.length();
        }
        list.add(MixsonCommand.fillToLength("event id ", ++eventNameSpacing) + "| Calls | File Operations");
        String string = "-".repeat(25 + eventNameSpacing);
        list.add(string);
        for (Map.Entry entry : map.sequencedEntrySet()) {
            CallCountEntry callCountEntry = (CallCountEntry)entry.getValue();
            list.add(MixsonCommand.fillToLength((String)entry.getKey(), eventNameSpacing) + "| " + MixsonCommand.fillToLength(String.valueOf(callCountEntry.eventCalls()), 6) + "| " + callCountEntry.fileOperations());
        }
        list.add(string);
        return list;
    }
}

