/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.atp.processors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import net.minecraft.class_2960;
import net.ramixin.mixson.MixsonError;
import net.ramixin.mixson.atp.BuiltAnnotationEvent;
import net.ramixin.mixson.atp.annotations.Reference;
import net.ramixin.mixson.atp.annotations.events.GenerativeMixsonEvent;
import net.ramixin.mixson.atp.annotations.events.MixsonEvent;
import net.ramixin.mixson.atp.processors.EventPreprocessors;
import net.ramixin.mixson.inline.BuiltResourceReference;
import net.ramixin.mixson.inline.EventContext;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.MixsonCodec;
import net.ramixin.mixson.inline.ResourceReference;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public interface EventProcessors {
    public static MixsonCodec<?> getCodec(String codec, String eventName) {
        MixsonCodec<Object> mixsonCodec = codec.isEmpty() ? Mixson.JSON_ELEMENT_CODEC : EventPreprocessors.getCodec(codec);
        if (mixsonCodec == null) {
            throw new MixsonError("unknown codec identifier '%s' for event '%s'", codec, eventName);
        }
        return mixsonCodec;
    }

    public static void handleMixsonEvent(MixsonEvent event, Method method, Logger logger) {
        EventProcessors.runRegisterAnnotation(MixsonEvent.Builder.build(event, method.getName(), EventProcessors.getCodec(event.codec(), event.eventName())), method, logger);
    }

    public static void handleGenerativeMixsonEvent(GenerativeMixsonEvent event, Method method, Logger logger) {
        Pair<String[], String[]> context = EventPreprocessors.getGeneratedIdentifiers(event.value(), event.external(), method.getDeclaringClass());
        String[] resourceIds = (String[])context.getA();
        String[] eventIds = (String[])context.getB();
        for (int i = 0; resourceIds.length > i; ++i) {
            EventProcessors.runRegisterAnnotation(GenerativeMixsonEvent.Builder.build(event, resourceIds[i], eventIds[i], EventProcessors.getCodec(event.codec(), eventIds[i])), method, logger);
        }
    }

    private static <T> void runRegisterAnnotation(BuiltAnnotationEvent<T> event, Method method, Logger logger) {
        String methodName = method.getName();
        if (method.getReturnType() != Void.TYPE) {
            throw new MixsonError("method '%s' must have return type void", methodName);
        }
        for (String resourceId : event.resourceIds()) {
            if (!resourceId.isEmpty()) continue;
            throw new MixsonError("empty resource id found for method '%s'", methodName);
        }
        logger.info("Expanding method '{}' in class '{}' with eventName '{}' in class '{}", new Object[]{methodName, method.getName(), event.eventName(), method.getDeclaringClass().getName()});
        Parameter[] parameters = EventProcessors.getAndValidateParameters(method);
        ArrayList<ResourceReference> referencesList = new ArrayList<ResourceReference>();
        ArrayList<class_2960> referenceIdsList = new ArrayList<class_2960>();
        for (int i = 1; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Reference reference = parameter.getAnnotation(Reference.class);
            if (reference == null) {
                throw new MixsonError("proceeding parameters must be annotated with @Reference in method '%s'", methodName);
            }
            String name = reference.referenceId().isEmpty() ? BuiltAnnotationEvent.generateEventName(parameter.getName()) : reference.referenceId();
            referenceIdsList.add(class_2960.method_60654((String)name));
            referencesList.add(new ResourceReference(reference.priority(), reference.value(), name));
        }
        class_2960[] referenceIds = (class_2960[])referenceIdsList.toArray(class_2960[]::new);
        ResourceReference[] references = (ResourceReference[])referencesList.toArray(ResourceReference[]::new);
        for (String resourceId : event.resourceIds()) {
            Mixson.registerEvent(event.codec(), event.priority(), resourceId, event.eventName(), context -> EventProcessors.runEventIntermediate(method, context, referenceIds, logger), event.failSilently(), references);
        }
    }

    private static Parameter[] getAndValidateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            throw new MixsonError("method '%s' must have first parameter of type 'EventContext'", method.getName());
        }
        if (parameters[0].getType() != EventContext.class) {
            throw new MixsonError("method '%s' must have first parameter of type 'EventContext'", method.getName());
        }
        if (parameters[0].isAnnotationPresent(Reference.class)) {
            throw new MixsonError("first parameter of method '%s' cannot have @Reference annotation", method.getName());
        }
        for (int i = 1; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.getType() == BuiltResourceReference.class) continue;
            throw new MixsonError("method '%s' must have proceeding parameters of type 'BuiltResourceReference'", method.getName());
        }
        return parameters;
    }

    private static <T> Object[] buildParameters(EventContext<T> context, class_2960[] referenceIds) {
        Object[] parameters = new Object[referenceIds.length + 1];
        parameters[0] = context;
        for (int i = 0; i < referenceIds.length; ++i) {
            parameters[i + 1] = context.getReference(String.valueOf(referenceIds[i]));
        }
        return parameters;
    }

    private static <T> void runEventIntermediate(Method method, EventContext<T> context, class_2960[] referenceIds, Logger logger) {
        try {
            method.setAccessible(true);
            method.invoke(null, EventProcessors.buildParameters(context, referenceIds));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace(System.err);
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                logger.error(stackTraceElement.toString());
            }
            throw new MixsonError(e);
        }
    }
}

