/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.atp.annotations.events;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.ramixin.mixson.atp.BuiltAnnotationEvent;
import net.ramixin.mixson.inline.MixsonCodec;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MixsonEvent {
    public String[] value();

    public String eventName() default "";

    public int priority() default 1000;

    public boolean failSilently() default false;

    public int ordinal() default -1;

    public String codec() default "";

    public static interface Builder {
        public static <T> BuiltAnnotationEvent<T> build(MixsonEvent event, String methodName, MixsonCodec<T> codec) {
            return new BuiltAnnotationEvent<T>(event.value(), event.eventName().isEmpty() ? BuiltAnnotationEvent.generateEventName(methodName) : event.eventName(), event.priority(), event.failSilently(), event.ordinal(), codec);
        }
    }
}

