/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.mixson.atp;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.ramixin.mixson.atp.annotations.Codec;
import net.ramixin.mixson.atp.annotations.Generator;
import net.ramixin.mixson.atp.annotations.events.GenerativeMixsonEvent;
import net.ramixin.mixson.atp.annotations.events.MixsonEvent;
import net.ramixin.mixson.atp.processors.EventPreprocessors;
import net.ramixin.mixson.atp.processors.EventProcessors;
import org.apache.commons.lang3.function.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixsonAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"mixsonAPT");

    public static void processClass(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            MixsonAnnotationProcessor.preprocessMethod(method);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            MixsonAnnotationProcessor.processMethod(method);
        }
    }

    private static void processMethod(Method method) {
        MixsonAnnotationProcessor.enforceExclusivity(method, MixsonEvent.class, GenerativeMixsonEvent.class, Generator.class, Codec.class);
        MixsonAnnotationProcessor.processAnnotation(MixsonEvent.class, method, EventProcessors::handleMixsonEvent);
        MixsonAnnotationProcessor.processAnnotation(GenerativeMixsonEvent.class, method, EventProcessors::handleGenerativeMixsonEvent);
    }

    private static void preprocessMethod(Method method) {
        MixsonAnnotationProcessor.processAnnotation(Generator.class, method, EventPreprocessors::handleGenerator);
        MixsonAnnotationProcessor.processAnnotation(Codec.class, method, EventPreprocessors::handleCodec);
    }

    private static <T extends Annotation> void processAnnotation(Class<T> annotationClazz, Method method, TriConsumer<T, Method, Logger> callback) {
        T annotation = method.getAnnotation(annotationClazz);
        if (annotation == null) {
            return;
        }
        callback.accept(annotation, (Object)method, (Object)LOGGER);
    }

    @SafeVarargs
    private static void enforceExclusivity(Method method, Class<? extends Annotation> ... annotations) {
        boolean safe = true;
        for (Class<? extends Annotation> annotation : annotations) {
            if (!method.isAnnotationPresent(annotation)) continue;
            if (safe) {
                safe = false;
                continue;
            }
            throw new IllegalStateException(String.format("method '%s' can only be annotated with one of the following: '%s'", method.getName(), Arrays.stream(annotations).map(Class::getName).collect(Collectors.toList())));
        }
    }
}

