/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.bytecodecs.defaults;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.defaults.PairCodec;
import com.teamresourceful.bytecodecs.utils.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;

public record MapCodec<K, V>(PairCodec<K, V> codec) implements ByteCodec<Map<K, V>>
{
    public MapCodec(ByteCodec<K> keyCodec, ByteCodec<V> valueCodec) {
        this(new PairCodec<K, V>(keyCodec, valueCodec));
    }

    @Override
    public void encode(Map<K, V> value, ByteBuf buffer) {
        ByteBufUtils.writeVarInt(buffer, value.size());
        value.entrySet().forEach(entry -> this.codec.encode((Map.Entry<K, V>)entry, buffer));
    }

    @Override
    public Map<K, V> decode(ByteBuf buffer) {
        int size = ByteBufUtils.readVarInt(buffer);
        LinkedHashMap map = new LinkedHashMap(size);
        for (int i = 0; i < size; ++i) {
            Object entry = this.codec.decode(buffer);
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }
}

