/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.bytecodecs.base;

import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.defaults.CollectionCodec;
import com.teamresourceful.bytecodecs.defaults.EnumCodec;
import com.teamresourceful.bytecodecs.defaults.KeyDispatchCodec;
import com.teamresourceful.bytecodecs.defaults.MapCodec;
import com.teamresourceful.bytecodecs.defaults.MapDispatchCodec;
import com.teamresourceful.bytecodecs.defaults.MappingCodec;
import com.teamresourceful.bytecodecs.defaults.OptionalCodec;
import com.teamresourceful.bytecodecs.defaults.OptionalSupplierCodec;
import com.teamresourceful.bytecodecs.defaults.PairCodec;
import com.teamresourceful.bytecodecs.defaults.PassthroughCodec;
import com.teamresourceful.bytecodecs.defaults.StringCodec;
import com.teamresourceful.bytecodecs.defaults.UnitCodec;
import com.teamresourceful.bytecodecs.utils.ByteBufUtils;
import com.teamresourceful.bytecodecs.utils.Either;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ByteCodec<T> {
    public static final ByteCodec<String> STRING = StringCodec.INSTANCE;
    public static final ByteCodec<String> STRING_COMPONENT = StringCodec.COMPONENT_LENGTH;
    public static final ByteCodec<Character> CHAR = new PassthroughCodec<Character>((buf, value) -> buf.writeChar((int)value.charValue()), ByteBuf::readChar);
    public static final ByteCodec<Boolean> BOOLEAN = new PassthroughCodec<Boolean>(ByteBuf::writeBoolean, ByteBuf::readBoolean);
    public static final ByteCodec<Byte> BYTE = new PassthroughCodec<Byte>((buf, value) -> buf.writeByte((int)value.byteValue()), ByteBuf::readByte);
    public static final ByteCodec<Short> SHORT = new PassthroughCodec<Short>((buf, value) -> buf.writeShort((int)value.shortValue()), ByteBuf::readShort);
    public static final ByteCodec<Integer> INT = new PassthroughCodec<Integer>(ByteBuf::writeInt, ByteBuf::readInt);
    public static final ByteCodec<Integer> VAR_INT = new PassthroughCodec<Integer>(ByteBufUtils::writeVarInt, ByteBufUtils::readVarInt);
    public static final ByteCodec<Integer> ZIGZAG_VAR_INT = new PassthroughCodec<Integer>(ByteBufUtils::writeZigZagVarInt, ByteBufUtils::readZigZagVarInt);
    public static final ByteCodec<Long> LONG = new PassthroughCodec<Long>(ByteBuf::writeLong, ByteBuf::readLong);
    public static final ByteCodec<Long> VAR_LONG = new PassthroughCodec<Long>(ByteBufUtils::writeVarLong, ByteBufUtils::readVarLong);
    public static final ByteCodec<Float> FLOAT = new PassthroughCodec<Float>(ByteBuf::writeFloat, ByteBuf::readFloat);
    public static final ByteCodec<Double> DOUBLE = new PassthroughCodec<Double>(ByteBuf::writeDouble, ByteBuf::readDouble);
    public static final ByteCodec<UUID> UUID = new PassthroughCodec<UUID>(ByteBufUtils::writeUUID, ByteBufUtils::readUUID);

    public void encode(T var1, ByteBuf var2);

    public T decode(ByteBuf var1);

    default public ByteCodec<List<T>> listOf() {
        return this.collectionOf(ArrayList::new);
    }

    default public ByteCodec<Set<T>> setOf() {
        return this.collectionOf(HashSet::new);
    }

    default public ByteCodec<Set<T>> linkedSetOf() {
        return this.collectionOf(LinkedHashSet::new);
    }

    default public <C extends Collection<T>> ByteCodec<C> collectionOf(Function<Integer, C> getter) {
        return new CollectionCodec(this, getter);
    }

    default public ByteCodec<Optional<T>> optionalOf() {
        return new OptionalCodec<Object>(this, null);
    }

    default public ByteCodec<Optional<T>> optionalOf(T value) {
        return new OptionalCodec<T>(this, value);
    }

    default public ByteCodec<Optional<T>> optionalOf(Supplier<T> value) {
        return new OptionalSupplierCodec<T>(this, value);
    }

    default public ByteCodec<@Nullable T> nullableOf() {
        return this.optionalOf().map(o -> o.orElse(null), Optional::ofNullable);
    }

    default public <O> ObjectEntryByteCodec<O, T> fieldOf(Function<O, T> getter) {
        return new ObjectEntryByteCodec<O, T>(this, getter);
    }

    default public <O> ObjectEntryByteCodec<O, Optional<T>> optionalFieldOf(Function<O, Optional<T>> getter) {
        return new ObjectEntryByteCodec<O, Optional<T>>(this.optionalOf(), getter);
    }

    default public <O> ObjectEntryByteCodec<O, Optional<T>> optionalFieldOf(T value, Function<O, Optional<T>> getter) {
        return new ObjectEntryByteCodec<O, Optional<T>>(this.optionalOf(value), getter);
    }

    default public <O> ObjectEntryByteCodec<O, Optional<T>> optionalFieldOf(Supplier<T> value, Function<O, Optional<T>> getter) {
        return new ObjectEntryByteCodec<O, Optional<T>>(this.optionalOf(value), getter);
    }

    default public <O> ObjectEntryByteCodec<O, @Nullable T> nullableFieldOf(Function<O, T> getter) {
        return new ObjectEntryByteCodec<O, T>(this.nullableOf(), getter);
    }

    default public <O> ObjectEntryByteCodec<O, T> nullableFieldOf(T value, Function<O, T> getter) {
        ByteCodec<Object> codec = this.optionalOf(value).map(Optional::get, Optional::of);
        return new ObjectEntryByteCodec<O, Object>(codec, getter);
    }

    default public <O> ObjectEntryByteCodec<O, T> nullableFieldOf(Supplier<@NotNull T> value, Function<O, T> getter) {
        ByteCodec<Object> codec = this.optionalOf(value).map(Optional::get, Optional::of);
        return new ObjectEntryByteCodec<O, Object>(codec, getter);
    }

    default public <R> ByteCodec<R> map(Function<T, R> decoder, Function<R, T> encoder) {
        return new MappingCodec<T, R>(this, decoder, encoder);
    }

    default public <O> ByteCodec<O> dispatch(Function<T, ByteCodec<O>> getter, Function<O, T> keyGetter) {
        return new KeyDispatchCodec<T, O>(this, getter, keyGetter);
    }

    default public <O> ByteCodec<Map<T, O>> mapDispatch(Function<T, ByteCodec<O>> getter) {
        return new MapDispatchCodec<T, O>(this, getter);
    }

    public static <F, S> ByteCodec<Either<F, S>> either(ByteCodec<F> first, ByteCodec<S> second) {
        ByteCodec<Either> left = first.map(Either::ofLeft, Either::leftOrThrow);
        ByteCodec<Either> right = second.map(Either::ofRight, Either::rightOrThrow);
        return BOOLEAN.dispatch(value -> value != false ? left : right, Either::isLeft);
    }

    public static <T> ByteCodec<T> choice(ByteCodec<T> first, ByteCodec<T> second, Function<T, Either<T, T>> discriminator) {
        return ByteCodec.either(first, second).map(Either::value, discriminator);
    }

    public static <T extends Enum<T>> ByteCodec<T> ofEnum(Class<T> enumClass) {
        return new EnumCodec<T>(enumClass);
    }

    public static <T> ByteCodec<T> unit(T value) {
        return new UnitCodec<T>(value);
    }

    public static <T> ByteCodec<T> unit(Supplier<T> value) {
        return new UnitCodec<T>(value);
    }

    public static <T> ByteCodec<T> passthrough(BiConsumer<ByteBuf, T> encoder, Function<ByteBuf, T> decoder) {
        return new PassthroughCodec<T>(encoder, decoder);
    }

    public static <K, V> MapCodec<K, V> mapOf(ByteCodec<K> keyCodec, ByteCodec<V> valueCodec) {
        return new MapCodec<K, V>(keyCodec, valueCodec);
    }

    public static <K, V> PairCodec<K, V> pairOf(ByteCodec<K> keyCodec, ByteCodec<V> valueCodec) {
        return new PairCodec<K, V>(keyCodec, valueCodec);
    }
}

