/*
 * Decompiled with CFR 0.152.
 */
package com.bhaptics.haptic;

import com.bhaptics.haptic.EasyClient;
import com.bhaptics.haptic.HapticPlayer;
import com.bhaptics.haptic.models.DotPoint;
import com.bhaptics.haptic.models.Frame;
import com.bhaptics.haptic.models.PathPoint;
import com.bhaptics.haptic.models.PlayerRequest;
import com.bhaptics.haptic.models.PositionType;
import com.bhaptics.haptic.models.RegisterRequest;
import com.bhaptics.haptic.models.RotationOption;
import com.bhaptics.haptic.models.ScaleOption;
import com.bhaptics.haptic.models.SubmitRequest;
import com.bhaptics.haptic.models.tact.HapticFeedbackFile;
import com.bhaptics.haptic.utils.HapticPlayerCallback;
import com.bhaptics.haptic.utils.LogUtils;
import com.bhaptics.haptic.utils.StringUtils;
import com.google.gson.Gson;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class HapticPlayerImpl
implements HapticPlayer {
    private String url = "ws://127.0.0.1:15881/v2/feedbacks";
    private EasyClient client;
    private boolean isConnected;
    private String appId;
    private String appName;
    private boolean retryConnect;
    private Gson gson = new Gson();
    private List<HapticPlayerCallback> callbacks = new ArrayList<HapticPlayerCallback>();
    HapticPlayerCallback hapticPlayerCallback = new HapticPlayerCallback(){

        @Override
        public void onConnectionChange(boolean connected) {
            HapticPlayerImpl.this.isConnected = connected;
            for (HapticPlayerCallback callback : HapticPlayerImpl.this.callbacks) {
                callback.onConnectionChange(connected);
            }
            if (!HapticPlayerImpl.this.isConnected) {
                HapticPlayerImpl.this.resetConnection();
            }
        }
    };

    public HapticPlayerImpl(String appId, String appName) {
        this(appId, appName, false);
    }

    public HapticPlayerImpl(String appId, String appName, HapticPlayerCallback hapticPlayerCallback) {
        this(appId, appName, false);
        this.callbacks.add(hapticPlayerCallback);
    }

    public HapticPlayerImpl(String appId, String appName, boolean retryConnect, HapticPlayerCallback hapticPlayerCallback) {
        this(appId, appName, retryConnect);
        this.callbacks.add(hapticPlayerCallback);
    }

    public HapticPlayerImpl(String appId, String appName, boolean retryConnect) {
        this.appId = appId;
        this.appName = appName;
        this.retryConnect = retryConnect;
        LogUtils.log("HapticPlayerImpl()");
        this.connect();
    }

    private void connect() {
        try {
            this.client = new EasyClient(new URI(this.url + "?app_id=" + StringUtils.encodeValue(this.appId) + "&app_name=" + StringUtils.encodeValue(this.appName)));
            this.client.addHapticPlayerCallback(this.hapticPlayerCallback);
            this.client.connect();
        }
        catch (URISyntaxException e) {
            LogUtils.logError("HapticPlayerImpl() " + e.getMessage(), e);
        }
    }

    void resetConnection() {
        new Thread(() -> {
            if (this.retryConnect) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    LogUtils.trace(ie.getMessage());
                }
                this.connect();
            }
        }).start();
    }

    @Override
    public void dispose() {
        LogUtils.log("dispose()");
        try {
            this.client.closeBlocking();
        }
        catch (InterruptedException e) {
            LogUtils.log("dispose()" + e.getMessage());
        }
    }

    @Override
    public boolean isPlaying(String key) {
        return false;
    }

    @Override
    public boolean isPlaying() {
        return false;
    }

    @Override
    public void register(String key, String fileContent) {
        LogUtils.trace("register " + key + ", " + fileContent);
        HapticFeedbackFile o = (HapticFeedbackFile)this.gson.fromJson(fileContent, HapticFeedbackFile.class);
        RegisterRequest req = new RegisterRequest(key, o.getProject());
        this.sendRegisterRequest(req);
    }

    private void sendRegisterRequest(RegisterRequest req) {
        if (!this.isConnected) {
            LogUtils.log("not connected.");
            return;
        }
        PlayerRequest playerRequest = new PlayerRequest();
        playerRequest.addRegister(req);
        this.client.send(this.gson.toJson((Object)playerRequest));
    }

    private void sendSubmitRequest(SubmitRequest req) {
        if (!this.isConnected) {
            LogUtils.log("not connected.");
            return;
        }
        PlayerRequest playerRequest = new PlayerRequest();
        playerRequest.addSubmit(req);
        this.client.send(this.gson.toJson((Object)playerRequest));
    }

    @Override
    public void submitPath(String key, PositionType positionType, List<PathPoint> points, int durationMillis) {
        SubmitRequest req = new SubmitRequest();
        req.setKey(key);
        req.setType("frame");
        Frame frame = new Frame();
        frame.setDurationMillis(durationMillis);
        frame.setPosition(positionType);
        frame.setDotPoints(Arrays.asList(new DotPoint[0]));
        frame.setPathPoints(points);
        req.setFrame(frame);
        this.sendSubmitRequest(req);
    }

    @Override
    public void submitDot(String key, PositionType positionType, List<DotPoint> points, int durationMillis) {
        SubmitRequest req = new SubmitRequest();
        req.setKey(key);
        req.setType("frame");
        Frame frame = new Frame();
        frame.setDurationMillis(durationMillis);
        frame.setPosition(positionType);
        frame.setDotPoints(points);
        frame.setPathPoints(Arrays.asList(new PathPoint[0]));
        req.setFrame(frame);
        this.sendSubmitRequest(req);
    }

    @Override
    public void submitRegistered(String key) {
        LogUtils.log("submitRegistered: " + key);
        SubmitRequest req = new SubmitRequest();
        req.setKey(key);
        req.setType("key");
        this.sendSubmitRequest(req);
    }

    @Override
    public void submitRegistered(String key, String altKey, RotationOption rotationOption, ScaleOption scaleOption) {
        LogUtils.log("submitRegistered: " + key);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("altKey", altKey);
        parameters.put("rotationOption", rotationOption);
        parameters.put("scaleOption", scaleOption);
        SubmitRequest req = new SubmitRequest();
        req.setKey(key);
        req.setType("key");
        req.setParameters(parameters);
        this.sendSubmitRequest(req);
    }

    @Override
    public void turnOff(String key) {
        SubmitRequest req = new SubmitRequest();
        req.setKey(key);
        req.setType("turnOff");
        this.sendSubmitRequest(req);
    }

    @Override
    public void turnOff() {
        SubmitRequest req = new SubmitRequest();
        req.setKey("");
        req.setType("turnOffAll");
        this.sendSubmitRequest(req);
    }
}

