/*
 * Decompiled with CFR 0.152.
 */
package com.bhaptics.haptic;

import com.bhaptics.haptic.utils.HapticPlayerCallback;
import com.bhaptics.haptic.utils.LogUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class EasyClient
extends WebSocketClient {
    private boolean isConnected = false;
    private List<HapticPlayerCallback> callbacks = new ArrayList<HapticPlayerCallback>();

    public EasyClient(URI serverUri) {
        super(serverUri);
    }

    public void addHapticPlayerCallback(HapticPlayerCallback callback) {
        this.callbacks.add(callback);
    }

    private void fireCallback() {
        for (HapticPlayerCallback callback : this.callbacks) {
            callback.onConnectionChange(this.isConnected);
        }
    }

    public void onOpen(ServerHandshake handshakedata) {
        LogUtils.log("connection established.");
        this.isConnected = true;
        this.fireCallback();
    }

    public void onMessage(String message) {
        LogUtils.trace("received." + message);
    }

    public void onClose(int code, String reason, boolean remote) {
        LogUtils.trace("connection closed.");
        this.isConnected = false;
        this.fireCallback();
    }

    public void onError(Exception ex) {
        LogUtils.logError("onError() : " + ex.getMessage(), ex);
    }

    public boolean isConnected() {
        return this.isConnected;
    }
}

