/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.world;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentFactory;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.world.WorldComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.world.WorldComponentInitializer;
import org.ladysnake.cca.internal.base.QualifiedComponentFactory;
import org.ladysnake.cca.internal.base.asm.CcaAsmHelper;
import org.ladysnake.cca.internal.base.asm.StaticComponentLoadingException;
import org.ladysnake.cca.internal.base.asm.StaticComponentPluginBase;

public final class StaticWorldComponentPlugin
extends StaticComponentPluginBase<class_1937, WorldComponentInitializer>
implements WorldComponentFactoryRegistry {
    public static final StaticWorldComponentPlugin INSTANCE = new StaticWorldComponentPlugin();
    private final Map<@Nullable class_5321<class_1937>, Map<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<class_1937, ?>>>> worldComponentFactories = new Reference2ObjectOpenHashMap();

    private static String getSuffix(@Nullable class_5321<class_1937> dimensionId) {
        return "WorldImpl" + (String)(dimensionId == null ? "" : "_" + CcaAsmHelper.getJavaIdentifierName((class_2960)dimensionId.method_29177()));
    }

    private StaticWorldComponentPlugin() {
        super("loading a world", class_1937.class);
    }

    public boolean requiresStaticFactory(class_5321<class_1937> dimensionId) {
        INSTANCE.ensureInitialized();
        return this.worldComponentFactories.containsKey(dimensionId);
    }

    public ComponentContainer.Factory<class_1937> buildDedicatedFactory(@Nullable class_5321<class_1937> dimensionId) {
        INSTANCE.ensureInitialized();
        LinkedHashMap compiled = new LinkedHashMap(this.worldComponentFactories.getOrDefault(null, Collections.emptyMap()));
        compiled.putAll(this.worldComponentFactories.getOrDefault(dimensionId, Collections.emptyMap()));
        ComponentContainer.Factory.Builder builder = ComponentContainer.Factory.builder(class_1937.class).factoryNameSuffix(StaticWorldComponentPlugin.getSuffix(dimensionId));
        for (Map.Entry<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<class_1937, ?>>> entry : compiled.entrySet()) {
            this.addToBuilder((ComponentContainer.Factory.Builder<class_1937>)builder, entry);
        }
        return builder.build();
    }

    private <C extends Component> void addToBuilder(ComponentContainer.Factory.Builder<class_1937> builder, Map.Entry<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<class_1937, ?>>> entry) {
        ComponentKey<?> key = entry.getKey();
        ComponentFactory factory = (ComponentFactory)entry.getValue().factory();
        Class impl = entry.getValue().impl();
        builder.component(key, impl, factory, entry.getValue().dependencies());
    }

    protected Collection<EntrypointContainer<WorldComponentInitializer>> getEntrypoints() {
        return StaticWorldComponentPlugin.getComponentEntrypoints((String)"cardinal-components-world", WorldComponentInitializer.class);
    }

    protected void dispatchRegistration(WorldComponentInitializer entrypoint) {
        entrypoint.registerWorldComponentFactories(this);
    }

    @Override
    public <C extends Component> void register(ComponentKey<C> type, ComponentFactory<class_1937, ? extends C> factory) {
        this.checkLoading(WorldComponentFactoryRegistry.class, "register");
        this.register0(null, type, new QualifiedComponentFactory(factory, type.getComponentClass(), Set.of()));
    }

    @Override
    public <C extends Component> void register(ComponentKey<? super C> type, Class<C> impl, ComponentFactory<class_1937, ? extends C> factory) {
        this.checkLoading(WorldComponentFactoryRegistry.class, "register");
        this.register0(null, type, new QualifiedComponentFactory(factory, type.getComponentClass(), Set.of()));
    }

    @Override
    public <C extends Component> void registerFor(class_5321<class_1937> dimensionId, ComponentKey<C> type, ComponentFactory<class_1937, ? extends C> factory) {
        this.checkLoading(WorldComponentFactoryRegistry.class, "register");
        this.register0(dimensionId, type, new QualifiedComponentFactory(factory, type.getComponentClass(), Set.of()));
    }

    @Override
    public <C extends Component> void registerFor(class_5321<class_1937> dimensionId, ComponentKey<? super C> type, Class<C> impl, ComponentFactory<class_1937, ? extends C> factory) {
        this.checkLoading(WorldComponentFactoryRegistry.class, "register");
        this.register0(dimensionId, type, new QualifiedComponentFactory(factory, impl, Set.of()));
    }

    private <C extends Component> void register0(@Nullable class_5321<class_1937> dimensionId, ComponentKey<? super C> type, QualifiedComponentFactory<ComponentFactory<class_1937, ? extends C>> factory) {
        Map specializedMap = this.worldComponentFactories.computeIfAbsent(dimensionId, t -> new LinkedHashMap());
        QualifiedComponentFactory previousFactory = (QualifiedComponentFactory)specializedMap.get(type);
        if (previousFactory != null) {
            throw new StaticComponentLoadingException("Duplicate factory declarations for %s on %s: %s and %s".formatted(type.getId(), dimensionId, factory, previousFactory));
        }
        QualifiedComponentFactory<ComponentFactory<class_1937, ? extends C>> factory1 = factory;
        specializedMap.put(type, factory1);
    }
}

