/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.world;

import com.mojang.datafixers.util.Unit;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentProvider;
import org.ladysnake.cca.api.v3.world.WorldSyncCallback;
import org.ladysnake.cca.internal.base.ComponentUpdatePayload;
import org.ladysnake.cca.internal.base.MorePacketCodecs;
import org.ladysnake.cca.internal.world.StaticWorldComponentPlugin;

public final class CardinalComponentsWorld {
    public static final class_8710.class_9154<ComponentUpdatePayload<Unit>> PACKET_ID = ComponentUpdatePayload.id((String)"world_sync");
    private static final Map<@Nullable class_5321<class_1937>, // Could not load outer class - annotation placement on inner may be incorrect
    ComponentContainer.Factory<class_1937>> worldContainerFactories = new IdentityHashMap<class_5321<class_1937>, ComponentContainer.Factory<class_1937>>();

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            ComponentUpdatePayload.register(PACKET_ID, (class_9139)MorePacketCodecs.EMPTY);
            WorldSyncCallback.EVENT.register((player, world) -> {
                ComponentProvider provider = (ComponentProvider)world;
                for (ComponentKey key : provider.getComponentContainer().keys()) {
                    key.syncWith(player, provider);
                }
            });
        }
        if (FabricLoader.getInstance().isModLoaded("fabric-lifecycle-events-v1")) {
            ServerWorldEvents.LOAD.register((server, world) -> ((ComponentProvider)world).getComponentContainer().onServerLoad());
            ServerWorldEvents.UNLOAD.register((server, world) -> ((ComponentProvider)world).getComponentContainer().onServerUnload());
        }
        StaticWorldComponentPlugin.INSTANCE.ensureInitialized();
    }

    public static ComponentContainer createComponents(class_1937 world) {
        return worldContainerFactories.computeIfAbsent((class_5321<class_1937>)world.method_27983(), CardinalComponentsWorld::getWorldComponentFactory).createContainer((Object)world);
    }

    private static synchronized ComponentContainer.Factory<class_1937> getWorldComponentFactory(class_5321<class_1937> dimensionKey) {
        ComponentContainer.Factory<class_1937> existing = worldContainerFactories.get(dimensionKey);
        if (existing != null) {
            return existing;
        }
        if (StaticWorldComponentPlugin.INSTANCE.requiresStaticFactory(dimensionKey)) {
            return StaticWorldComponentPlugin.INSTANCE.buildDedicatedFactory(dimensionKey);
        }
        return worldContainerFactories.computeIfAbsent(null, n -> StaticWorldComponentPlugin.INSTANCE.buildDedicatedFactory(null));
    }
}

