/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.entity;

import com.mojang.datafixers.util.Unit;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10179;
import net.minecraft.class_10181;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentProvider;
import org.ladysnake.cca.api.v3.entity.C2SSelfMessagingComponent;
import org.ladysnake.cca.api.v3.entity.PlayerSyncCallback;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;
import org.ladysnake.cca.api.v3.entity.TrackingStartCallback;
import org.ladysnake.cca.internal.base.ComponentUpdatePayload;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.internal.base.MorePacketCodecs;
import org.ladysnake.cca.internal.entity.StaticEntityComponentPlugin;
import org.ladysnake.cca.internal.entity.SwitchablePlayerEntity;

public final class CardinalComponentsEntity {
    public static final class_8710.class_9154<ComponentUpdatePayload<Integer>> PACKET_ID = ComponentUpdatePayload.id((String)"entity_sync");
    public static final class_8710.class_9154<ComponentUpdatePayload<Unit>> C2S_SELF_PACKET_ID = ComponentUpdatePayload.id((String)"player_message_c2s");
    private static final Set<class_2960> unknownC2SPlayerComponents = new HashSet<class_2960>();

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            ComponentUpdatePayload.register(PACKET_ID, (class_9139)class_9135.field_48550);
            PayloadTypeRegistry.playC2S().register(C2S_SELF_PACKET_ID, ComponentUpdatePayload.codec(C2S_SELF_PACKET_ID, (class_9139)MorePacketCodecs.EMPTY));
            PlayerSyncCallback.EVENT.register(player -> CardinalComponentsEntity.syncEntityComponents(player, (class_1297)player));
            TrackingStartCallback.EVENT.register(CardinalComponentsEntity::syncEntityComponents);
            ServerPlayNetworking.registerGlobalReceiver(C2S_SELF_PACKET_ID, (payload, ctx) -> {
                try {
                    Optional componentKey = payload.componentKey();
                    if (componentKey.isPresent()) {
                        Component patt0$temp = ((ComponentKey)componentKey.get()).getNullable((Object)ctx.player());
                        if (patt0$temp instanceof C2SSelfMessagingComponent) {
                            C2SSelfMessagingComponent synced = (C2SSelfMessagingComponent)patt0$temp;
                            synced.handleC2SMessage(payload.buf());
                        } else if (payload.required() && (unknownC2SPlayerComponents.add(payload.componentKeyId()) || FabricLoader.getInstance().isDevelopmentEnvironment())) {
                            ComponentsInternals.LOGGER.warn("[Cardinal Components API] Received an update for component {} from player {}, but this component is not registered for player entities", (Object)payload.componentKeyId(), (Object)ctx.player());
                        }
                    } else if (payload.required() && (unknownC2SPlayerComponents.add(payload.componentKeyId()) || FabricLoader.getInstance().isDevelopmentEnvironment())) {
                        ComponentsInternals.LOGGER.warn("[Cardinal Components API] Received an update for unknown component {} from player {}", (Object)payload.componentKeyId(), (Object)ctx.player());
                    }
                }
                finally {
                    payload.buf().release();
                }
            });
        }
        if (FabricLoader.getInstance().isModLoaded("fabric-lifecycle-events-v1")) {
            ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> ((ComponentProvider)entity).getComponentContainer().onServerLoad());
            ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> ((ComponentProvider)entity).getComponentContainer().onServerUnload());
        }
        ServerLivingEntityEvents.MOB_CONVERSION.register(RespawnCopyStrategy.EVENT_PHASE, CardinalComponentsEntity::copyData);
        ServerPlayerEvents.COPY_FROM.register(RespawnCopyStrategy.EVENT_PHASE, CardinalComponentsEntity::copyData);
        StaticEntityComponentPlugin.INSTANCE.ensureInitialized();
    }

    private static void copyData(class_1309 original, class_1309 clone, class_10179 context) {
        Set keys = ((ComponentProvider)original).getComponentContainer().keys();
        for (ComponentKey key : keys) {
            if (!key.isProvidedBy((Object)clone)) continue;
            CardinalComponentsEntity.copyData(original, clone, (class_7225.class_7874)original.method_56673(), false, context.comp_3145(), context.comp_3144() == class_10181.field_54080, key);
        }
    }

    private static void copyData(class_3222 original, class_3222 clone, boolean lossless) {
        boolean keepInventory = original.method_51469().method_64395().method_8355(class_1928.field_19389) || clone.method_7325();
        Set keys = ((ComponentProvider)original).getComponentContainer().keys();
        for (ComponentKey key : keys) {
            CardinalComponentsEntity.copyData((class_1309)original, (class_1309)clone, (class_7225.class_7874)original.method_56673(), lossless, keepInventory, !((SwitchablePlayerEntity)original).cca$isSwitchingCharacter(), key);
        }
    }

    private static <C extends Component> void copyData(class_1309 original, class_1309 clone, class_7225.class_7874 registryLookup, boolean lossless, boolean keepInventory, boolean sameCharacter, ComponentKey<C> key) {
        Component from = key.get((Object)original);
        Component to = key.get((Object)clone);
        RespawnCopyStrategy.get(key, original.getClass()).copyForRespawn(from, to, registryLookup, lossless, keepInventory, sameCharacter);
    }

    private static void syncEntityComponents(class_3222 player, class_1297 tracked) {
        ComponentProvider provider = (ComponentProvider)tracked;
        for (ComponentKey key : provider.getComponentContainer().keys()) {
            key.syncWith(player, provider);
        }
    }
}

