/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.entity;

import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.CopyableComponent;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.internal.entity.CardinalEntityInternals;

@FunctionalInterface
public interface RespawnCopyStrategy<C extends Component> {
    public static final RespawnCopyStrategy<Component> ALWAYS_COPY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> RespawnCopyStrategy.copy(from, to, registryLookup);
    public static final RespawnCopyStrategy<Component> CHARACTER = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {
        if (sameCharacter) {
            RespawnCopyStrategy.copy(from, to, registryLookup);
        }
    };
    public static final RespawnCopyStrategy<Component> INVENTORY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {
        if (lossless || keepInventory) {
            RespawnCopyStrategy.copy(from, to, registryLookup);
        }
    };
    public static final RespawnCopyStrategy<Component> LOSSLESS_ONLY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {
        if (lossless) {
            RespawnCopyStrategy.copy(from, to, registryLookup);
        }
    };
    public static final RespawnCopyStrategy<Component> NEVER_COPY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {};
    public static final class_2960 EVENT_PHASE = class_2960.method_60655((String)"cardinal-components", (String)"component-copy");

    public static <C extends Component> RespawnCopyStrategy<? super C> get(ComponentKey<C> key, Class<? extends class_1309> entityClass) {
        return CardinalEntityInternals.getRespawnCopyStrategy(key, entityClass);
    }

    public static <C extends Component> void copy(C from, C to, class_7225.class_7874 registryLookup) {
        if (to instanceof CopyableComponent) {
            CopyableComponent copyable = (CopyableComponent)to;
            CardinalEntityInternals.copyAsCopyable(from, copyable, registryLookup);
        } else {
            try (class_8942.class_11340 errorReporter = new class_8942.class_11340(ComponentsInternals.LOGGER);){
                class_11362 writeView = class_11362.method_71459((class_8942)errorReporter, (class_7225.class_7874)registryLookup);
                from.writeData((class_11372)writeView);
                to.readData(class_11352.method_71417((class_8942)errorReporter, (class_7225.class_7874)registryLookup, (class_2487)writeView.method_71475()));
            }
        }
    }

    public void copyForRespawn(C var1, C var2, class_7225.class_7874 var3, boolean var4, boolean var5, boolean var6);
}

